# -*- ruby -*-
#
# Compare this program with sample51.rb.
#

require 'xtemplate'

data ={
  'links' => [
    {'url' => "url1", 'name' => "anchor1"},
    {'url' => "url2", 'name' => "anchor2"},
    {'url' => "url3", 'name' => "anchor3"},
  ],
  'urls' => [
    {'url' => "url1"},
    {'url' => "url2"},
    {'url' => "url3"},
  ],
  'names' => [
    {'name' => "anchor1"},
    {'name' => "anchor2"},
    {'name' => "anchor3"},
  ]
}

text = <<EOF
<?xml version="1.0" encoding="EUC-JP"?>
<html xmlns:xt="http://xtemplate.sourceforge.net/xtemplate">
<body>
  <ul>
    <!-- one of 'my_links', 'urls', and 'names' are used for expansion. -->
    <xt:select id="/links" alt="alt01">
      <li><a><xt:select id="url{@href}" /><xt:select id="name" /></a></li>
    </xt:select>
    <xt:select id="/urls" alt="alt01">
      <li><a><xt:select id="url{@href}" /><xt:select id="url" /></a></li>
    </xt:select>
    <xt:select id="/urls" alt="alt01">
      <li><xt:select id="name" /></li>
    </xt:select>
  </ul>
</body>
</html>
EOF

t = XTemplate::XMLTemplate.new(text)
print(t.expand(data))
