/***************************************************************************
 *
 * Copyright (c) 2000,2001,2002 BalaBit IT Ltd, Budapest, Hungary
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: connect.h,v 1.8.2.2 2003/04/11 19:15:54 sasa Exp $
 *
 ***************************************************************************/

#ifndef ZORP_CONNECT_H_INCLUDED
#define ZORP_CONNECT_H_INCLUDED


#include <zorp/zorplib.h>
#include <zorp/sockaddr.h>
#include <zorp/socket.h>

#ifdef __cplusplus
extern "C" {
#endif

/* z_io_connect public interface */

/*+

  Connect to the given socket address using the given local address,
  and call a given callback function if the connection is established.

  +*/
typedef struct _ZIOConnect 
{
  ZSockAddr *local;
} ZIOConnect;

typedef void (*ZConnectFunc)(gint fd, gpointer user_data);

ZIOConnect *
z_io_connect_new(ZSockAddr *local, 
                 ZSockAddr *remote,
		 ZConnectFunc callback,
		 gpointer user_data);

ZSockAddr *z_io_connect_start_block(ZIOConnect *self);
ZSockAddr *z_io_connect_start(ZIOConnect *self);
ZSockAddr *z_io_connect_start_in_context(ZIOConnect *self, GMainContext *context);
void z_io_connect_ref(ZIOConnect *l);
void z_io_connect_unref(ZIOConnect *l);
void z_io_connect_set_timeout(ZIOConnect *l, gint timeout);
void z_io_connect_set_destroy_notify(ZIOConnect *l, GDestroyNotify notify);
void z_io_connect_cancel(ZIOConnect *l);

#ifdef __cplusplus
}
#endif
#endif
