/***************************************************************************
 *
 * Copyright (c) 2000,2001,2002 BalaBit IT Ltd, Budapest, Hungary
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: registry.h,v 1.7.2.2 2003/04/11 19:15:54 sasa Exp $
 *
 ***************************************************************************/

#ifndef ZORP_REGISTRY_H_INCLUDED
#define ZORP_REGISTRY_H_INCLUDED

#include <glib.h>

#ifdef __cplusplus
extern "C" {
#endif

#define MAX_PROXY_NAME 32

#define ZR_NONE      0
#define ZR_PROXY     1
#define ZR_PYPROXY   2
/* deprecated
#define ZR_DPROXY    3
*/
#define ZR_CONNTRACK 4
#define ZR_OTHER     5
#define ZR_MODULE    6
#define MAX_REGISTRY_TYPE 16

void z_registry_init(void);
void z_registry_destroy(void);
void z_registry_add(const gchar *name, gint type, gpointer value);
gpointer z_registry_get(const gchar *name, gint *type);
guint z_registry_has_key(const gchar *name);
void z_registry_foreach(gint type, GHFunc func, gpointer user_data);

#ifdef __cplusplus
}
#endif

#endif
