/***************************************************************************
 *
 * Copyright (c) 2000,2001,2002 BalaBit IT Ltd, Budapest, Hungary
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: thread.h,v 1.6.2.2 2003/07/07 17:31:49 sasa Exp $
 *
 ***************************************************************************/

#ifndef ZORP_THREAD_H_INCLUDED
#define ZORP_THREAD_H_INCLUDED

#include <zorp/zorplib.h>

#ifdef __cplusplus
extern "C" {
#endif

#define MAX_THREAD_NAME 128

/*+

  ZThread encapsulates a simple thread, and adds some meta information
  like thread name, thread id etc.

  +*/
typedef struct _ZThread
{
  GThread *thread;
  gint thread_id;
  gchar name[MAX_THREAD_NAME];
  GThreadFunc func;
  gpointer arg;
} ZThread;

/* extern GList *threads; */
extern gint max_threads, idle_threads;
extern gboolean use_threadpools;

void z_thread_register_start_callback(GFunc func, gpointer user_data);
void z_thread_register_stop_callback(GFunc func, gpointer user_data);

gboolean z_thread_new(gchar *name, GThreadFunc func, gpointer arg);

void z_thread_init(void);
void z_thread_destroy(void);
ZThread *z_thread_self(void);

#ifdef __cplusplus
}
#endif

#endif

