/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file BasicGraphicsObject.h
    \brief Implementation of BasicGraphicsObject class.
    \author Graphics Section, ECMWF

    Started: March 2004

*/
#ifndef Layer_H
#define Layer_H

#include "magics.h"

#include "Log.h"
#include "BasicGraphicsObject.h"
#include "DateTime.h"


namespace magics {

class LayerSharedInfo {
public:
	LayerSharedInfo(const string&);
	
	void visibility(bool visibility) { visibility_ = visibility; }
	void zindex(int zindex) { zindex_ = zindex; }
	void transparency(int transparency) { transparency_ = transparency; }
				
	bool visibility() const { return visibility_; }
	int transparency() const { return transparency_; }
	int zindex() const { return zindex_; }
	const string& id() const { return id_; }
protected:
	bool visibility_;
    int zindex_;
    int transparency_;
	string id_;
	

};

class Layer : public BasicGraphicsObjectContainer 
{
public: 
	Layer(const LayerSharedInfo&);
	~Layer() {};
	void print(ostream& out) const;
	
	virtual void redisplay(const BaseDriver& driver) const ;
	
	void visibility(bool visibility) { visibility_ = visibility; }
	void zindex(int zindex) { zindex_ = zindex; }
	void transparency(int transparency) { transparency_ = transparency; }
	void valid(const DateTime& from, const DateTime& to) { from_ = from; to_ = to; }
	
	bool visibility() const { return visibility_; }
	int transparency() const { return transparency_; }
	int zindex() const { return zindex_; }
	
	const string& id() const {  return id_; }
	void id(const string& id) { id_ = id; }
	
	const string& name() const {  return name_; }
	void name(const string& id) { name_ = id; }
	
	string timeStamp(const string&) const;
	string timeBegin(const string&) const;
	string timeEnd(const string&) const;
	
	string kmlTimeBegin() const;
	string kmlTimeEnd() const;
	string kmlTimeStamp() const ;
	vector<pair<string, string>  >::const_iterator iconsBegin() { return icons_.begin(); }
	vector<pair<string, string>  >::const_iterator iconsEnd() { return icons_.end(); }
	void  icon(const string& iconname, const string& iconclass) {  icons_.push_back(make_pair(iconname, iconclass)); }
	
protected:
	bool visibility_;
	int zindex_;
	int transparency_;
	
	// For Metview ...
	vector<pair<string, string>  > icons_;
	
	
	DateTime from_;
	DateTime to_;
	string id_;
	
};




class LayerManager: public map<string, LayerSharedInfo> 
{
protected :
	LayerManager() {}
	~LayerManager() {}
public :
	
	static LayerSharedInfo& get(const string&);
	static Layer* layer(const string&);
	
	static LayerManager manager_;
};

} // end of namespace

#endif
