
/*! \file MagicsEvent.h
    \brief Definition of the Template class MagicsEvent.
    
    Magics Team - ECMWF 2007
    
    Started: Thu 22-Nov-2007
    
    Changes:
    
*/

#ifndef MagicsEvent_H
#define MagicsEvent_H

#include "magics.h"
#include "MagicsObserver.h"
#include "Layer.h"

namespace magics {

#ifdef MAGICS_OPENGL
class OpenGLNode;
#endif

class MagicsEvent
{
public:
	MagicsEvent() {}	
	virtual ~MagicsEvent() {}	
	virtual void notify(MagicsObserver& ) {}
	
protected:
	//! Method to print string about this class on to a stream of type ostream (virtual).
	virtual void print(ostream& out) const { out << "MagicsEvent[]"; } 

private:
	//! Copy constructor - No copy allowed
	MagicsEvent(const MagicsEvent&);
	//! Overloaded << operator to copy - No copy allowed
	MagicsEvent& operator=(const MagicsEvent&);

	// -- Friends
	//! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const MagicsEvent& p)
		{ p.print(s); return s; }
};

class MagicsCursorEvent : public MagicsEvent
{
public:
	MagicsCursorEvent(const string& cursor = "") : cursor_(cursor) {}	
	virtual ~MagicsCursorEvent() {}	
	virtual void notify(MagicsObserver& observer) { observer.notify(*this); }
	const string& cursor() { return cursor_; }
		
protected:
	//! Method to print string about this class on to a stream of type ostream (virtual).
	virtual void print(ostream& out) const { out << "MagicsCursorEvent[cursor : " << cursor_ << "]"; } 
	string cursor_;
};
class MagicsSwapBufferEvent : public MagicsEvent
{
public:
	MagicsSwapBufferEvent() {}	
	virtual ~MagicsSwapBufferEvent() {}	
	virtual void notify(MagicsObserver& observer) { observer.notify(*this); }
		
		
protected:
	//! Method to print string about this class on to a stream of type ostream (virtual).
	virtual void print(ostream& out) const { out << "MagicsSwapBufferEvent[]"; } 
		
};

class MagicsAntialiasingEvent: public MagicsEvent
{
// From Uplot to driver!
public:
	MagicsAntialiasingEvent(bool set) : set_(set) {}	
	virtual ~MagicsAntialiasingEvent() {}	
	virtual void notify(MagicsObserver& observer) { observer.notify(*this); }
	bool set() const { return set_; }
		
protected:
	//! Method to print string about this class on to a stream of type ostream (virtual).
	virtual void print(ostream& out) const { 
		string set = ( set_ ) ? "on" : "false";
		out << "MagicsAntialiasingEvent[" << set  << "]"; 
	} 
	bool set_;		
};

class MagicsZoomEvent:  public MagicsEvent
{
// From Uplot to driver!
public:
	MagicsZoomEvent(bool set) : set_(set) {}	
	virtual ~MagicsZoomEvent() {}	
	void notify(MagicsObserver& observer) { observer.notify(*this); }
	bool set() const { return set_; }
		
protected:
	//! Method to print string about this class on to a stream of type ostream (virtual).
	virtual void print(ostream& out) const { 
		string set = ( set_ ) ? "on" : "false";
		out << "MagicsZoomEvent[" << set  << "]"; 
	} 
	bool set_;		
};

class MagicsMagnifierEvent:  public MagicsEvent
{
// From Uplot to driver!
public:
	MagicsMagnifierEvent(bool set) : set_(set) {}	
	virtual ~MagicsMagnifierEvent() {}	
	void notify(MagicsObserver& observer) { observer.notify(*this); }
	bool set() const { return set_; }
		
protected:
	//! Method to print string about this class on to a stream of type ostream (virtual).
	virtual void print(ostream& out) const { 
		string set = ( set_ ) ? "on" : "false";
		out << "MagicsMagnifierEvent[" << set  << "]"; 
	} 
	bool set_;
		
};

class MagicsRestoreFbEvent:  public MagicsEvent
{
// From Uplot to driver!
public:
	MagicsRestoreFbEvent() {}	
	virtual ~MagicsRestoreFbEvent() {}	
	void notify(MagicsObserver& observer) { observer.notify(*this); }
protected:
	//! Method to print string about this class on to a stream of type ostream (virtual).
	virtual void print(ostream& out) const { 
		out << "MagicsRestoreFbEvent[" << "]"; }	
};

class MagicsAnimationStepData
{
public:
	MagicsAnimationStepData(vector<string>& label, bool /*cached*/) : label_(label), cached_(false) {};
	const vector<string>& label() const  {return label_;}
	bool cached() const {return cached_;}	
	void setLabel(vector<string>& s) {label_=s;}
	void setCached(bool b) {cached_=b;}
private:	
	vector<string> label_;
	bool           cached_;
};


class MagicsAnimationCurrentStepEvent:  public MagicsEvent
{
// From Uplot to driver!
public:
	MagicsAnimationCurrentStepEvent(int step) : step_(step) {}	
	virtual ~MagicsAnimationCurrentStepEvent() {}	
	void notify(MagicsObserver& observer) { observer.notify(*this); }
	int step() const { return step_; }
protected:
	//! Method to print string about this class on to a stream of type ostream (virtual).
	virtual void print(ostream& out) const { 
		out << "MagicsAnimationCurrentStepEvent[" << step_ << "]"; }	
	int step_;
};

class MagicsAnimationStepsEvent:  public MagicsEvent
{
// From Uplot to driver!
public:
	MagicsAnimationStepsEvent(vector<MagicsAnimationStepData> steps) : steps_(steps) {}	
	virtual ~MagicsAnimationStepsEvent() {}	
	void notify(MagicsObserver& observer) { observer.notify(*this); }
	const vector<MagicsAnimationStepData>& steps() const { return steps_; }
protected:
	//! Method to print string about this class on to a stream of type ostream (virtual).
	virtual void print(ostream& out) const { 
		out << "MagicsAnimationFramseEvent[" << "]"; }	
	vector<MagicsAnimationStepData>  steps_;
};

#ifdef MAGICS_OPENGL

class MagicsLayerTreeEvent:  public MagicsEvent
{
// From Uplot to driver!
public:
	MagicsLayerTreeEvent(OpenGLNode *rootNode) : rootNode_(rootNode) {}	
	virtual ~MagicsLayerTreeEvent() {}	
	void notify(MagicsObserver& observer) { observer.notify(*this); }
	OpenGLNode* rootNode() { return rootNode_; }
protected:
	//! Method to print string about this class on to a stream of type ostream (virtual).
	virtual void print(ostream& out) const
	{ 
		out << "MagicsLayerTreeEvent[" << "]";
	}	
	OpenGLNode* rootNode_;
};

class MagicsLayerSwapEvent:  public MagicsEvent
{
// From Uplot to driver!
public:
	MagicsLayerSwapEvent(OpenGLNode *first,OpenGLNode* second) : firstNode_(first), secondNode_(second) {}	
	virtual ~MagicsLayerSwapEvent() {}	
	void notify(MagicsObserver& observer) { observer.notify(*this); }
	OpenGLNode* firstNode() { return firstNode_; }
	OpenGLNode* secondNode() { return secondNode_; }
protected:
	//! Method to print string about this class on to a stream of type ostream (virtual).
	virtual void print(ostream& out) const
	{ 
		out << "MagicsLayerTreeEvent[" << "]";
	}	
	OpenGLNode* firstNode_;
	OpenGLNode* secondNode_;
};

#endif

class MagicsLayerUpdateEvent:  public MagicsEvent
{
// From Uplot to driver!
public:
	MagicsLayerUpdateEvent() {}	
	virtual ~MagicsLayerUpdateEvent() {}	
	void notify(MagicsObserver& observer) { observer.notify(*this); }
protected:
	//! Method to print string about this class on to a stream of type ostream (virtual).
	virtual void print(ostream& out) const { 
		out << "MagicsLayerUpdateEvent[" << "]"; }	
};

#ifdef MAGICS_OPENGL

class MagicsZoomUpdateEvent :  public MagicsEvent
{
public:
	MagicsZoomUpdateEvent(int levelNum, int actLevel, string layoutId,OpenGLNode* node) : 
 		levelNum_(levelNum), actLevel_(actLevel), layoutId_(layoutId), node_(node) {};
	virtual ~MagicsZoomUpdateEvent() {}	
	void notify(MagicsObserver& observer) { observer.notify(*this); }
	int levelNum() const {return levelNum_;} 
	int actLevel() const {return actLevel_;}
	const string& layoutId() const {return layoutId_;}
	OpenGLNode* node() const {return node_;}
private:	
	int levelNum_;
	int actLevel_;
	string layoutId_;
	OpenGLNode* node_;
};


class MagicsRenderZoomPreviewEvent :  public MagicsEvent
{
public:
	MagicsRenderZoomPreviewEvent(OpenGLNode *node,int x,int y, int tw, int th) : 
		node_(node), x_(x), y_(y), tw_(tw), th_(th) {};

	virtual ~MagicsRenderZoomPreviewEvent() {}	
	void notify(MagicsObserver& observer) { observer.notify(*this); }
	int x() const {return x_;} 
	int y() const {return y_;}
	int tw() const {return tw_;} 
	int th() const {return th_;}
	OpenGLNode* node() const {return node_;}

protected:
	//! Method to print string about this class on to a stream of type ostream (virtual).
	virtual void print(ostream& out) const { 
		out << "MagicsRenderZoomPreviewEvent[" << "]"; }	

private:	
	OpenGLNode* node_;
	int x_;
	int y_;
	int tw_;
	int th_;
};

#endif

struct MetviewIcon
{
public:
	MetviewIcon(const string& name = "", const string& cname = "" ) : iconName_(name), iconClass_(cname) {}
	void icon(const string& name, const string& cname) {  iconName_ = name; iconClass_ = cname; } 
	void visit(Layer& layer)
	{ 
		if ( !iconClass_.empty() && !iconName_.empty() )
			layer.icon(iconName_, iconClass_); 
	} 
	void icon(const MetviewIcon& other) { iconName_ = other.iconName_; iconClass_ = other.iconClass_; }
protected:
	string iconName_;
	string iconClass_;
};

} // namespace magics
#endif
