/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file MgQLayoutNode.h
    \brief Definition of MgQLayoutNode.
    \author Graphics Section, ECMWF

    Started: Februaryr 2010
*/

#ifndef _MgQLayoutNode_H
#define _MgQLayoutNode_H

#include <magics.h>
#include <Layout.h>
#include <PaperPoint.h>

#include "MgQBaseNode.h"

//namespace magics 
//{

class MgQLayoutNode : public MgQBaseNode 
{
public:
	//OpenGLLayoutNode();
	MgQLayoutNode(QString,const Layout &);

	virtual QRectF boundingRect() const;

	const Layout& layout() {return layout_;};
	AnimationRules* animationRules() {return layout_.animationRules();};
	//void animationRules(AnimationRules *anr) {animationRules_=anr;};

	void  coordRatioX(float f) {coordRatioX_=f;};	 
	void  coordRatioY(float f) {coordRatioY_=f;};
	float coordRatioX() {return coordRatioX_;};	 
	float coordRatioY() {return coordRatioY_;};

	void  dimensionX(float f) {dimensionX_=f;};	 
	void  dimensionY(float f) {dimensionY_=f;};
	float dimensionX() {return dimensionX_;};	 
	float dimensionY() {return dimensionY_;};

	float projectedMinX() {return projectedMinX_;}
	void  projectedMinX(float f) {projectedMinX_=f;}
	float projectedMinY() {return projectedMinY_;}
	void  projectedMinY(float f) {projectedMinY_=f;}

	float projectedMaxX() {return projectedMaxX_;}
	void  projectedMaxX(float f) {projectedMaxX_=f;}
	float projectedMaxY() {return projectedMaxY_;}
	void  projectedMaxY(float f) {projectedMaxY_=f;}

	void  mapFromSceneToGeoCoords(QPointF&,QPointF&); 
	void  mapFromSceneToGeoCoords(QRectF&,QList<QPointF>&); 

	MgQBaseNode* parentItemInMainScene() {return parentItemInMainScene_;}
	void setParentItemInMainScene(MgQBaseNode* p) {parentItemInMainScene_=p;}

	void addToMainScene();

protected:
	const Layout& layout_;	

	float coordRatioX_;
	float coordRatioY_;
	
	float dimensionX_;	
	float dimensionY_;

	float projectedMinX_;
	float projectedMinY_;
	float projectedMaxX_;
	float projectedMaxY_;

	MgQBaseNode *parentItemInMainScene_;
	//AnimationRules *animationRules_;			
};


class MgQPreviewLayoutNode : public MgQLayoutNode
{
public:
	MgQPreviewLayoutNode(QString n,const Layout &l) : MgQLayoutNode(n,l)  {};
};

class MgQMagnifierLayoutNode : public MgQLayoutNode
{
public:
	MgQMagnifierLayoutNode(QString n,const Layout &l) : MgQLayoutNode(n,l) {}; 
	const MagnifierLayout& layout() {return (MagnifierLayout&) layout_;};
	void clearPlotContents();

	const QVector<QPointF>& area() const {return area_;}
	float resolutionX() {return resolutionY_;}
	float resolutionY() {return resolutionY_;}
	AnimationStep* step() {return step_;}
	float zoomFactor() {return zoomFactor_;}

	void setArea(const QVector<QPointF> area) {area_=area;}
	void setResolutionX(float r) {resolutionX_=r;}
	void setResolutionY(float r) {resolutionY_=r;}
	void setStep(AnimationStep *step) {step_=step;}
	void setZoomFactor(float zoomFactor) {zoomFactor_=zoomFactor;}

	virtual QRectF boundingRect() const;	

protected:
	QVector<QPointF> area_;
	float resolutionX_;
	float resolutionY_;
	AnimationStep *step_;	
	float zoomFactor_;
};


//}


#endif
