/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file MgQPixmapItem.h
    \brief Definition of MgQPixmapItem.
    \author Graphics Section, ECMWF

    Started: Feb 2010
*/

#ifndef _MgQPixmapItem_H
#define _MgQPixmapItem_H

#include <QGraphicsPixmapItem>

class MgQPixmapItem : public QGraphicsPixmapItem
{
public:
	MgQPixmapItem(const QPixmap& pixmap,QGraphicsItem* parent = 0);
	~MgQPixmapItem();
	
	void setTargetRect(QRectF r) {targetRect_=r;}
	QRectF boundingRect() const;
	void paint(QPainter *, const QStyleOptionGraphicsItem *,
                QWidget *widget=0);

protected:
	QRectF targetRect_;

};	


#endif 
