#include "MgQPlotScene.h"

#include <QDebug>
#include <QGraphicsItem>

#include "MgQAnimation.h"
#include "MgQLayerNode.h"
#include "MgQLayoutNode.h"

MgQPlotScene::MgQPlotScene(QObject *parent) : QGraphicsScene(parent)
{
	animation_=0;
	prevCurrentStep_=0;
}

MgQPlotScene::~MgQPlotScene()
{
}

void MgQPlotScene::clearBeforeNewRequest()
{
	if(rootNode_)
	{
		removeItem(rootNode_);
		delete rootNode_;
		rootNode_=0;
	}

	//clear();

	if(animation_)
	{
		prevCurrentStep_=animation_->currentStep();
		delete animation_;
		animation_=0;
		
	}
	else
	{
		prevCurrentStep_=0;
	}

	layers_.clear();
}

MgQLayoutNode* MgQPlotScene::findZoomableLayout(QPointF pos)
{
	//QGraphicsItem* out=0;

	foreach(QGraphicsItem *item, items())
	{
		if(item->data(0).toString() == "Layout" && item->data(1).toString() == "Zoomable")
		{
			//MgQLayoutItem *layout=static_cast<MgQLayoutItem*>(item);
			//if(layout->layout().isZoomable()== true &&
			qDebug() << pos;
			qDebug() << item->mapFromScene(pos);
			if(item->contains(item->mapFromScene(pos)))
			{
				MgQLayoutNode *layout=static_cast<MgQLayoutNode*>(item);
				qDebug() << "children:" << layout->childItems().size()  << layout->isVisible();
				return layout;
			}
		}
	}

	return 0;		
}

MgQLayoutNode* MgQPlotScene::findZoomableLayout()
{
	foreach(QGraphicsItem *item, items())
	{
		if(item->data(0).toString() == "Layout" && item->data(1).toString() == "Zoomable")
		{
			
			MgQLayoutNode *layout=static_cast<MgQLayoutNode*>(item);
			return layout;
		}
	}

	return 0;		
}


MgQLayoutNode* MgQPlotScene::findPreviewLayout()
{
	foreach(QGraphicsItem *item, items())
	{
		if(item->data(0).toString() == "PreviewLayout")
		{
			
			MgQLayoutNode *layout=static_cast<MgQLayoutNode*>(item);
			return layout;
		}
	}

	return 0;		
}

MgQLayoutNode* MgQPlotScene::findMagnifierLayout()
{
	foreach(QGraphicsItem *item, items())
	{
		if(item->data(0).toString() == "MagnifierLayout")
		{
			
			MgQLayoutNode *layout=static_cast<MgQLayoutNode*>(item);
			return layout;
		}
	}

	return 0;		
}



MgQAnimation* MgQPlotScene::animation()
{
	return animation_;
}

void MgQPlotScene::addAnimation(MgQLayoutNode *node,MgQAnimation *animation)
{
	animation_=animation;
	//animation_->setCurrentStep(prevCurrentStep_);
}

void MgQPlotScene::selectCurrentStepForAnimation()
{
	if(!animation_)
		return;

	animation_->setCurrentStep(prevCurrentStep_);
}

void MgQPlotScene::scanLayers()
{
	layers_.clear();

	foreach(QGraphicsItem *item, items())
	{
		if(item->data(0).toString() == "Layer")
		{		
			MgQLayerNode *layer=static_cast<MgQLayerNode*>(item);
			layers_[layer->name()] << layer;
		}
	}
}

void MgQPlotScene::updateLayers(const QList<MgQLayerNode*>& modifiedLayers)
{
	scanLayers();

	foreach(MgQLayerNode* modifiedNode,modifiedLayers)
	{
		QString name=modifiedNode->name();
		if(layers_.contains(name))
		{
			foreach(MgQLayerNode* node,layers_[name])		
			{
				node->updateLayer(modifiedNode);
			}
		}
	}
}

const QList<MgQLayerNode*>& MgQPlotScene::uniqueLayers()
{
	scanLayers();

	uniqueLayers_.clear();

	QMapIterator<QString,QList<MgQLayerNode*> > it(layers_);
 	while (it.hasNext()) 
	{
     		it.next();
		if(it.value().count() > 0)
		{
     			uniqueLayers_ << it.value().first();
		}
 	}

	return uniqueLayers_;
}

void MgQPlotScene::updateMagnifier(float zoomFactor)
{
	//magnifierZoom_=zoom;
	
	MgQLayoutNode *lnode=findMagnifierLayout();
	if(!lnode) return;

	MgQMagnifierLayoutNode *node=static_cast<MgQMagnifierLayoutNode*>(lnode);

	node->clearPlotContents();

	/*if(zoomFactor  != node->zoomFactor())
	{
		node->clearPlotContents();
	}
	else
	{
		return;
	}*/	

	node->setZoomFactor(zoomFactor);

	QVector<QPointF> pp;

	pp.push_back(QPointF(node->layout().minX(),node->layout().minY()));
	pp.push_back(QPointF(node->layout().maxX(),node->layout().minY()));
	pp.push_back(QPointF(node->layout().maxX(),node->layout().maxY()));
	pp.push_back(QPointF(node->layout().minX(),node->layout().maxY()));

	node->setArea(pp);

	float textWidth = 70.+20;
	float textHeight = 40.;
		
	node->setResolutionX(textWidth/zoomFactor);
	node->setResolutionY(textHeight/zoomFactor);
	
	if(!animation_)
		return;

	node->setStep(animation_->currentStepObject());
		
	//Log::dev() << "GridValArea>  dx: " << fabsf(ldx) << " dy: " << fabsf(ldy) << endl;  
	for(int i=0; i <  pp.count() ; i++)
	{
		Log::dev() << " " << pp[i].x() << " " << pp[i].y() << endl;
	}	

	animation_->driver().redisplayMagnifier(node);
}

void MgQPlotScene::clearMagnifier()
{
	/*MgQLayoutNode *lnode=findMagnifierLayout();
	if(!lnode) return;

	MgQMagnifierLayoutNode *node=static_cast<MgQMagnifierLayoutNode*>(lnode);

	node->clearPlotContents();*/
}
