/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file AxisAttributes.cc
    \brief Implemtation of Axis Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Wed May  5 10:05:15 2010
*/    

#include "AxisAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "Translator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


AxisAttributes::AxisAttributes():
	method_(Translator<string, AxisMethod>().magics("axis_type")),
	control_(Translator<string, AxisControl>().magics("graph_axis_control")),
	orientation_(ParameterManager::getString("axis_orientation")),
	position_(ParameterManager::getString("axis_position")),
	line_(Translator<string, AxisLine>().magics("axis_line")),
	grid_(Translator<string, AxisGrid>().magics("axis_grid")),
	title_(Translator<string, AxisTitle>().magics("axis_title")),
	tick_(Translator<string, AxisTick>().magics("axis_tick")),
	minor_tick_(Translator<string, AxisMinorTick>().magics("axis_minor_tick")),
	label_(Translator<string, AxisTickLabel>().magics("axis_tick_label"))
{
} 



AxisAttributes::~AxisAttributes()
{
}

    
void AxisAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	prefix[0] = "axis";

	setMember(prefix, "axis_type", method_, params);
	setMember(prefix, "graph_axis_control", control_, params);
	setAttribute(prefix, "axis_orientation", orientation_, params);
	setAttribute(prefix, "axis_position", position_, params);
	setMember(prefix, "axis_line", line_, params);
	setMember(prefix, "axis_grid", grid_, params);
	setMember(prefix, "axis_title", title_, params);
	setMember(prefix, "axis_tick", tick_, params);
	setMember(prefix, "axis_minor_tick", minor_tick_, params);
	setMember(prefix, "axis_tick_label", label_, params);
}

void AxisAttributes::copy(const AxisAttributes& other)
{
	setMethod(other.method_->clone());
	setControl(other.control_->clone());
	orientation_ = other.orientation_;
	position_ = other.position_;
	setLine(other.line_->clone());
	setGrid(other.grid_->clone());
	setTitle(other.title_->clone());
	setTick(other.tick_->clone());
	setMinor_tick(other.minor_tick_->clone());
	setLabel(other.label_->clone());
} 


bool AxisAttributes::accept(const string& node)
{	
	if ( magCompare(node, "axis")  )
		return true;

	if ( acceptNode(node, method_) )
		return true;

	if ( acceptNode(node, control_) )
		return true;

	if ( acceptNode(node, line_) )
		return true;

	if ( acceptNode(node, grid_) )
		return true;

	if ( acceptNode(node, title_) )
		return true;

	if ( acceptNode(node, tick_) )
		return true;

	if ( acceptNode(node, minor_tick_) )
		return true;

	if ( acceptNode(node, label_) )
		return true;
	return false;
}

void AxisAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "axis") )
		set(node.attributes());
	else {
		setMember(node.name(), method_, node);
		setMember(node.name(), control_, node);
		setMember(node.name(), line_, node);
		setMember(node.name(), grid_, node);
		setMember(node.name(), title_, node);
		setMember(node.name(), tick_, node);
		setMember(node.name(), minor_tick_, node);
		setMember(node.name(), label_, node);
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
		setMember((*elt)->name(), method_, *(*elt)); 
		setMember((*elt)->name(), control_, *(*elt)); 
		setMember((*elt)->name(), line_, *(*elt)); 
		setMember((*elt)->name(), grid_, *(*elt)); 
		setMember((*elt)->name(), title_, *(*elt)); 
		setMember((*elt)->name(), tick_, *(*elt)); 
		setMember((*elt)->name(), minor_tick_, *(*elt)); 
		setMember((*elt)->name(), label_, *(*elt)); 
	}
}

void AxisAttributes::print(ostream& out)  const
{
	out << "AxisAttributes[";
	out << "method = " << *method_;
	out << ", control = " << *control_;
	out << ", orientation = " << orientation_;
	out << ", position = " << position_;
	out << ", line = " << *line_;
	out << ", grid = " << *grid_;
	out << ", title = " << *title_;
	out << ", tick = " << *tick_;
	out << ", minor_tick = " << *minor_tick_;
	out << ", label = " << *label_;
	out << "]" << "\n";
}


void AxisAttributes::toxml(ostream& out, const string& tag, int tabs)  const
{
	string tab;
	for ( int t = 0; t < tabs; t++) tab = tab + "	";
	
	out << tab << "<" << tag << "\n";
	out << tab << "\taxis_orientation = \'" << orientation_ << "\'\n";
	out << tab << "\taxis_position = \'" << position_ << "\'\n";
	out << tab << ">";

 	method_->toxml(out, tabs+1);
 	control_->toxml(out, tabs+1);
 	line_->toxml(out, tabs+1);
 	grid_->toxml(out, tabs+1);
 	title_->toxml(out, tabs+1);
 	tick_->toxml(out, tabs+1);
 	minor_tick_->toxml(out, tabs+1);
 	label_->toxml(out, tabs+1);

	out << tab << "</" << tag << ">\n";
}

static MagicsParameter<string> axis_type("axis_type", "regular", "");
static MagicsParameter<string> graph_axis_control("graph_axis_control", "off", "");
static MagicsParameter<string> axis_orientation("axis_orientation", "horizontal", "");
static MagicsParameter<string> axis_position("axis_position", "automatic", "");
static MagicsParameter<string> axis_line("axis_line", "on", "");
static MagicsParameter<string> axis_grid("axis_grid", "off", "");
static MagicsParameter<string> axis_title("axis_title", "on", "");
static MagicsParameter<string> axis_tick("axis_tick", "on", " New Magics: Parameter axis_tick sent to new Magics[XYSystem].  ");
static MagicsParameter<string> axis_minor_tick("axis_minor_tick", "off", "");
static MagicsParameter<string> axis_tick_label("axis_tick_label", "on", "");
#include "AxisMethod.h"
#include "DateAxis.h"
static SimpleObjectMaker<AxisMethod, AxisMethod> regular_AxisMethod("regular");
static SimpleObjectMaker<LogarithmicAxisMethod, AxisMethod> logarithmic_LogarithmicAxisMethod("logarithmic");
static SimpleObjectMaker<LongitudeAxisMethod, AxisMethod> longitude_LongitudeAxisMethod("longitude");
static SimpleObjectMaker<LatitudeAxisMethod, AxisMethod> latitude_LatitudeAxisMethod("latitude");
static SimpleObjectMaker<DateAxis, AxisMethod> date_DateAxis("date");
#include "AxisControl.h"
static SimpleObjectMaker<AxisControl, AxisControl> off_AxisControl("off");
static SimpleObjectMaker<AxisControl, AxisControl> regular_AxisControl("regular");
static SimpleObjectMaker<AutomaticAxisControl, AxisControl> automatic_AutomaticAxisControl("automatic");
#include "AxisLine.h"
static SimpleObjectMaker<AxisLine, AxisLine> on_AxisLine("on");
static SimpleObjectMaker<AxisLine, AxisLine> line_AxisLine("line");
static SimpleObjectMaker<NoAxisLine, AxisLine> off_NoAxisLine("off");
static SimpleObjectMaker<NoAxisLine, AxisLine> noline_NoAxisLine("noline");
#include "AxisGrid.h"
static SimpleObjectMaker<AxisGrid, AxisGrid> on_AxisGrid("on");
static SimpleObjectMaker<AxisGrid, AxisGrid> grid_AxisGrid("grid");
static SimpleObjectMaker<NoAxisGrid, AxisGrid> off_NoAxisGrid("off");
static SimpleObjectMaker<NoAxisGrid, AxisGrid> nogrid_NoAxisGrid("nogrid");
#include "AxisTitle.h"
static SimpleObjectMaker<AxisTitle, AxisTitle> on_AxisTitle("on");
static SimpleObjectMaker<AxisTitle, AxisTitle> title_AxisTitle("title");
static SimpleObjectMaker<NoAxisTitle, AxisTitle> off_NoAxisTitle("off");
static SimpleObjectMaker<NoAxisTitle, AxisTitle> notitle_NoAxisTitle("notitle");
#include "AxisTick.h"
static SimpleObjectMaker<AxisTick, AxisTick> on_AxisTick("on");
static SimpleObjectMaker<AxisTick, AxisTick> tick_AxisTick("tick");
static SimpleObjectMaker<NoAxisTick, AxisTick> off_NoAxisTick("off");
static SimpleObjectMaker<NoAxisTick, AxisTick> notick_NoAxisTick("notick");
#include "AxisMinorTick.h"
static SimpleObjectMaker<AxisMinorTick, AxisMinorTick> on_AxisMinorTick("on");
static SimpleObjectMaker<AxisMinorTick, AxisMinorTick> minortick_AxisMinorTick("minortick");
static SimpleObjectMaker<NoMinorAxisTick, AxisMinorTick> off_NoMinorAxisTick("off");
static SimpleObjectMaker<NoMinorAxisTick, AxisMinorTick> nominortick_NoMinorAxisTick("nominortick");
#include "AxisTickLabel.h"
static SimpleObjectMaker<AxisTickLabel, AxisTickLabel> on_AxisTickLabel("on");
static SimpleObjectMaker<AxisTickLabel, AxisTickLabel> label_AxisTickLabel("label");
static SimpleObjectMaker<NoAxisTickLabel, AxisTickLabel> off_NoAxisTickLabel("off");
static SimpleObjectMaker<NoAxisTickLabel, AxisTickLabel> nolabel_NoAxisTickLabel("nolabel");
