/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file WindPlotting.cc
    \brief Implementation of the Template class Wind.
    
    Magics Team - ECMWF 2005
    
    Started: Thu 17-Mar-2005
    
    Changes:
    
*/

#include "FlagPlotting.h"

using namespace magics;

void FlagPlotting::operator()(const PaperPoint& point, double x, double y,double) 
{ 
		double speed = sqrt((x*x)+(y*y));
		if (speed < this->min_speed_ || speed > this->max_speed_) return;
		
	   if ((*this->calm_)(point, x, y)) return; 
	
		if ( point.y() >= 0 ) 
			northFlags_->push_back(ArrowPoint(x, y, point));
		else southFlags_->push_back(ArrowPoint(x, y, point));
		
		
}
void FlagPlotting::prepare(BasicGraphicsObjectContainer& task, double)
{ 

    // Calm Indicator 
    (*this->calm_).colour(*this->colour_);
    (*this->calm_).height(this->calm_indicator_size_);
    (*this->calm_).below(this->calm_below_);
    (*this->calm_).prepare(task);
    
  
    
    
    // Setting for south Hemisphere wind	
	southFlags_ = new Flag();
	southFlags_->setColour(*this->colour_); 
	southFlags_->setThickness(this->thickness_);
	southFlags_->setStyle(this->style_);
	southFlags_->setCrossBoundary(this->cross_boundary_);
	southFlags_->setHemisphere(SOUTH);
	southFlags_->setLength(this->length_);
	
	// Setting for south Hemisphere wind	
	northFlags_ = new Flag();
	northFlags_->setColour(*this->colour_); 
	northFlags_->setThickness(this->thickness_);
	northFlags_->setCrossBoundary(this->cross_boundary_);
	northFlags_->setHemisphere(NORTH);
	northFlags_->setLength(this->length_);
	
	// Origin Indicator 	  
    (*this->origin_).prepare(*southFlags_);
    (*this->origin_).prepare(*northFlags_);
	
	task.push_back(southFlags_);	
	task.push_back(northFlags_);	
}

