C     This program demonstrates a new feature of Magics++: boxplots.

      PROGRAM BOXPLOT

	  DIMENSION RPOS(4),RMIN(4),RMAX(4),RMED(4),RUPP(4),RLOW(4)
	  DATA RPOS/2.0, 4.0, 6.5, 8.0/
	  DATA RMIN/1.0, 3.0, 5.2, 4.0/
	  DATA RMAX/5.0, 7.2, 9.4, 8.0/
	  DATA RMED/3.0, 5.0, 7.7, 6.0/
	  DATA RUPP/4.0, 6.0, 8.5, 7.0/
	  DATA RLOW/2.3, 4.0, 6.1, 5.0/


C     Open MAGICS and set the output file types/names

      CALL POPEN()

      CALL PSETC ('OUTPUT_FORMAT',  'PS')
      CALL PSETC ('OUTPUT_NAME',    'boxplot')
      
      
C     Boxplots work in paper coordinates, not map projection

      CALL PSETC ('SUBPAGE_MAP_PROJECTION', 'NONE')


C     Set up our axes. We will always use a 10x10 axis for
C     these examples. We must set up the axes before plotting
C     our boxplots.

      CALL DRAW_AXES ()


C     Set up our data for the boxplots

      CALL PSET1R('BOXPLOT_POSITIONS',        RPOS, 4)
      CALL PSET1R('BOXPLOT_MINIMUM_VALUES',   RMIN, 4)
      CALL PSET1R('BOXPLOT_MAXIMUM_VALUES',   RMAX, 4)
      CALL PSET1R('BOXPLOT_MEDIAN_VALUES',    RMED, 4)
      CALL PSET1R('BOXPLOT_BOX_UPPER_VALUES', RUPP, 4)
      CALL PSET1R('BOXPLOT_BOX_LOWER_VALUES', RLOW, 4)
     

C     Draw the boxplots using the default plotting attributes

      CALL PBOXPLOT

      CALL PSETC ('TEXT_LINE_1',
     x            'Boxplot - default plotting attributes')
      CALL PTEXT



C     New page - use different boxplot plotting attributes

      CALL PNEW ('PAGE')

      CALL DRAW_AXES ()

      CALL PSETR ('BOXPLOT_BOX_WIDTH', 1.)
      CALL PSETC ('BOXPLOT_BOX_COLOUR', 'TURQUOISE')
      CALL PSETI ('BOXPLOT_BOX_BORDER_THICKNESS', 1)
      CALL PSETC ('BOXPLOT_BOX_BORDER_LINE_STYLE', 'DASH')
      CALL PSETC ('BOXPLOT_WHISKER', 'BOX')
      CALL PSETR ('BOXPLOT_WHISKER_BOX_WIDTH', 0.3)
      CALL PSETC ('BOXPLOT_WHISKER_BOX_COLOUR', 'BLUE_PURPLE')
      CALL PSETC ('BOXPLOT_WHISKER_BOX_BORDER_COLOUR', 'RED')
      CALL PBOXPLOT

      CALL PSETC ('TEXT_LINE_1',
     x            'Thick dashed border, box colour, whiskers as boxes')
      CALL PTEXT




C     New page - use different boxplot plotting attributes

      CALL PNEW ('PAGE')

      CALL DRAW_AXES ()

      CALL PSETC  ('BOXPLOT_WHISKER',            'LINE')
      CALL PSETC  ('BOXPLOT_WHISKER_LINE_STYLE', 'DOT')
      CALL PRESET ('BOXPLOT_BOX_COLOUR')
      CALL PRESET ('BOXPLOT_BOX_BORDER_THICKNESS')
      CALL PRESET ('BOXPLOT_BOX_BORDER_LINE_STYLE')
      CALL PBOXPLOT

      CALL PSETC ('TEXT_LINE_1',
     x            'Whiskers as lines')
      CALL PTEXT


C     New page - use different median plotting attributes

      CALL PNEW ('PAGE')

      CALL DRAW_AXES ()

      CALL PSETC  ('BOXPLOT_MEDIAN_COLOUR',     'NAVY')
      CALL PSETI  ('BOXPLOT_MEDIAN_THICKNESS',   4)
      CALL PSETC  ('BOXPLOT_MEDIAN_LINE_STYLE', 'DOT')
      CALL PRESET ('BOXPLOT_WHISKER_LINE_STYLE')
      CALL PBOXPLOT

      CALL PSETC ('TEXT_LINE_1',
     x            'Median styles - thick, navy, dotted')
      CALL PTEXT




C     New page - plot plain black & white boxplots

      CALL PNEW ('PAGE')

      CALL DRAW_AXES ()

      CALL PSETC  ('BOXPLOT_BOX_COLOUR',          'WHITE')
      CALL PSETC  ('BOXPLOT_MEDIAN_COLOUR',       'BLACK')
      CALL PSETC  ('BOXPLOT_BOX_BORDER_COLOUR',   'BLACK')
      CALL PSETC  ('BOXPLOT_WHISKER_LINE_COLOUR', 'BLACK')
      CALL PRESET ('BOXPLOT_MEDIAN_THICKNESS')
      CALL PRESET ('BOXPLOT_MEDIAN_LINE_STYLE')
      CALL PBOXPLOT

      CALL PSETC ('TEXT_LINE_1', 'Plain boxplot')
      CALL PTEXT



C     Shutdown

      CALL PCLOSE()
    
      END




C     ------------------------------------------------------------
C     SUBROUTINE DRAW_AXES
C     Sets up and draws the axes. We will need to do this for each
C     page, to it's better to have it as a subroutine.
C     ------------------------------------------------------------

      SUBROUTINE DRAW_AXES ()

      CALL PSETC ('AXIS_LINE_COLOUR', 'BLUE')
      CALL PSETC ('AXIS_GRID', 'ON')
      CALL PSETC ('AXIS_GRID', 'ON')
      CALL PSETC ('AXIS_GRID_COLOUR', 'GREY')
      CALL PSETC ('AXIS_GRID_LINE_STYLE', 'DASH')
      CALL PSETC ('AXIS_ORIENTATION', 'VERTICAL')
      CALL PSETR ('AXIS_MIN_VALUE', 0.)
      CALL PSETR ('AXIS_MAX_VALUE', 10.)
      CALL PAXIS


      CALL PSETC ('AXIS_ORIENTATION', 'HORIZONTAL')
      CALL PSETR ('AXIS_MIN_VALUE', 0.)
      CALL PSETR ('AXIS_MAX_VALUE', 10.)
      CALL PAXIS

      RETURN
      END

