/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file LegendVisitorAttributes.h
    \brief Definition of LegendVisitor Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Thu Jun 16 12:02:57 2011
*/
   

#ifndef LegendVisitorAttributes_H
#define LegendVisitorAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "LegendMethod.h"
#include "Colour.h"

namespace magics {

class XmlNode;



class LegendVisitorAttributes 
{
public:
//  --  constructor
    LegendVisitorAttributes();
    
//  --  destructor
    virtual ~LegendVisitorAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const LegendVisitorAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  Legend text colour 
    \param colour Setting legend_text_colour - default=blue
*/
	void setColour(Colour* colour) 
		{ auto_ptr<Colour> tmp(colour); colour_ = tmp; } 
	const Colour&  getColour() const 
		{ return *colour_; }
/*!
    Magics Information:
    \brief  plot legend title text (on/off) 
    \param title Setting legend_title - default=off
*/
	void setTitle(bool title) 
		{ title_ =  title; } 
	bool getTitle() const 
		{ return title_; } 
        
/*!
    Magics Information:
    \brief  Text to plot as legend title 
    \param title_text Setting legend_title_text - default=legend
*/
	void setTitle_text(string title_text) 
		{ title_text_ =  title_text; } 
	string getTitle_text() const 
		{ return title_text_; } 
        
/*!
    Magics Information:
    \brief  type of shaded legend required 
    \param method Setting legend_display_type - default=disjoint
*/
	void setMethod(LegendMethod* method) 
		{ auto_ptr<LegendMethod> tmp(method); method_ = tmp; } 
	const LegendMethod&  getMethod() const 
		{ return *method_; }
/*!
    Magics Information:
    \brief  Format of automatic text (MAGICS Format/(AUTOMATIC)) 
    \param format Setting legend_text_format - default=(automatic)
*/
	void setFormat(string format) 
		{ format_ =  format; } 
	string getFormat() const 
		{ return format_; } 
        
/*!
    Magics Information:
    \brief  Legend text Height 
    \param font_size Setting legend_text_height - default=0.3
*/
	void setFont_size(double font_size) 
		{ font_size_ =  font_size; } 
	double getFont_size() const 
		{ return font_size_; } 
        
/*!
    Magics Information:
    \brief 	Whether legend box is positioned automatically or by the user (AUTOMATIC/POSITIONAL) 
    \param box Setting legend_box_mode - default=automatic
*/
	void setBox(string box) 
		{ box_ =  box; } 
	string getBox() const 
		{ return box_; } 
        
/*!
    Magics Information:
    \brief  List of text for legend entries 
    \param lines Setting legend_user_lines - default=stringarray()
*/
	void setLines(stringarray lines) 
		{ lines_ =  lines; } 
	stringarray getLines() const 
		{ return lines_; } 
        
/*!
    Magics Information:
    \brief  Number of columns in the legend 
    \param columns Setting legend_column_count - default=1
*/
	void setColumns(int columns) 
		{ columns_ =  columns; } 
	int getColumns() const 
		{ return columns_; } 
        
/*!
    Magics Information:
    \brief  Method of filling in legend entries(row/column) 
    \param direction Setting legend_entry_plot_direction - default=automatic
*/
	void setDirection(string direction) 
		{ direction_ =  direction; } 
	string getDirection() const 
		{ return direction_; } 
        
/*!
    Magics Information:
    \brief  Determines whether to use automatically-generated or user-generated text (or both) in the legend (AUTOMATIC_TEXT_ONLY/USER_TEXT_ONLY/BOTH) 
    \param composition Setting legend_text_composition - default=automatic_text_only
*/
	void setComposition(string composition) 
		{ composition_ =  composition; } 
	string getComposition() const 
		{ return composition_; } 
        
/*!
    Magics Information:
    \brief  User text to be associated with a legend sub-entry from a multiple entry 
    \param text Setting legend_user_text - default=
*/
	void setText(string text) 
		{ text_ =  text; } 
	string getText() const 
		{ return text_; } 
        
/*!
    Magics Information:
    \brief  User text to be associated with a legend sub-entry from a multiple entry 
    \param text1 Setting legend_user_text_1 - default=
*/
	void setText1(string text1) 
		{ text1_ =  text1; } 
	string getText1() const 
		{ return text1_; } 
        
/*!
    Magics Information:
    \brief  User text to be associated with a legend sub-entry from a multiple entry 
    \param text2 Setting legend_user_text_2 - default=
*/
	void setText2(string text2) 
		{ text2_ =  text2; } 
	string getText2() const 
		{ return text2_; } 
        
/*!
    Magics Information:
    \brief  User text to be associated with a legend sub-entry from a multiple entry 
    \param text3 Setting legend_user_text_3 - default=
*/
	void setText3(string text3) 
		{ text3_ =  text3; } 
	string getText3() const 
		{ return text3_; } 
        
/*!
    Magics Information:
    \brief  User text to be associated with a legend sub-entry from a multiple entry 
    \param text4 Setting legend_user_text_4 - default=
*/
	void setText4(string text4) 
		{ text4_ =  text4; } 
	string getText4() const 
		{ return text4_; } 
        
/*!
    Magics Information:
    \brief  User text to be associated with a legend sub-entry from a multiple entry 
    \param text5 Setting legend_user_text_5 - default=
*/
	void setText5(string text5) 
		{ text5_ =  text5; } 
	string getText5() const 
		{ return text5_; } 
        
/*!
    Magics Information:
    \brief  User text to be associated with a legend sub-entry from a multiple entry 
    \param text6 Setting legend_user_text_6 - default=
*/
	void setText6(string text6) 
		{ text6_ =  text6; } 
	string getText6() const 
		{ return text6_; } 
        
/*!
    Magics Information:
    \brief  User text to be associated with a legend sub-entry from a multiple entry 
    \param text7 Setting legend_user_text_7 - default=
*/
	void setText7(string text7) 
		{ text7_ =  text7; } 
	string getText7() const 
		{ return text7_; } 
        
/*!
    Magics Information:
    \brief  User text to be associated with a legend sub-entry from a multiple entry 
    \param text8 Setting legend_user_text_8 - default=
*/
	void setText8(string text8) 
		{ text8_ =  text8; } 
	string getText8() const 
		{ return text8_; } 
        
/*!
    Magics Information:
    \brief  User text to be associated with a legend sub-entry from a multiple entry 
    \param text9 Setting legend_user_text_9 - default=
*/
	void setText9(string text9) 
		{ text9_ =  text9; } 
	string getText9() const 
		{ return text9_; } 
        
/*!
    Magics Information:
    \brief  User text to be associated with a legend sub-entry from a multiple entry 
    \param text10 Setting legend_user_text_10 - default=
*/
	void setText10(string text10) 
		{ text10_ =  text10; } 
	string getText10() const 
		{ return text10_; } 
        
/*!
    Magics Information:
    \brief  X coordinate of lower left corner of legend box (Relative to PAGE_X_POSITION) 
    \param box_x Setting legend_box_x_position - default=0
*/
	void setBox_x(double box_x) 
		{ box_x_ =  box_x; } 
	double getBox_x() const 
		{ return box_x_; } 
        
/*!
    Magics Information:
    \brief  Y coordinate of lower left corner of legend box (Relative to PAGE_Y_POSITION) 
    \param box_y Setting legend_box_y_position - default=0
*/
	void setBox_y(double box_y) 
		{ box_y_ =  box_y; } 
	double getBox_y() const 
		{ return box_y_; } 
        
/*!
    Magics Information:
    \brief  Length of legend box in X direction 
    \param box_width Setting legend_box_x_length - default=0
*/
	void setBox_width(double box_width) 
		{ box_width_ =  box_width; } 
	double getBox_width() const 
		{ return box_width_; } 
        
/*!
    Magics Information:
    \brief  Length of legend box in Y direction 
    \param box_height Setting legend_box_y_length - default=0
*/
	void setBox_height(double box_height) 
		{ box_height_ =  box_height; } 
	double getBox_height() const 
		{ return box_height_; } 
        
/*!
    Magics Information:
    \brief  All plotting in the text box previous to PTEXT call will be blanked out. Plotting after PTEXT call will not be affected. (ON/OFF) 
    \param blanking Setting legend_box_blanking - default=on
*/
	void setBlanking(bool blanking) 
		{ blanking_ =  blanking; } 
	bool getBlanking() const 
		{ return blanking_; } 
        
/*!
    Magics Information:
    \brief  Plot border around text box (ON/OFF) 
    \param border Setting legend_border - default=off
*/
	void setBorder(bool border) 
		{ border_ =  border; } 
	bool getBorder() const 
		{ return border_; } 
        
/*!
    Magics Information:
    \brief  Line style of border around legend box (SOLID/DASH/DOT/CHAIN_DASH/CHAIN_DOT) 
    \param border_line_style Setting legend_border_line_style - default=solid
*/
	void setBorder_line_style(LineStyle border_line_style) 
		{ border_line_style_ =  border_line_style; } 
	LineStyle getBorder_line_style() const 
		{ return border_line_style_; } 
        
/*!
    Magics Information:
    \brief  Colour of border around text box (Full choice of colours) 
    \param border_colour Setting legend_border_colour - default=blue
*/
	void setBorder_colour(Colour* border_colour) 
		{ auto_ptr<Colour> tmp(border_colour); border_colour_ = tmp; } 
	const Colour&  getBorder_colour() const 
		{ return *border_colour_; }
/*!
    Magics Information:
    \brief  Thickness of legend box border 
    \param border_thickness Setting legend_border_thickness - default=1
*/
	void setBorder_thickness(int border_thickness) 
		{ border_thickness_ =  border_thickness; } 
	int getBorder_thickness() const 
		{ return border_thickness_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	auto_ptr<Colour> colour_;
	bool title_;
	string title_text_;
	auto_ptr<LegendMethod> method_;
	string format_;
	double font_size_;
	string box_;
	stringarray lines_;
	int columns_;
	string direction_;
	string composition_;
	string text_;
	string text1_;
	string text2_;
	string text3_;
	string text4_;
	string text5_;
	string text6_;
	string text7_;
	string text8_;
	string text9_;
	string text10_;
	double box_x_;
	double box_y_;
	double box_width_;
	double box_height_;
	bool blanking_;
	bool border_;
	LineStyle border_line_style_;
	auto_ptr<Colour> border_colour_;
	int border_thickness_;

private:
  
	friend ostream& operator<<(ostream& s,const LegendVisitorAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
