#!/usr/bin/perl

use strict;
use Time::localtime;

my $driver = @ARGV[0];
my $class  = "${driver}Driver";
shift @ARGV;
my @parents = @ARGV;

my $license_file = '../../LICENSE_for_source_files';	# Name the file
open(INFO, $license_file);				# Open the file
my @license = <INFO>;					# Read it into an array
close(INFO);						# Close the file

my $date_string=ctime();




##############################################################
##############################################################
###
###   OutputFactory.h
###
###
###
##############################################################
##############################################################
open STDOUT, ">../common/OutputFactory.h";
print <<"EOF";
/******************************** LICENSE ********************************

@license

 ******************************** LICENSE ********************************/
/*! \\file OutputFactory.h
    \\brief Definition of the Template class OutputFactory.
    \\author Graphics Section, ECMWF

    Automatically generated: $date_string
*/

#ifndef OutputFactory_H
#define OutputFactory_H

#include "magics.h"
#include "Translator.h"
#include "Factory.h"


namespace magics {

class DriverManager;
class MagicsManager;
class GDDriver;
class PostScriptDriver;

class OutputFactory {

public:
	OutputFactory();
	virtual ~OutputFactory();

	virtual void set(const XmlNode&)
	{
		Log::dev() << "(const XmlNode&)---> to be checked!...\n";
	}
	virtual void set(const map<string, string>&)
	{
		Log::dev() << "(const map<string, string&)---> to be checked!...\n";
	}
	virtual OutputFactory* clone() const
	{
		Log::dev() << "(const map<string, string&)---> to be checked!...\n";
		return new OutputFactory();
	}
	virtual void set(DriverManager&, const XmlNode&); 
	virtual void set(MagicsManager&) {} 
	virtual void reset() {};

protected:
     //! Method to print string about this class on to a stream of type ostream (virtual).
	 virtual void print(ostream&) const; 

private:
	//! Copy constructor - No copy allowed
	OutputFactory(const OutputFactory&);
	//! Overloaded << operator to copy - No copy allowed
	OutputFactory& operator=(const OutputFactory&);

// -- Friends
	//! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const OutputFactory& p)
		{ p.print(s); return s; }
};

class PsOutputFactory : public OutputFactory
{
public:
	PsOutputFactory() {}
	virtual ~PsOutputFactory() { reset(); }
	
	virtual OutputFactory* clone() const
	{
		Log::dev() << "(const map<string, string&)---> to be checked!...\n";
		return new PsOutputFactory();
	}
	virtual void set(DriverManager&, const XmlNode&); 
	virtual void reset();
protected:
	static PostScriptDriver* driver_;
};
class EpsOutputFactory : public PsOutputFactory
{
public:
	EpsOutputFactory() {}
	virtual ~EpsOutputFactory() {}	
	virtual OutputFactory* clone() const  { return new EpsOutputFactory(); }    
	virtual void set(DriverManager&, const XmlNode&);
	
};


#ifndef MAGICS_CAIRO
class PdfOutputFactory : public PsOutputFactory
{
public:
	PdfOutputFactory() {}
	virtual ~PdfOutputFactory() {}	
	virtual OutputFactory* clone() const  { return new PdfOutputFactory(); }    
	virtual void set(DriverManager&, const XmlNode&);
};
#else
class OldPdfOutputFactory : public PsOutputFactory
{
public:
	OldPdfOutputFactory() {}
	virtual ~OldPdfOutputFactory() {}	
	virtual OutputFactory* clone() const  { return new OldPdfOutputFactory(); }    
	virtual void set(DriverManager&, const XmlNode&);
};
#endif


#ifdef MAGICS_RASTER
class GdOutputFactory : public OutputFactory
{
public:
	GdOutputFactory() {}
	virtual ~GdOutputFactory() { reset(); }
	
	virtual OutputFactory* clone() const {return new GdOutputFactory();}
	virtual void set(DriverManager&, const XmlNode&); 	
	virtual void reset();
protected:
	static GDDriver* driver_;
};

class GifOutputFactory : public GdOutputFactory
{
public:
	GifOutputFactory() {}
	virtual ~GifOutputFactory() {}

	virtual OutputFactory* clone() const { return new GifOutputFactory();}
	virtual void set(DriverManager&, const XmlNode&); 
};

class GDPngOutputFactory : public GdOutputFactory
{
public:
	GDPngOutputFactory() {}
	virtual ~GDPngOutputFactory() {}

	virtual OutputFactory* clone() const  { return new GDPngOutputFactory();}
	virtual void set(DriverManager&, const XmlNode&);
};

class JpegOutputFactory : public GdOutputFactory
{
public:
	JpegOutputFactory() {}
	virtual ~JpegOutputFactory() { reset(); }
	
	virtual OutputFactory* clone() const  { return new JpegOutputFactory(); }    
	virtual void set(DriverManager&, const XmlNode&); 
};

class GifAnimOutputFactory : public GdOutputFactory
{
public:
	GifAnimOutputFactory() {}
	virtual ~GifAnimOutputFactory() { reset(); }	
	virtual OutputFactory* clone() const { return new GifAnimOutputFactory(); }    
	virtual void set(DriverManager&, const XmlNode&);
};
#endif

class SvgOutputFactory : public OutputFactory
{
public:
	SvgOutputFactory() {}
	virtual ~SvgOutputFactory() {}
	
	virtual OutputFactory* clone() const {return new SvgOutputFactory();}
	virtual void set(DriverManager&, const XmlNode&); 
};

#ifdef MAGICS_CAIRO
class PngOutputFactory : public OutputFactory
{
public:
	PngOutputFactory() {}
	virtual ~PngOutputFactory() {}

	virtual OutputFactory* clone() const { return new PngOutputFactory();}
	virtual void set(DriverManager&, const XmlNode&);
};

class CairoOutputFactory : public OutputFactory
{
public:
	CairoOutputFactory() {}
	virtual ~CairoOutputFactory() {}	

	virtual OutputFactory* clone() const { return new CairoOutputFactory();}
	virtual void set(DriverManager&, const XmlNode&); 
};

class PdfOutputFactory : public OutputFactory
{
public:
	PdfOutputFactory() {}
	virtual ~PdfOutputFactory() {}

	virtual OutputFactory* clone() const  { return new PdfOutputFactory();}
	virtual void set(DriverManager&, const XmlNode&);
};

class CPsOutputFactory : public OutputFactory
{
public:
	CPsOutputFactory() {}
	virtual ~CPsOutputFactory() {}

	virtual OutputFactory* clone() const  { return new CPsOutputFactory();}
	virtual void set(DriverManager&, const XmlNode&);
};

class CEpsOutputFactory : public OutputFactory
{
public:
	CEpsOutputFactory() {}
	virtual ~CEpsOutputFactory() {}	
	virtual OutputFactory* clone() const  { return new CEpsOutputFactory(); }    
	virtual void set(DriverManager&, const XmlNode&);
};

class CSvgOutputFactory : public OutputFactory
{
public:
	CSvgOutputFactory() {}
	virtual ~CSvgOutputFactory() {}	
	virtual OutputFactory* clone() const  { return new CSvgOutputFactory(); }    
	virtual void set(DriverManager&, const XmlNode&);
};

class XOutputFactory : public OutputFactory
{
public:
	XOutputFactory() {}
	virtual ~XOutputFactory() {}
	
	virtual OutputFactory* clone() const  { return new XOutputFactory(); }    
	virtual void set(DriverManager&, const XmlNode&);
};
#endif


class KmlOutputFactory : public OutputFactory
{
public:
	KmlOutputFactory() {}
	virtual ~KmlOutputFactory() {}
	
	virtual OutputFactory* clone() const {return new KmlOutputFactory();}
	virtual void set(DriverManager&, const XmlNode&); 
};


template <>
class Translator<string, OutputFactory> { 
public:
	OutputFactory* operator()(const string& val )
	{
		return SimpleObjectMaker<OutputFactory>::create(val);
	}     

	OutputFactory* magics(const string& param)
	{
		string val;
		ParameterManager::get(param, val);
		return (*this)(val);
	}
};

} // namespace magics
#endif

EOF

close STDOUT;


##############################################################
##############################################################
###
###   OutputFactory.cc
###
###
###
##############################################################
##############################################################
open STDOUT, ">../common/OutputFactory.cc";
print <<"EOF";
/******************************** LICENSE ********************************

@license

 ******************************** LICENSE ********************************/
/*! \\file OutputFactory.cc
    \\brief Implementation of the Template class OutputFactory.
    \\author Graphics Section, ECMWF

    Automatically generated: $date_string
*/

#include "OutputFactory.h"
#include "DriverManager.h"
#include "PostScriptDriver.h"

#ifdef MAGICS_RASTER
#include "GDDriver.h"
#endif


using namespace magics;

#ifdef MAGICS_RASTER
GDDriver* GdOutputFactory::driver_ = 0;
#endif
PostScriptDriver* PsOutputFactory::driver_ = 0;


OutputFactory::OutputFactory() 
{
}

OutputFactory::~OutputFactory() 
{
}

/*!
 Class information are given to the output-stream.
*/		
void OutputFactory::print(ostream& out)  const
{
	out << "OutputFactory[";
	out << "]";
}

void OutputFactory::set(DriverManager&, const XmlNode&)
{
}



void PsOutputFactory::set(DriverManager& magics, const XmlNode& node)
{
	if(!driver_)
	{
		driver_ = new PostScriptDriver();		
		magics.push_back(driver_);
	}
	driver_->set(node);
	driver_->setPS(true);
}

void PsOutputFactory::reset()
{
	if ( driver_ ) delete driver_;
	driver_ = 0;
}

#ifndef MAGICS_CAIRO
void PdfOutputFactory::set(DriverManager& magics, const XmlNode& node)
{
	if(!driver_)
	{
		driver_ = new PostScriptDriver();	
		magics.push_back(driver_);
	}
	driver_->set(node);	
	driver_->setPDF(true);
}
#else
void OldPdfOutputFactory::set(DriverManager& magics, const XmlNode& node)
{
	if(!driver_)
	{
		driver_ = new PostScriptDriver();	
		magics.push_back(driver_);
	}
	driver_->set(node);	
	driver_->setPDF(true);
}
#endif

void EpsOutputFactory::set(DriverManager& magics, const XmlNode& node)
{
	// Add a new PsDriver only for this purpose!
	PostScriptDriver* driver = new PostScriptDriver();
	driver->set(node);
	driver->setEPS(true);
	
	magics.push_back(driver);
}


#ifdef MAGICS_RASTER
void GifOutputFactory::set(DriverManager& magics, const XmlNode& node)
{
	if( !driver_ )
	{
		driver_ = new GDDriver();
		magics.push_back(driver_);
	}
	driver_->set(node);
	driver_->setGIF(true);
}

void GDPngOutputFactory::set(DriverManager& magics, const XmlNode& node)
{
	if ( !driver_ )
	{
		driver_ = new GDDriver();
		magics.push_back(driver_);
	}
	
	driver_->set(node);
	driver_->setPNG(true);
}

void JpegOutputFactory::set(DriverManager& magics, const XmlNode& node)
{
	if ( !driver_ ) {
		driver_ = new GDDriver();
		magics.push_back(driver_);
	}
	driver_->set(node);
	driver_->setJPG(true);
}

void GifAnimOutputFactory::set(DriverManager& magics, const XmlNode& node)
{
	GDDriver* driver = new GDDriver();
	driver->set(node);
	driver->setAnimation(true);

	magics.push_back(driver);
}

void GdOutputFactory::set(DriverManager& magics, const XmlNode& node)
{
	driver_ = new GDDriver();
	driver_->set(node);

	magics.push_back(driver_);
}

void GdOutputFactory::reset()
{
	if ( driver_ ) delete driver_;
	driver_ = 0;
}
#endif

#include "SVGDriver.h"
void SvgOutputFactory::set(DriverManager& magics, const XmlNode& node)
{
	SVGDriver* driver = new SVGDriver();
	driver->set(node);

	magics.push_back(driver);
}

#ifdef MAGICS_CAIRO
#include "CairoDriver.h"
void PdfOutputFactory::set(DriverManager& magics, const XmlNode& node)
{
	CairoDriver* driver = new CairoDriver();
	driver->set(node);
	driver->setPDF();
	
	magics.push_back(driver); 
}

void CairoOutputFactory::set(DriverManager& magics, const XmlNode& node)
{
	CairoDriver* driver = new CairoDriver();
	driver->set(node);
	driver->setCairo();
	
	magics.push_back(driver);
}

void PngOutputFactory::set(DriverManager& magics, const XmlNode& node)
{
	CairoDriver* driver = new CairoDriver();
	driver->set(node);
	driver->setPNG();
	
	magics.push_back(driver);
}

void CPsOutputFactory::set(DriverManager& magics, const XmlNode& node)
{
	CairoDriver* driver = new CairoDriver();
	driver->set(node);
	driver->setPS();
	
	magics.push_back(driver);
}

void CEpsOutputFactory::set(DriverManager& magics, const XmlNode& node)
{
	CairoDriver* driver = new CairoDriver();
	driver->set(node);
	driver->setEPS();
	
	magics.push_back(driver);
}

void CSvgOutputFactory::set(DriverManager& magics, const XmlNode& node)
{
	CairoDriver* driver = new CairoDriver();
	driver->set(node);
	driver->setSVG();
	
	magics.push_back(driver);
}

void XOutputFactory::set(DriverManager& magics, const XmlNode& node)
{
	CairoDriver* driver = new CairoDriver();
	driver->set(node);
	driver->setX();
	
	magics.push_back(driver);
}
#endif

#include "KMLDriver.h"
void KmlOutputFactory::set(DriverManager& magics, const XmlNode& node)
{
	KMLDriver* driver = new KMLDriver();
	driver->set(node);

	magics.push_back(driver);
}

EOF
close STDOUT;


##############################################################
##############################################################
###
###   OutputHandler.cc
###
###
###
##############################################################
##############################################################
open STDOUT, ">../common/OutputHandler.cc";
print <<"EOF";
/******************************** LICENSE ********************************

@license

 ******************************** LICENSE ********************************/
/*! \\file OutputHandler.cc
    \\brief Implementation of the Template class OutputHandler.
    \\author Graphics Section, ECMWF

    Automatically generated: $date_string
*/

#include "OutputHandler.h"
#include "DriverManager.h"
#include "OutputFactory.h"
#include "XmlNode.h"

using namespace magics;

void OutputHandler::set(DriverManager& magics) 
{
	if ( formats_.empty() ) formats_.push_back(format_);

	for ( vector<string>::const_iterator format = formats_.begin(); format != formats_.end(); ++format)
	{
		OutputFactory* factory = Translator<string, OutputFactory>()(*format);
		XmlNode node;
		factory->set(magics, node); 
		factories_.push_back(factory);
	}
}

void OutputHandler::set(const XmlNode& node, DriverManager& magics) 
{
	try {
		OutputFactory* factory = Translator<string, OutputFactory>()(node.name());
	
		factory->set(magics, node); 
		factories_.push_back(factory);
	}
	catch (...)
	{
	}
}


OutputHandler::~OutputHandler()
{
	for ( vector<OutputFactory* >::const_iterator factory = factories_.begin(); factory != factories_.end(); ++factory)
		(*factory)->reset(); 
}


/*
 This code was copied from OutputFactory.cc to hear to work in 
 STATIC Magics++ libraries!
*/
static SimpleObjectMaker<PsOutputFactory, OutputFactory> ps("ps");
static SimpleObjectMaker<EpsOutputFactory, OutputFactory> eps("eps");

#ifndef MAGICS_CAIRO
static SimpleObjectMaker<PdfOutputFactory, OutputFactory> pdf("pdf");
#endif

#ifdef MAGICS_RASTER
#ifndef MAGICS_CAIRO
static SimpleObjectMaker<GDPngOutputFactory, OutputFactory> png("png");
#else
static SimpleObjectMaker<GDPngOutputFactory, OutputFactory> gdpng("gdpng");
#endif
static SimpleObjectMaker<JpegOutputFactory, OutputFactory> jpeg("jpeg");
static SimpleObjectMaker<GifOutputFactory, OutputFactory> gif("gif");
static SimpleObjectMaker<GifAnimOutputFactory, OutputFactory> gif_anim("gif_animation");
#endif

#ifdef MAGICS_MING
static SimpleObjectMaker<MingOutputFactory, OutputFactory> format("swf");
#endif

static SimpleObjectMaker<SvgOutputFactory, OutputFactory> svg("svg");

#ifdef MAGICS_CAIRO
//static SimpleObjectMaker<OldPdfOutputFactory,OutputFactory> oldpdf("oldpdf");
static SimpleObjectMaker<PngOutputFactory,  OutputFactory> png("png");
static SimpleObjectMaker<PdfOutputFactory,  OutputFactory> pdf("pdf");
static SimpleObjectMaker<XOutputFactory,    OutputFactory> x("x");
static SimpleObjectMaker<CairoOutputFactory,    OutputFactory> cairo("cairo");
static SimpleObjectMaker<CSvgOutputFactory, OutputFactory> csvg("csvg");
static SimpleObjectMaker<CPsOutputFactory,  OutputFactory> cps("cps");
static SimpleObjectMaker<CEpsOutputFactory, OutputFactory> ceps("ceps");
#endif

static SimpleObjectMaker<KmlOutputFactory, OutputFactory> kml("kml");

EOF
close STDOUT;
