/*! \file BinaryObject.h
    \brief Definition of the Template class BinaryObject.
    
    Magics Team - ECMWF 2010
    
    Started: Fri 8-Jan-2010
    
    Changes:
    
*/

#ifndef BinaryObject_H
#define BinaryObject_H

#include "magics.h"

#include "BasicGraphicsObject.h"
#include "BasicSceneObject.h"
#include "BinaryObjectAttributes.h"

namespace magics {

class BaseDriver;
class SceneLayer;

class BinaryObject: 
     public BasicGraphicsObject,
     public BasicSceneObject,
     public BinaryObjectAttributes 
{
public:
	BinaryObject();
	virtual ~BinaryObject();
	void redisplay(const BaseDriver&) const;
 
	void visit(SceneLayer&);
    
	void set(const map<string, string>& map ) { BinaryObjectAttributes::set(map); }
	void set(const XmlNode& node ) { BinaryObjectAttributes::set(node); }

protected:
	//! Method to print string about this class on to a stream of type ostream (virtual).
	virtual void print(ostream&) const; 

private:
	//! Copy constructor - No copy allowed
	BinaryObject(const BinaryObject&);
	//! Overloaded << operator to copy - No copy allowed
	BinaryObject& operator=(const BinaryObject&);

// -- Friends
	//! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const BinaryObject& p)
		{ p.print(s); return s; }
};

} // namespace magics
#endif
