/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file FortranViewNodeAttributes.h
    \brief Definition of FortranViewNode Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Mon Mar  5 17:12:45 2012
*/
   

#ifndef FortranViewNodeAttributes_H
#define FortranViewNodeAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "PreviewVisitor.h"
#include "Transformation.h"
#include "MagnifierVisitor.h"
#include "Colour.h"

namespace magics {

class XmlNode;



class FortranViewNodeAttributes 
{
public:
//  --  constructor
    FortranViewNodeAttributes();
    
//  --  destructor
    virtual ~FortranViewNodeAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const FortranViewNodeAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief   vertical alignment of the drawing area in the subpage: bottom/top 
    \param vertical Setting subpage_align_vertical - default=bottom
*/
	void setVertical(const string& vertical) 
		{ vertical_ =  vertical; } 
	const string& getVertical() const 
		{ return vertical_; } 
        
/*!
    Magics Information:
    \brief    horizontal alignment of the drawing area in the subpage: left/right  
    \param horizontal Setting subpage_align_horizontal - default=left
*/
	void setHorizontal(const string& horizontal) 
		{ horizontal_ =  horizontal; } 
	const string& getHorizontal() const 
		{ return horizontal_; } 
        
/*!
    Magics Information:
    \brief  Y-Coordinate of upper left hand corner of subpage 
    \param top Setting subpage_top_position - default=-1
*/
	void setTop(double top) 
		{ top_ =  top; } 
	double getTop() const 
		{ return top_; } 
        
/*!
    Magics Information:
    \brief  X-Coordinate of lower left hand corner of subpage 
    \param bottom Setting subpage_y_position - default=-1
*/
	void setBottom(double bottom) 
		{ bottom_ =  bottom; } 
	double getBottom() const 
		{ return bottom_; } 
        
/*!
    Magics Information:
    \brief  Y-Coordinate of lower left hand corner of subpage 
    \param left Setting subpage_x_position - default=-1
*/
	void setLeft(double left) 
		{ left_ =  left; } 
	double getLeft() const 
		{ return left_; } 
        
/*!
    Magics Information:
    \brief  X-Coordinate of lower left hand corner of subpage 
    \param bottom_internal Setting subpage_y_position_internal - default=-1
*/
	void setBottom_internal(double bottom_internal) 
		{ bottom_internal_ =  bottom_internal; } 
	double getBottom_internal() const 
		{ return bottom_internal_; } 
        
/*!
    Magics Information:
    \brief  Y-Coordinate of lower left hand corner of subpage 
    \param left_internal Setting subpage_x_position_internal - default=-1
*/
	void setLeft_internal(double left_internal) 
		{ left_internal_ =  left_internal; } 
	double getLeft_internal() const 
		{ return left_internal_; } 
        
/*!
    Magics Information:
    \brief  X-Coordinate of lower right  hand corner of subpage 
    \param right Setting subpage_right_position - default=-1
*/
	void setRight(double right) 
		{ right_ =  right; } 
	double getRight() const 
		{ return right_; } 
        
/*!
    Magics Information:
    \brief  Length of subpage in horizontal direction.Default 
    \param width Setting subpage_x_length - default=-1
*/
	void setWidth(double width) 
		{ width_ =  width; } 
	double getWidth() const 
		{ return width_; } 
        
/*!
    Magics Information:
    \brief  Length of subpage in vertical direction.Default 
    \param height Setting subpage_y_length - default=-1
*/
	void setHeight(double height) 
		{ height_ =  height; } 
	double getHeight() const 
		{ return height_; } 
        
/*!
    Magics Information:
    \brief  Length of subpage in vertical direction.Default 
    \param height_internal Setting subpage_y_length_internal - default=-1
*/
	void setHeight_internal(double height_internal) 
		{ height_internal_ =  height_internal; } 
	double getHeight_internal() const 
		{ return height_internal_; } 
        
/*!
    Magics Information:
    \brief  Length of subpage in horizontal direction.Default 
    \param width_internal Setting subpage_x_length_internal - default=-1
*/
	void setWidth_internal(double width_internal) 
		{ width_internal_ =  width_internal; } 
	double getWidth_internal() const 
		{ return width_internal_; } 
        
/*!
    Magics Information:
    \brief  Colour of the subpage background 
    \param background Setting subpage_background_colour - default=white
*/
	void setBackground(Colour* background) 
		{ auto_ptr<Colour> tmp(background); background_ = tmp; } 
	const Colour&  getBackground() const 
		{ return *background_; }
/*!
    Magics Information:
    \brief  Plot frame around subpage (ON/OFF) 
    \param frame Setting subpage_frame - default=on
*/
	void setFrame(bool frame) 
		{ frame_ =  frame; } 
	bool getFrame() const 
		{ return frame_; } 
        
/*!
    Magics Information:
    \brief  Colour of subpage frame (Full choice of colours) 
    \param frame_colour Setting subpage_frame_colour - default=black
*/
	void setFrame_colour(Colour* frame_colour) 
		{ auto_ptr<Colour> tmp(frame_colour); frame_colour_ = tmp; } 
	const Colour&  getFrame_colour() const 
		{ return *frame_colour_; }
/*!
    Magics Information:
    \brief  Style of subpage frame (SOLID/DASH/DOT/CHAIN_DASH/CHAIN_DOT) 
    \param frame_line_style Setting subpage_frame_line_style - default=solid
*/
	void setFrame_line_style(LineStyle frame_line_style) 
		{ frame_line_style_ =  frame_line_style; } 
	LineStyle getFrame_line_style() const 
		{ return frame_line_style_; } 
        
/*!
    Magics Information:
    \brief  Thickness of subpage frame 
    \param frame_thickness Setting subpage_frame_thickness - default=2
*/
	void setFrame_thickness(int frame_thickness) 
		{ frame_thickness_ =  frame_thickness; } 
	int getFrame_thickness() const 
		{ return frame_thickness_; } 
        
/*!
    Magics Information:
    \brief  width of the vertical  axis in cm 
    \param vertical_axis_with Setting subpage_vertical_axis_width - default=1
*/
	void setVertical_axis_with(double vertical_axis_with) 
		{ vertical_axis_with_ =  vertical_axis_with; } 
	double getVertical_axis_with() const 
		{ return vertical_axis_with_; } 
        
/*!
    Magics Information:
    \brief  height of the horizontal  axis in cm
    \param horizontal_axis_height Setting subpage_horizontal_axis_height - default=1
*/
	void setHorizontal_axis_height(double horizontal_axis_height) 
		{ horizontal_axis_height_ =  horizontal_axis_height; } 
	double getHorizontal_axis_height() const 
		{ return horizontal_axis_height_; } 
        
/*!
    Magics Information:
    \brief Projection required(CYLINDRICAL, POLAR_STEREOGRAPHIC, MERCATOR, CARTESIAN) 
    \param transformation Setting subpage_map_projection - default=cylindrical
*/
	void setTransformation(Transformation* transformation) 
		{ auto_ptr<Transformation> tmp(transformation); transformation_ = tmp; } 
	const Transformation&  getTransformation() const 
		{ return *transformation_; }
/*!
    Magics Information:
    \brief  overlay method : basic: plot the fields as they come ... none : never ovelrlay!  
    \param overlay Setting subpage_overlay_mode - default=basic
*/
	void setOverlay(const string& overlay) 
		{ overlay_ =  overlay; } 
	const string& getOverlay() const 
		{ return overlay_; } 
        
/*!
    Magics Information:
    \brief  Plot the title (ON/OFF) 
    \param title Setting automatic_title - default=off
*/
	void setTitle(bool title) 
		{ title_ =  title; } 
	bool getTitle() const 
		{ return title_; } 
        
/*!
    Magics Information:
    \brief  Mv4: turn on/off the generation of the infomation for the preview box 
    \param preview Setting subpage_map_preview - default=off
*/
	void setPreview(NoPreviewVisitor* preview) 
		{ auto_ptr<NoPreviewVisitor> tmp(preview); preview_ = tmp; } 
	const NoPreviewVisitor&  getPreview() const 
		{ return *preview_; }
/*!
    Magics Information:
    \brief  Mv4: turn on/off the generation of the infomation for the magnifier tool 
    \param magnify Setting subpage_map_magnifier - default=off
*/
	void setMagnify(NoMagnifierVisitor* magnify) 
		{ auto_ptr<NoMagnifierVisitor> tmp(magnify); magnify_ = tmp; } 
	const NoMagnifierVisitor&  getMagnify() const 
		{ return *magnify_; }
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	string vertical_;
	string horizontal_;
	double top_;
	double bottom_;
	double left_;
	double bottom_internal_;
	double left_internal_;
	double right_;
	double width_;
	double height_;
	double height_internal_;
	double width_internal_;
	auto_ptr<Colour> background_;
	bool frame_;
	auto_ptr<Colour> frame_colour_;
	LineStyle frame_line_style_;
	int frame_thickness_;
	double vertical_axis_with_;
	double horizontal_axis_height_;
	auto_ptr<Transformation> transformation_;
	string overlay_;
	bool title_;
	auto_ptr<NoPreviewVisitor> preview_;
	auto_ptr<NoMagnifierVisitor> magnify_;

private:
  
	friend ostream& operator<<(ostream& s,const FortranViewNodeAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
