/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file SciMethods.cc
    \brief Definition of SciMethods.
    \author Graphics Section, ECMWF

    Started: September 2011
*/

#include <math.h>

#include "SciMethods.h"

namespace magics 
{

/*! Computes the distance on Earth in km */
double geoDistanceInKm(double fi1,double la1,double fi2,double la2)
{ 
	double rfi1=RAD(fi1);
	double rla1=RAD(la1);
	double rfi2=RAD(fi2);
	double rla2=RAD(la2);

   	if(rla1 != rla2)
     	{
       		double d=sin(rfi1)*sin(rfi2)+cos(rfi1)*cos(rfi2)*cos(fabs(rla1-rla2));
       		return acos(d)*EarthRadiusInKm;
     	}
	else
	{  
   	      	return fabs(rfi1-rfi2)*EarthRadiusInKm;

	}

}


} //end namespace