/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file DateGribLoopStepAttributes.h
    \brief Definition of DateGribLoopStep Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Mon Mar  5 17:12:43 2012
*/
   

#ifndef DateGribLoopStepAttributes_H
#define DateGribLoopStepAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "GribAddressMode.h"

namespace magics {

class XmlNode;



class DateGribLoopStepAttributes 
{
public:
//  --  constructor
    DateGribLoopStepAttributes();
    
//  --  destructor
    virtual ~DateGribLoopStepAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const DateGribLoopStepAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  Time interval  
    \param span Setting grib_loop_step_span - default=3
*/
	void setSpan(double span) 
		{ span_ =  span; } 
	double getSpan() const 
		{ return span_; } 
        
/*!
    Magics Information:
    \brief  Normally GRIB fields are stored as records on a file. If the BYTE offset method is being used, the parameter GRIB_FILE_ADDRESS_MODE should be set to 'BYTE_OFFSET'.(RECORD_NUMBER/BYTE_OFFSET) 
    \param address_mode Setting grib_file_address_mode - default=record
*/
	void setAddress_mode(GribAddressMode* address_mode) 
		{ auto_ptr<GribAddressMode> tmp(address_mode); address_mode_ = tmp; } 
	const GribAddressMode&  getAddress_mode() const 
		{ return *address_mode_; }
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	double span_;
	auto_ptr<GribAddressMode> address_mode_;

private:
  
	friend ostream& operator<<(ostream& s,const DateGribLoopStepAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
