/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file NetcdfDecoderAttributes.h
    \brief Definition of NetcdfDecoder Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Mon Mar  5 17:12:45 2012
*/
   

#ifndef NetcdfDecoderAttributes_H
#define NetcdfDecoderAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "NetcdfInterpretor.h"

namespace magics {

class XmlNode;



class NetcdfDecoderAttributes 
{
public:
//  --  constructor
    NetcdfDecoderAttributes();
    
//  --  destructor
    virtual ~NetcdfDecoderAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const NetcdfDecoderAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief Type of data arrangement in the file (possible values: matrix) 
    \param interpretor Setting netcdf_type - default=matrix
*/
	void setInterpretor(NetcdfInterpretor* interpretor) 
		{ auto_ptr<NetcdfInterpretor> tmp(interpretor); interpretor_ = tmp; } 
	const NetcdfInterpretor&  getInterpretor() const 
		{ return *interpretor_; }
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	auto_ptr<NetcdfInterpretor> interpretor_;

private:
  
	friend ostream& operator<<(ostream& s,const NetcdfDecoderAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
