/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file GraphMissingPlot.cc
    \brief Implementation of the Template class GraphMissingPlot.
    
    Magics Team - ECMWF 2006
    
    Started: Mon 22-May-2006
    
    Changes:
    
*/

#include "Polyline.h"
#include "GraphMissingPlot.h"
#include "Transformation.h"

#include "PaperPoint.h"

using namespace magics;

GraphMissingPlot::GraphMissingPlot() 
{
}


GraphMissingPlot::~GraphMissingPlot() 
{
}

/*!
 Class information are given to the output-stream.
*/		
void GraphMissingPlot::print(ostream& out)  const
{
	out << "GraphMissingPlot[";
	out << "]";
}

void JoinGraphMissingPlot::print(ostream& out)  const
{
	out << "JoinGraphMissingPlot[";
	out << "]";
}

void DropGraphMissingPlot::print(ostream& out)  const
{
	out << "DropGraphMissingPlot[";
	out << "]";
}

bool  GraphMissingPlot::operator()(const PaperPoint&, const PaperPoint&, const vector<PaperPoint>& , BasicGraphicsObjectContainer& )
{
	return true;
}

bool  JoinGraphMissingPlot::operator()(const PaperPoint& p1, const PaperPoint& p2, const vector<PaperPoint>& , BasicGraphicsObjectContainer& task)
{
	Polyline* curve  = new Polyline();
	(*curve).setColour(*colour_);
	(*curve).setLineStyle(style_);
	(*curve).setThickness(thickness_);
	
	curve->push_back(p1);
	curve->push_back(p2);
	task.transformation()(*curve, task);
	return true;
}

bool  DropGraphMissingPlot::operator()(const PaperPoint& p1, const PaperPoint& p2, const vector<PaperPoint>& points, BasicGraphicsObjectContainer& task)
{
	Polyline* curve  = new Polyline();
	(*curve).setColour(*colour_);
	(*curve).setLineStyle(style_);
	(*curve).setThickness(thickness_);
	
	curve->push_back(p1);	
	for ( vector<PaperPoint>::const_iterator point = points.begin(); point != points.end(); ++point) 
		curve->push_back(*point);
	curve->push_back(p2);
	task.transformation()(*curve, task);	
	return true;
}
