/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file ImagePlottingAttributes.cc
    \brief Implemtation of ImagePlotting Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Mon Mar  5 17:12:45 2012
*/    

#include "ImagePlottingAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


ImagePlottingAttributes::ImagePlottingAttributes():
	mode_(MagTranslator<string, LookupTableMode>().magics("image_colour_table_creation_mode")),
	colourMethod_(MagTranslator<string, ColourTableDefinition>().magics("image_colour_table_type")),
	count_(ParameterManager::getInt("image_level_count")),
	pixelFrequency_(ParameterManager::getInt("image_pixel_selection_frequency"))
{
} 



ImagePlottingAttributes::~ImagePlottingAttributes()
{
}

    
void ImagePlottingAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	prefix[0] = "image";

	setMember(prefix, "image_colour_table_creation_mode", mode_, params);
	setMember(prefix, "image_colour_table_type", colourMethod_, params);
	setAttribute(prefix, "image_level_count", count_, params);
	setAttribute(prefix, "image_pixel_selection_frequency", pixelFrequency_, params);
}

void ImagePlottingAttributes::copy(const ImagePlottingAttributes& other)
{
	setMode(other.mode_->clone());
	setColourMethod(other.colourMethod_->clone());
	count_ = other.count_;
	pixelFrequency_ = other.pixelFrequency_;
} 


bool ImagePlottingAttributes::accept(const string& node)
{	
	if ( magCompare(node, "image")  )
		return true;

	if ( acceptNode(node, mode_) )
		return true;

	if ( acceptNode(node, colourMethod_) )
		return true;
	return false;
}

void ImagePlottingAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "image") )
		set(node.attributes());
	else {
		setMember(node.name(), mode_, node);
		setMember(node.name(), colourMethod_, node);
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
		setMember((*elt)->name(), mode_, *(*elt)); 
		setMember((*elt)->name(), colourMethod_, *(*elt)); 
	}
}

void ImagePlottingAttributes::print(ostream& out)  const
{
	out << "ImagePlottingAttributes[";
	out << "mode = " << *mode_;
	out << ", colourMethod = " << *colourMethod_;
	out << ", count = " << count_;
	out << ", pixelFrequency = " << pixelFrequency_;
	out << "]" << "\n";
}


void ImagePlottingAttributes::toxml(ostream& out, const string& tag, int tabs)  const
{
     out <<  "\"image\"";
	 out << ", \"image_colour_table_creation_mode\":";
	 mode_->toxml(out, 0);
	 out << ", \"image_colour_table_type\":";
	 colourMethod_->toxml(out, 0);
	 out << ", \"image_level_count\":";
	 niceprint(out,count_);
	 out << ", \"image_pixel_selection_frequency\":";
	 niceprint(out,pixelFrequency_);
}
static MagicsParameter<string> image_colour_table_creation_mode("image_colour_table_creation_mode", "equidistant", "");
static MagicsParameter<string> image_colour_table_type("image_colour_table_type", "computed", "Default changde from calculate to computed ");
static MagicsParameter<int> image_level_count("image_level_count", 127, "");
static MagicsParameter<int> image_pixel_selection_frequency("image_pixel_selection_frequency", 10, "");
#include "NormalTableMode.h"
#include "EquidistantTableMode.h"
#include "LinearTableMode.h"
#include "LookupTableMode.h"
static SimpleObjectMaker<FixedTableMode, LookupTableMode> fixed_FixedTableMode("fixed");
static SimpleObjectMaker<FixedTableMode, LookupTableMode> lut_fixed_FixedTableMode("lut_fixed");
static SimpleObjectMaker<NormalTableMode, LookupTableMode> normal_NormalTableMode("normal");
static SimpleObjectMaker<NormalTableMode, LookupTableMode> lut_normal_NormalTableMode("lut_normal");
static SimpleObjectMaker<EquidistantTableMode, LookupTableMode> equidistant_EquidistantTableMode("equidistant");
static SimpleObjectMaker<EquidistantTableMode, LookupTableMode> lut_equidistant_EquidistantTableMode("lut_equidistant");
static SimpleObjectMaker<LinearTableMode, LookupTableMode> linear_LinearTableMode("linear");
static SimpleObjectMaker<LinearTableMode, LookupTableMode> lut_linear_LinearTableMode("lut_linear");
#include "ImageListColourTechnique.h"
#include "ImageCalculateColourTechnique.h"
static SimpleObjectMaker<ImageListColourTechnique, ColourTableDefinition> list_ImageListColourTechnique("list");
static SimpleObjectMaker<ImageListColourTechnique, ColourTableDefinition> lut_list_ImageListColourTechnique("lut_list");
static SimpleObjectMaker<ImageCalculateColourTechnique, ColourTableDefinition> computed_ImageCalculateColourTechnique("computed");
static SimpleObjectMaker<ImageCalculateColourTechnique, ColourTableDefinition> lut_computed_ImageCalculateColourTechnique("lut_computed");
