/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file EpsShadeAttributes.cc
    \brief Implemtation of EpsShade Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Tue Nov 22 10:53:37 2011
*/    

#include "EpsShadeAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


EpsShadeAttributes::EpsShadeAttributes():
	colour_(MagTranslator<string, Colour>().magics("eps_shade_colour")),
	line_colour_(MagTranslator<string, Colour>().magics("eps_shade_line_colour")),
	line_style_(MagTranslator<string, LineStyle>().magics("eps_shade_line_style")),
	line_thickness_(ParameterManager::getInt("eps_shade_line_thickness"))
{
} 



EpsShadeAttributes::~EpsShadeAttributes()
{
}

    
void EpsShadeAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	prefix[0] = "eps";

	setAttribute(prefix, "eps_shade_colour", colour_, params);
	setAttribute(prefix, "eps_shade_line_colour", line_colour_, params);
	setAttribute(prefix, "eps_shade_line_style", line_style_, params);
	setAttribute(prefix, "eps_shade_line_thickness", line_thickness_, params);
}

void EpsShadeAttributes::copy(const EpsShadeAttributes& other)
{
	setColour(other.colour_->clone());
	setLine_colour(other.line_colour_->clone());
	line_style_ = other.line_style_;
	line_thickness_ = other.line_thickness_;
} 


bool EpsShadeAttributes::accept(const string& node)
{	
	if ( magCompare(node, "epsshade")  )
		return true;
	return false;
}

void EpsShadeAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "epsshade") )
		set(node.attributes());
	else {
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
	}
}

void EpsShadeAttributes::print(ostream& out)  const
{
	out << "EpsShadeAttributes[";
	out << "colour = " << *colour_;
	out << ", line_colour = " << *line_colour_;
	out << ", line_style = " << line_style_;
	out << ", line_thickness = " << line_thickness_;
	out << "]" << "\n";
}


void EpsShadeAttributes::toxml(ostream& out, const string& tag, int tabs)  const
{
     out <<  "\"epsshade\"";
	 out << ", \"eps_shade_colour\":";
	 niceprint(out, *colour_);
	 out << ", \"eps_shade_line_colour\":";
	 niceprint(out, *line_colour_);
	 out << ", \"eps_shade_line_style\":";
	 niceprint(out,line_style_);
	 out << ", \"eps_shade_line_thickness\":";
	 niceprint(out,line_thickness_);
}
static MagicsParameter<string> eps_shade_colour("eps_shade_colour", "red", "");
static MagicsParameter<string> eps_shade_line_colour("eps_shade_line_colour", "red", "");
static MagicsParameter<string> eps_shade_line_style("eps_shade_line_style", "solid", "");
static MagicsParameter<int> eps_shade_line_thickness("eps_shade_line_thickness", 1, "");
