/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file LevelSelectionAttributes.h
    \brief Definition of LevelSelection Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Tue Nov 22 10:53:38 2011
*/
   

#ifndef LevelSelectionAttributes_H
#define LevelSelectionAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"



namespace magics {

class XmlNode;



class LevelSelectionAttributes 
{
public:
//  --  constructor
    LevelSelectionAttributes();
    
//  --  destructor
    virtual ~LevelSelectionAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const LevelSelectionAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  Highest level for contours to be drawn 
    \param max Setting contour_max_level - default=1.0e+21
*/
	void setMax(double max) 
		{ max_ =  max; } 
	double getMax() const 
		{ return max_; } 
        
/*!
    Magics Information:
    \brief  Lowest level for contours to be drawn 
    \param min Setting contour_min_level - default=-1.0e+21
*/
	void setMin(double min) 
		{ min_ =  min; } 
	double getMin() const 
		{ return min_; } 
        
/*!
    Magics Information:
    \brief  Highest level for contours to be shaded 
    \param max_shade Setting contour_shade_max_level - default=1.0e+21
*/
	void setMax_shade(double max_shade) 
		{ max_shade_ =  max_shade; } 
	double getMax_shade() const 
		{ return max_shade_; } 
        
/*!
    Magics Information:
    \brief  Lowest level for contours to be shaded 
    \param min_shade Setting contour_shade_min_level - default=-1.0e+21
*/
	void setMin_shade(double min_shade) 
		{ min_shade_ =  min_shade; } 
	double getMin_shade() const 
		{ return min_shade_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	double max_;
	double min_;
	double max_shade_;
	double min_shade_;

private:
  
	friend ostream& operator<<(ostream& s,const LevelSelectionAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
