/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file ObsPlottingAttributes.h
    \brief Definition of ObsPlotting Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Tue Nov 22 10:53:40 2011
*/
   

#ifndef ObsPlottingAttributes_H
#define ObsPlottingAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"



namespace magics {

class XmlNode;



class ObsPlottingAttributes 
{
public:
//  --  constructor
    ObsPlottingAttributes();
    
//  --  destructor
    virtual ~ObsPlottingAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const ObsPlottingAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief Minimum distance between the centre of any two observations in cm
    \param apart Setting obs_distance_apart - default=1.0
*/
	void setApart(double apart) 
		{ apart_ =  apart; } 
	double getApart() const 
		{ return apart_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	double apart_;

private:
  
	friend ostream& operator<<(ostream& s,const ObsPlottingAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
