/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file BinningObjectAttributes.h
    \brief Definition of BinningObject Attributes class.
    \author Meteorological Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Wed Dec  5 12:07:16 2012
*/
   

#ifndef BinningObjectAttributes_H
#define BinningObjectAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"



namespace magics {

class XmlNode;



class BinningObjectAttributes 
{
public:
//  --  constructor
    BinningObjectAttributes();
    
//  --  destructor
    virtual ~BinningObjectAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const BinningObjectAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

	

public:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream& out) const;
	//  --  members:
	string tag_;
	string x_;
	double x_min_;
	double x_max_;
	int x_count_;
	floatarray x_list_;
	double x_interval_;
	double x_reference_;
	string y_;
	double y_min_;
	double y_max_;
	int y_count_;
	floatarray y_list_;
	double y_interval_;
	double y_reference_;

private:
  
	friend ostream& operator<<(ostream& s,const BinningObjectAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
