/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file EpsCloudAttributes.cc
    \brief Implementation of EpsCloud Attributes class.
    \author Meteorological Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Wed Dec  5 12:07:14 2012
*/    

#include "EpsCloudAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


EpsCloudAttributes::EpsCloudAttributes():
	colour_(MagTranslator<string, Colour>().magics("eps_rose_cloud_colour")),
	border_colour_(MagTranslator<string, Colour>().magics("eps_rose_cloud_border_colour"))
{
} 



EpsCloudAttributes::~EpsCloudAttributes()
{
}

    
void EpsCloudAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(2);
	prefix[0] = "eps_rose_cloud";
	prefix[1] = "eps";

	setAttribute(prefix, "eps_rose_cloud_colour", colour_, params);
	setAttribute(prefix, "eps_rose_cloud_border_colour", border_colour_, params);
}

void EpsCloudAttributes::copy(const EpsCloudAttributes& other)
{
	colour_ = auto_ptr<Colour>(other.colour_->clone());
	border_colour_ = auto_ptr<Colour>(other.border_colour_->clone());
} 


bool EpsCloudAttributes::accept(const string& node)
{	
	if ( magCompare(node, "epscloud")  )
		return true;
	return false;
}

void EpsCloudAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "epscloud") )
		set(node.attributes());
	else {
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
	}
}

void EpsCloudAttributes::print(ostream& out)  const
{
	out << "EpsCloudAttributes[";
	out << "colour = " << *colour_;
	out << ", border_colour = " << *border_colour_;
	out << "]" << "\n";
}


void EpsCloudAttributes::toxml(ostream& out)  const
{
     out <<  "\"epscloud\"";
	 out << ", \"eps_rose_cloud_colour\":";
	 niceprint(out, *colour_);
	 out << ", \"eps_rose_cloud_border_colour\":";
	 niceprint(out, *border_colour_);
}
static MagicsParameter<string> eps_rose_cloud_colour("eps_rose_cloud_colour", "black", "");
static MagicsParameter<string> eps_rose_cloud_border_colour("eps_rose_cloud_border_colour", "none", "");
