/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file XYList.cc
    \brief Implementation of the Template class XYList.
    
    Magics Team - ECMWF 2004
    
    Started: Thu 6-May-2004
    
    Changes:
    
*/

#include "XYList.h"

using namespace magics;


XYList::XYList() 
{
	
}


XYList::~XYList() 
{
}

/*!
 Class information are given to the output-stream.
*/		
void XYList::print(ostream& out)  const
{
	out << "XYList[";
    XYListAttributes::print(out);
	out << "]";
}

void  XYList::prepare()
{
    if ( !empty() ) return;
    vector<double>::const_iterator i = x_.begin();
    vector<double>::const_iterator j = y_.begin();
    
    while ( i != x_.end() && j != y_.end() ) {
    	push_back(UserPoint(*i, *j, *j));
    	i++;
    	j++;
    }
    
    vector<double>::const_reverse_iterator i2 = x2_.rbegin();
    vector<double>::const_reverse_iterator j2 = y2_.rbegin();
    
    vector<double>::const_reverse_iterator ei2 = x2_.rend();
    vector<double>::const_reverse_iterator ej2 = y2_.rend();
    while ( i2 != ei2 && j2 != ej2 ) {
    	push_back(UserPoint(*i2, *j2, *j2));
    	i2++;
    	j2++;
    }
}
 

void XYList::customisedPoints(const std::set<string>&, CustomisedPointsList& out)
{
	vector<double>::const_iterator x = x_.begin();
	vector<double>::const_iterator y = y_.begin();
	vector<double>::const_iterator x2 = x2_.begin();
	vector<double>::const_iterator y2 = y2_.begin();
	vector<double>::const_iterator x_upper = x_upper_.begin();
	vector<double>::const_iterator y_upper = y_upper_.begin();
	vector<double>::const_iterator x_lower = x_lower_.begin();
	vector<double>::const_iterator y_lower = y_lower_.begin();
	
	while ( ( x != x_.end() && y != y_.end() ) || ( x2 != x2_.end() && y2 != y2_.end() ) ||
		    ( x_lower != x_lower_.end() && y_lower != y_lower_.end() ) || 
		    ( x_upper != x_upper_.end() && y_upper != y_upper_.end() )) {
		    	CustomisedPoint* point = new CustomisedPoint();
		    	if ( x != x_.end() ) (*point)["x"] = *(x++);
		    	if ( y != y_.end() ) (*point)["y"] = *(y++);
		    	if ( x2 != x2_.end() ) (*point)["x2"] = *(x2++);
		    	if ( y2 != y2_.end() ) (*point)["y2"] = *(y2++);
		    	if ( x_lower != x_lower_.end() ) (*point)["x_lower"] = *(x_lower++);
		    	if ( y_lower != y_lower_.end() ) (*point)["y_lower"] = *(y_lower++);
		    	if ( x_upper != x_upper_.end() ) (*point)["x_upper"] = *(x_upper++);
		    	if ( y_upper != y_upper_.end() ) (*point)["y_upper"] = *(y_upper++);
		    	out.push_back(point);
		    	
		    }
}

void XYList::getReady(const Transformation& transformation)
{
	try {
		for ( vector<string>::const_iterator x = x_date_.begin(); x != x_date_.end(); ++x )
			x_.push_back(transformation.x(*x));
		}
	catch (...) {}
	try {
		for ( vector<string>::const_iterator y = y_date_.begin(); y != y_date_.end(); ++y )
			y_.push_back(transformation.y(*y));
	}
	catch (...) {}
	
	try {
		for ( vector<string>::const_iterator x = x2_date_.begin(); x != x2_date_.end(); ++x )
			x2_.push_back(transformation.x(*x));
		}
	catch (...) {}
	try {
		for ( vector<string>::const_iterator y = y2_date_.begin(); y != y2_date_.end(); ++y )
			y2_.push_back(transformation.y(*y));
	}
	catch (...) {}
	
	
	try {
		for ( vector<string>::const_iterator x = x_upper_date_.begin(); x !=x_upper_date_.end(); ++x )
			x_upper_.push_back(transformation.x(*x));
		}
	catch (...) {}
	try {
		for ( vector<string>::const_iterator y = y_upper_date_.begin(); y != y_upper_date_.end(); ++y )
			y_upper_.push_back(transformation.y(*y));
	}
	catch (...) {}
	
	
	try {
		for ( vector<string>::const_iterator x = x_lower_date_.begin(); x != x_lower_date_.end(); ++x )
			x_lower_.push_back(transformation.x(*x));
		}
	catch (...) {}
	try {
		for ( vector<string>::const_iterator y = y_lower_date_.begin(); y != y_lower_date_.end(); ++y )
			y_lower_.push_back(transformation.y(*y));
	}
	catch (...) {}
}

