/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file OpenGLAnimationControl.h
    \brief Definition of OpenAnimationControl 
    \author Graphics Section, ECMWF

    Started: Dec 2008
*/

#ifndef _OpenGLAnimationControl_H
#define _OpenGLAnimationControl_H

#include <magics.h>
#include <MagicsEvent.h>

namespace magics
{

//class AnimationRules;
class OpenGLStepNode;

class OpenGLAnimationControl 
{

public:	
	OpenGLAnimationControl();
	void  addStep(OpenGLStepNode *fr);	
	void  addStepDef(OpenGLStepNode *fr);
	void  selectStep(int,list<OpenGLStepNode*>&);
	OpenGLStepNode* selectStepDef(int);
	int   stepNum();	
	void  stepLabel(int,vector<string>&);
	void  stepLabel(OpenGLStepNode*,vector<string>&);
	void  stepGridResolution(int,float &,float&);	
	bool  stepCached(int);
	bool  stepCached(OpenGLStepNode*);
	void  steps(vector<MagicsAnimationStepData>&);
	
	typedef list<OpenGLStepNode*>::const_iterator StepIterator;
        StepIterator firstStepDef() {return stepDef_.begin();}
	StepIterator lastStepDef() {return stepDef_.end();}
	
protected:
	//AnimationRules *rule_;
	list<OpenGLStepNode*>  stepDef_;
	list<OpenGLStepNode*>  step_;	 
};

}

#endif
