/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file OpenGLBaseWidget.cc
    \brief Implementation of the OpenGLBaseWidget class.
    \author Graphics Section, ECMWF

    Started: July 2008
*/

#include "OpenGLBaseWidget.h"
#include "Label.h"
#include "PaperPoint.h"
#include "Text.h"
#include <GL/gl.h>
#include <GL/glu.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <stdarg.h>

#include <OpenGLDriver.h>
#include <OpenGLFontHandler.h>
#include <OpenGLPainter.h>

#define PNG_DEBUG 3
#include <png.h>


OpenGLBaseWidget::OpenGLBaseWidget(OpenGLDriver *driver,OpenGLBaseWidget *parent,string name, 
				   int x, int y, int width, int height)
{
	name_=name;
	x_=x;
	y_=y;
	width_=width;
	height_=height;
	driver_=driver;
	parent_=parent;
		
	managed_=false;
	rendered_=false;

	cornerSize_=0;
	borderWidth_=0;
	borderHeight_=0;

	//background_=Colour(0.7,0.7,0.7);
	background_=Colour(211./255.,215./255.,223./255.);
	foreground_=Colour(0.7,0.7,0.7);
	borderColour_=Colour(0.6,0.6,0.6);
	
	colours_["background"]=&background_;
	colours_["foreground"]=&foreground_;
	colours_["border"]=&borderColour_;

	clipping_=false;

	active_=false;
	focused_=false;

	attachMode_=OpenGLWidget::AttachNone;
	sizePolicy_=OpenGLWidget::FixedSize;	

	painter_=OpenGLPainter::instance();
}

OpenGLBaseWidget::~OpenGLBaseWidget()
{
	for(list<OpenGLCallback*>::iterator it=callbackList_.begin(); it != callbackList_.end(); it++)
	{
		delete (*it);
	}
}	

bool OpenGLBaseWidget::checkPointInWidget(int x,int y) 
{
	return  (x-x_)*(x_+width_-x) >0 && (y-y_)*(y_+height_-y) > 0;	
}		

void OpenGLBaseWidget::addCallback(pt2f f,void *o,OpenGLWidget::CallbackType type)
{		
	callbackList_.push_back(new OpenGLCallback(f,o,type));	
}

void OpenGLBaseWidget::executeCallback(OpenGLWidget::CallbackType type,void* data)
{
	list<OpenGLCallback*>::iterator it = callbackList_.begin();
	while(it != callbackList_.end())
	{
		if((*it)->type() == type)
		{
			(*it)->execute(data);
			return;
		}
		it++;
	}	
	
}

void OpenGLBaseWidget::setColour(string name,Colour col)
{
	if(colours_.count(name) == 1)
	{
		colours_[name]->setColour(col.red(),col.green(),col.blue());		
	}	
}
	
string OpenGLBaseWidget::getSharedPngFileName(string name, string res)
{
	return getEnvVariable("MAGPLUS_HOME") + MAGPLUS_PATH_TO_SHARE_ + "ui/" + res + "/" + name + ".png";
}

						
