/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*! \file OpenGLBaseWidget.h
    \brief Definition of the OpenGLBaseWidget.
    \author Graphics Section, ECMWF
    
    Started: May 2008    
*/

#ifndef OpenGLBaseWidget_H
#define OpenGLBaseWidget_H

#include <GL/gl.h>

#include <magics.h>
#include "Colour.h"
#include <OpenGLCallback.h>
#include <OpenGLBox.h>

namespace OpenGLWidget
{
	enum AttachMode {AttachNone,AttachTop};
	enum SizePolicy {FixedSize,DynamicSize};
	enum DragType   {NoDrag, ResizeDrag, ReplaceDrag};
	enum DragArea   {NoDragArea, RightBorder};
};

class MtInputEvent;

namespace magics 
{

class OpenGLDriver;
class OpenGLFontHandler;
class OpenGLPainter;

class OpenGLBaseWidget
{
	
public:
	virtual void setX(int i) {x_=i;};
	virtual void setY(int i) {y_=i;};
	virtual void setWidth(int i) {width_=i;};
	virtual void setHeight(int i) {height_=i;};
	virtual void setPos(int x, int y) {x_=x; y_=y;}
	virtual void resetGeometry() {};

	void setBackground(Colour &c) {background_=c;};
	
	string& name() {return name_;};
	int getX() {return x_;};
	int getY() {return y_;};
	int getWidth() {return width_;};
	int getHeight() {return height_;};
	OpenGLDriver* getDriver() {return driver_;};

	OpenGLBaseWidget* getParent() {return parent_;};
	void setParent(OpenGLBaseWidget* w) {parent_=w;};
	
	void setManaged(bool b) {managed_=b;};

	void setClipping(bool b) {clipping_=b;}
	bool clipping() {return clipping_;};
	void setClipArea(OpenGLBox c) {clipArea_=c;}

	virtual void render() {};
	virtual bool rendered() {return false;};
	virtual void reRenderChild(OpenGLBaseWidget*){};

	virtual bool active() {return false;};
	void addCallback(pt2f,void*,OpenGLWidget::CallbackType);
	virtual void event(MtInputEvent*) {};
	
	void setColour(string,Colour);
	
	virtual bool checkPointInWidget(int,int);
	virtual void setVisiblePart(float,float){};
	
	void  setAttachMode(OpenGLWidget::AttachMode a) {attachMode_=a;};
	OpenGLWidget::AttachMode attachMode() {return attachMode_;};

	void  setSizePolicy(OpenGLWidget::SizePolicy s) {sizePolicy_=s;};
	OpenGLWidget::SizePolicy sizePolicy() {return sizePolicy_;};


protected:	
	string getSharedPngFileName(string, string);
	void executeCallback(OpenGLWidget::CallbackType,void* data=0);

	string name_;
	int x_;
	int y_;
	int width_;
	int height_;
	
	int borderWidth_;
	int borderHeight_;
	
	Colour background_;
	Colour foreground_;	
	Colour borderColour_;
	map<string,Colour*> colours_;
	
	bool 	managed_;
	bool	rendered_;	

	bool   	active_;
	bool    focused_;

	int    	cornerSize_;	

	bool    clipping_;
	OpenGLBox  clipArea_;


	OpenGLBaseWidget* parent_;
	OpenGLBaseWidget* root_;
	OpenGLBaseWidget* manager_;
	OpenGLDriver*     driver_;
	OpenGLPainter*    painter_;

	OpenGLWidget::AttachMode  attachMode_;
	OpenGLWidget::SizePolicy  sizePolicy_;

protected:
	OpenGLBaseWidget(OpenGLDriver*,OpenGLBaseWidget*,string,int=0,int=0,int=0,int=0);	
	~OpenGLBaseWidget();	
	list<OpenGLCallback*> callbackList_;
	
};	

typedef list<OpenGLBaseWidget*> mglWidgetList;

}
#endif
