/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file OpenGLFboItem.cc
    \brief Implementation of the OpenGLFboItem class.
    \author Graphics Section, ECMWF

    Started: August 2008
*/
#include <OpenGLFboItem.h>
#include <Log.h>

#include <GL/gl.h>
#include <GL/glu.h>

using namespace magics;

OpenGLFboItem::OpenGLFboItem()
{
	fboId_=0;
	
	//We have to store the bound status in this variable because 
	//glIsTexture cannot be used in display lists
	bound_=false;
}

OpenGLFboItem::~OpenGLFboItem()
{
	clear();
}	

void OpenGLFboItem::generate()
{	
	if(isEmpty())
	{
		glGenFramebuffersEXT(1,&fboId_);
		bound_=false;
	}
}

void  OpenGLFboItem::clear()
{	
 	if(!isEmpty()) 
      	{	 
		glDeleteFramebuffersEXT(1,&fboId_);
	  	fboId_=0;
		bound_=false;
	}
}

bool OpenGLFboItem::isEmpty()
{
	return (fboId_==0)?true:false;
}

bool OpenGLFboItem::isBound()
{
	//We have to store the bound status in this variable because 
	//glIsTexture cannot be used in display lists
	return bound_;
}

void  OpenGLFboItem::attachTexture(GLuint texId)
{
	/*GLuint rboid;
	glGenRenderbuffersEXT(1,&rboid);
	glBindRenderbufferEXT(GL_RENDERBUFFER_EXT,rboid);
	glRenderbufferStorageEXT(GL_RENDERBUFFER_EXT, GL_DEPTH_COMPONENT,876,620);
	glBindRenderbufferEXT(GL_RENDERBUFFER_EXT,0);

	glFramebufferRenderbufferEXT(GL_FRAMEBUFFER_EXT,GL_DEPTH_ATTACHMENT_EXT, GL_RENDERBUFFER_EXT,rboid);
	glBindRenderbufferEXT(GL_RENDERBUFFER_EXT,0);*/


	glFramebufferTexture2DEXT(GL_FRAMEBUFFER_EXT,GL_COLOR_ATTACHMENT0_EXT,GL_TEXTURE_2D,texId,0);
}

void  OpenGLFboItem::bind()
{	
	generate();
	
	glBindFramebufferEXT(GL_FRAMEBUFFER_EXT,fboId_);
}


void  OpenGLFboItem::unBind()
{	
	glBindFramebufferEXT(GL_FRAMEBUFFER_EXT,0);
}

bool OpenGLFboItem::checkStatus()
{
	GLenum status = glCheckFramebufferStatusEXT(GL_FRAMEBUFFER_EXT);
	if(status != GL_FRAMEBUFFER_COMPLETE_EXT)
	{
		return false;//checkError("OpenGLDriver::renderTree() 1111111");	
	}
	return true;
}