/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file OpenGLFontHandler.h
    \brief Definition of OpenGLFontHandler.
    \author Graphics Section, ECMWF

    Started: May 2004
*/


#ifndef _OpenGLFontHandler_H
#define _OpenGLFontHandler_H

#include <Colour.h>
#include <OpenGLDriverText.h>

namespace magics 
{

class OpenGLFontItem
{
public:		
	OpenGLFontItem(const string&,const float,const Colour &);
	~OpenGLFontItem();
	
	bool equal(const string name,const float size,const Colour &col)
	{
	       return name == name_ && size == size_ &&  
	       col.red() == col_.red() &&
	       col.green() == col_.green() &&
	       col.blue() == col_.blue();
	} 
	
	void print(ostream& out)
	{
		out << "  name: " << name_ << " pt: " << static_cast<int>(size_);
		out << " texture: " << font_->getTexobjListSize() << endl; 
	}	     
	OGLFT::TranslucentTexture* font() {return font_;};

private:
	OGLFT::TranslucentTexture*  font_;
	string name_;
	float size_;
	Colour col_;	
};



class OpenGLFontHandler
{
public:
	OpenGLFontHandler() {};
	OGLFT::TranslucentTexture* getFont(const string&,const float,const Colour&);
	OGLFT::TranslucentTexture* addFont(const string&,const float,const Colour&);
	void   deleteFont(const string&,const float,const Colour&);
	void   clear();
	void   print(ostream&);
	
private:
	list<OpenGLFontItem*> fonts_;
	
};

}

#endif
