/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file OpenGLManagerWidget.cc
    \brief Implementation of the OpenGLManagerWidget class.
    \author Graphics Section, ECMWF

    Started: July 2008
*/

#include <OpenGLManagerWidget.h>
#include <OpenGLDriver.h>

#include <GL/gl.h>
#include <GL/glu.h>

#include <MtInputEvent.h>

using namespace magics;


void OpenGLManagerWidget::setX(int x)
{
	int dx=x-x_;
	for(mglWidgetList::iterator it=children_.begin(); it !=children_.end(); it++)
	{
		int xc=(*it)->getX();
		(*it)->setX(xc+dx);	
	}
	x_=x;	
}

void OpenGLManagerWidget::setY(int y)
{
	int dy=y-y_;
	for(mglWidgetList::iterator it=children_.begin(); it !=children_.end(); it++)
	{
		int yc=(*it)->getY();
		(*it)->setY(yc+dy);	
	}
	y_=y;	
}

void OpenGLManagerWidget::setPos(int x,int y)
{
	int dx=x-x_;
	int dy=y-y_;

	for(mglWidgetList::iterator it=children_.begin(); it !=children_.end(); it++)
	{
		int xc=(*it)->getX();
		int yc=(*it)->getY();
		(*it)->setPos(xc+dx,yc+dy);	
	}
	
	x_=x;
	y_=y;
}

void OpenGLManagerWidget::setWidth(int w)
{
	int dw=w-width_;
	for(mglWidgetList::iterator it=children_.begin(); it !=children_.end(); it++)
	{
		if((*it)->sizePolicy() == OpenGLWidget::DynamicSize)
		{
			int xc=(*it)->getWidth();
			(*it)->setWidth(xc+dw);
		}	
	}
	width_=w;	
}

void OpenGLManagerWidget::setHeight(int h)
{
	int dh=h-height_;
	for(mglWidgetList::iterator it=children_.begin(); it !=children_.end(); it++)
	{
		if((*it)->attachMode() == OpenGLWidget::AttachTop)
		{
			int yc=(*it)->getY();
			(*it)->setY(yc+dh);	
		}
	}
	height_=h;	
}

void OpenGLManagerWidget::resetGeometry()
{	
	for(mglWidgetList::iterator it=children_.begin(); it !=children_.end(); it++)
	{		
		(*it)->resetGeometry();	
	}
}


OpenGLBaseWidget* OpenGLManagerWidget::addChild(OpenGLBaseWidget *ch)
{
	ch->setParent(this);
	ch->setManaged(true);
	//ch->setOffset(x_,y_);
	children_.push_back(ch);
	return ch;
}
 
void OpenGLManagerWidget::removeChild(OpenGLBaseWidget *ch)
{
	for(mglWidgetList::iterator it=children_.begin(); it !=children_.end(); it++)
	{
		if( *it == ch)
		{
			children_.erase(it);
			return;
		}
	}	
}
        
void OpenGLManagerWidget::render()
{
	//if(managed_) parent_->render_preTransform();

	//setTransparency();
	
	//driver_->mapBgImageToFb(0,x_,y_,x_+width_,y_+height_+12);
	//driver_->mapBgImageToFb(0);
	
	//glPushAttrib(GL_POLYGON_BIT);
	
	//Only front sides are rendered
	//glFrontFace(GL_CCW);
	//glEnable(GL_CULL_FACE);	
	//glCullFace(GL_BACK);	
		
	//Fill the area occupied by the object		
	//glPolygonMode(GL_FRONT,GL_FILL);


	/*Colour col_top=background_;	
	Colour col_bottom=col_top;
	col_bottom.scaleLight(0.9);*/

	//glShadeModel(GL_SMOOTH);

	//Hsl hsl=col.hsl();
	//hsl.light_*=0.6;
	//Colour col1(hsl);

	//col=(highlighted_==false)?backround_:backgroundH_;	
	//glColor4f(col.red(),col.green(),col.blue(),col.alpha());
			
	//glEnable(GL_BLEND); 
	//glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);	
	
	//renderRoundedRect(x_,y_,x_+width_,y_+height_,
	//		  3.,col,true,true,col1);
         
	/*renderFilledRoundedRect(x_,y_,x_+width_,y_+height_,
			  3.,col_top,1,col_bottom);
      
	borderColour_=Colour(0.2,0.2,0.2);
	Colour col=borderColour_;	

	renderRoundedRect(x_,y_,x_+width_,y_+height_,
			  3.,col,1,false,0);   */         

	//glRectf(x_,y_,x_+width_,y_+height_);
	
	//glDisable(GL_BLEND);
	
	//glPopAttrib();
			
	//Render children	
	for(mglWidgetList::iterator it=children_.begin(); it != children_.end(); it++)
	{
		(*it)->render();
		OpenGLBaseWidget *w=*it;
		driver_->checkError("manager render");
	}		
	
	//if(managed_) parent_->render_postTransform();	
	
	//Swap buffers
	//GLwDrawingAreaSwapBuffers(driver_->widget());
}

bool  OpenGLManagerWidget::checkFocus(MtInputEvent *event)
{
	if(event->type() == Mt::MouseMoveEvent)
	{	
		MtMouseEvent *mev = (MtMouseEvent *) event;
		int x = mev->x();
 		int y = mev->y();
		
                //The manager widget is selected if the pointer is in the gui area
                focused_=checkPointInWidget(x,y);
		
		return true;
	}
	return false;			
}

void OpenGLManagerWidget::event(MtInputEvent *event)
{		
	rendered_=false;
	//active_=false;

	//Check if the pointer is in the widget
	checkFocus(event);
	
	//If the pointer is in the widget then dispatch events to children
	if(focused_ == true || active_ == true)
	{	
		active_=false;
		for(mglWidgetList::iterator it=children_.begin(); it !=children_.end(); it++)
		{
			//Log::dev() << "OpenGLManagerWidget::event ---> child: " << (*it)->name() << endl;


			(*it)->event(event);			
                        
                        //Children are active only in case of drag action
                        if((*it)->active())
			{
				//Log::dev() << "OpenGLManagerWidget::event  ---> Child is active!" << endl;
				active_=true;
			
				/*if(parent_ == 0 || 
				   typeid(*parent_) != typeid(OpenGLScrolledWindowWidget))
				{
					if( !(*it)->rendered())
					{
						
						driver_->mapBgImageToFb(0,
						  (*it)->getX(),(*it)->getY(),
						  (*it)->getX()+(*it)->getWidth(),
						  (*it)->getY()+(*it)->getHeight());
						  (*it)->render();
						GLwDrawingAreaSwapBuffers(driver_->widget());
					}
				
					rendered_=true;				
				}
				else
				{
					rendered_=false;
				}*/

				return;
			}	
		}
	}	
}
/*---------------------------------------------
 A child's request for re-rendering
-----------------------------------------------*/

/*void OpenGLManagerWidget::reRenderChild(OpenGLBaseWidget *w)
{	
	driver_->mapBgImageToFb(0,w->getX(),w->getY(),
	     w->getX()+w->getWidth(),w->getY()+w->getHeight());

	w->render();
	
	GLwDrawingAreaSwapBuffers(driver_->widget());
}*/

bool OpenGLManagerWidget::active()
{
	//The manager widget is active if there is an active child
	return (active_ == true);
}




