/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file OpenGLPickObjectCreator.h
    \brief Definition of OpenGLPickObjectCreator
    \author Graphics Section, ECMWF

    Started: May 2004
*/

#ifndef _OpenGLPickObjectCreator_H
#define _OpenGLPickObjectCreator_H

#include <SelectionMode.h>
#include <OpenGLCommon.h>
#include <OpenGLBaseTool.h>
#include <OpenGLDriverObserver.h>

namespace magics
{

class OpenGLDriver;
class OpenGLPickObject;
class OpenGLLayoutNode;

class OpenGLPickObjectCreator : public OpenGLDriverObserver, public OpenGLBaseTool
{

public:
	OpenGLPickObjectCreator(OpenGLDriver*);
	~OpenGLPickObjectCreator();
	
	void setInteractiveMode(InteractiveMode);	
	void event(MtInputEvent*);
	bool active();

protected:		
	void begin(const int, const int);
	void addpoint(const int, const int);
	void draw(const int, const int);
	void end(const int, const int);
	
	void enterMode(InteractiveMode);
	void leaveMode();
			
	OpenGLLayoutNode* identifyParent(float,float);
	
	mutable InteractiveMode interactiveMode_;
	mutable PickMode pickMode_;
	std::set<InteractiveMode> creationModes_;
	
	mutable SelectionMode pickObjectAttr_;
	
	mutable int pickX_;
	mutable int pickY_;	
	mutable int prevX_;
	mutable int prevY_;
	
	OpenGLLayoutNode* parent_;
	OpenGLPickObject* object_;	
	OpenGLDriver* driver_;
};	

}

#endif
