/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file OpenGLSymbolManager.h
    \brief Definition of OpenGLSymbolManager.
    \author Graphics Section, ECMWF

    Started: May 2009
*/

#ifndef _OpenGLSymbolmanager_H
#define _OpenGLSymbolManager_H

#include <magics.h>
#include <OpenGLDplManager.h>

using namespace std;

namespace magics 
{

class OpenGLSymbolItem : public OpenGLDplItem
{
public:
	OpenGLSymbolItem(string id,float s) : id_(id), size_(s) {};

	string   id()    {return id_;}
	float size()  {return size_;};
	bool equal(const string,const float);

protected:
	string id_;
	float size_;

};

class OpenGLSymbolManager : public list<OpenGLSymbolItem*>
{
public:
	OpenGLSymbolManager() {};
	~OpenGLSymbolManager();
 
	OpenGLSymbolItem* addSymbol(const string,const float);
	OpenGLSymbolItem* getSymbol(const string,const float);	
	void deleteSymbol(const string,const float);		

	void   print(ostream&);
	int getSize() {return size();};	

private:	
	typedef list<OpenGLSymbolItem*>::iterator SymbolIterator;
	SymbolIterator firstItem() { return begin();};
	SymbolIterator lastItem() {return end();};
};
	


}


#endif 
