#include "Text.h"
#include "PaperPoint.h"

#include "OpenGLTooltip.h"
#include "OpenGLPainter.h"
#include "OpenGLTextureItem.h"

OpenGLTooltip*  OpenGLTooltip::instance_=0;

using namespace magics;


OpenGLTooltip::OpenGLTooltip()
{
	borderColour_=Colour(0.6,0.6,0.6);
	background_=Colour(249./255.,205./255.,146./255.);

	fontColour_=Colour(0.,0.,0.);
	fontSize_=8.;

	bgTex_= new OpenGLTextureItem;
	bgTex_->transparent(false);

	type_=NoTooltip;
}

OpenGLTooltip::~OpenGLTooltip()
{
	delete bgTex_;
}

OpenGLTooltip* OpenGLTooltip::instance()
{
	if(!instance_)
	{
		instance_=new OpenGLTooltip;
	}
	return instance_;
}

void OpenGLTooltip::setBackgroundColour(Colour c)
{
	background_=c;
}

void OpenGLTooltip::setBorderColour(Colour c)
{
	borderColour_=c;
}


void OpenGLTooltip::computeTextSize(vector<string> &txt,int &w, int &h)
{
	//Text len
	int len=0;
	for(int i=0; i < txt.size(); i++)
	{
		if(txt[i].size() > len)
		{
			len=txt[i].size();
		}
	}

	//Set width
	w=static_cast<int>(fontSize_*3.+len*fontSize_*0.8+fontSize_*3.);

	//Set height
	h=static_cast<int>(txt.size()*1.9*fontSize_);
}

void OpenGLTooltip::saveBg()
{
	bgTex_->generateFromFb(x_-1,y_-1,width_+2,height_+2,GL_RGB);
}

void OpenGLTooltip::displayText()
{
	//Compute tooltip size
	computeTextSize(text_,width_,height_);

	//Save area into texture
	saveBg();

	Colour col=background_;
	OpenGLPainter::instance()->renderFilledRoundedRect(x_,y_,x_+width_,y_+height_,8,col);
	//OpenGLPainter::instance()->renderFilledRect(x_,y_,x_+width_,y_+height_,col);

	col=borderColour_;
	OpenGLPainter::instance()->renderRoundedRect(x_,y_,x_+width_,y_+height_,8,borderColour_,1,false);
	//OpenGLPainter::instance()->renderRect(x_,y_,x_+width_,y_+height_,borderColour_);

	float xp=x_+fontSize_*3.;
	float yp=y_+fontSize_;

	for(int i=0; i < text_.size(); i++)
	{
		Text text;
		PaperPoint pp(xp,yp);
		text.push_back(pp);

		text.addText(text_[i],fontColour_,fontSize_*2.54/75.); //75 dpi
		text.setJustification(MLEFT);
		text.setVerticalAlign(MBASE);
		text.setAngle(0.);

		OpenGLPainter::instance()->renderText(&text);

		yp+=1.7*fontSize_;
	}

	displayed_=true;
}

void OpenGLTooltip::displayTexture()
{
	//Save area into texture
	saveBg();

	float xp1, xp2, yp1, yp2;
	xp1=x_;
	xp2=xp1+tex_->width();
	yp1=y_;
	yp2=yp1+tex_->height();

	tex_->mapTexture(xp1,yp1,xp2,yp2);

	displayed_=true;
}

void OpenGLTooltip::setText(vector<string> &txt,int x, int y)
{
	undisplay();

	type_=OpenGLTooltip::TextTooltip;

	text_=txt;
	x_=x;
	y_=y;
}


void OpenGLTooltip::setTexture(OpenGLTextureItem * tex,int x, int y)
{
	type_=OpenGLTooltip::TextureTooltip;

	displayed_=false;

	tex_=tex;
	x_=x;
	y_=y;
}

void OpenGLTooltip::display()
{
	if(displayed_) undisplay();

	switch(type_)
	{
	case NoTooltip:
		break;
	case TextTooltip:
		displayText();
		break;
	case TextureTooltip:
		displayTexture();
		break;
	default:
		break;
	}
}

void OpenGLTooltip::undisplay()
{
	//First remap the original Fb content under the tooltip
	if(displayed_)
	{
		if(!bgTex_->isEmpty())
		{
			float xp1, xp2, yp1, yp2;
			xp1=bgTex_->x();
			xp2=xp1+bgTex_->width();
			yp1=bgTex_->y();
			yp2=yp1+bgTex_->height();

			bgTex_->mapTexture(xp1,yp1,xp2,yp2);

			//Delete the texture
			bgTex_->clear();
		}
	}

	//Then reset everything
	clear();
}


void OpenGLTooltip::clear()
{
	displayed_=false;
	type_=NoTooltip;
	bgTex_->clear();
}

//Is there anything to display
bool OpenGLTooltip::empty()
{
	return displayed_ == true  || type_ == NoTooltip;
}

