
/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 	http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file OpenGLTooltip.h
    \brief Definition of OpenGLTooltip.
    \author Graphics Section, ECMWF

    Started: May 2009
*/

#ifndef _OpenGLTooltip_H
#define _OpenGLTooltip_H

#include "magics.h"
#include "Colour.h"

namespace magics {

class OpenGLTextureItem;

class OpenGLTooltip
{
public:
	~OpenGLTooltip();
	static OpenGLTooltip *instance();

	void computeTextSize(vector<string>&,int&,int&);
	void setText(vector<string>&,int,int);
	void setTexture(OpenGLTextureItem *,int,int);
	void display();
	void undisplay();
	void clear();
	bool empty();

	void setBackgroundColour(Colour);
	void setBorderColour(Colour);

private:
	OpenGLTooltip();

	void displayText();
	void displayTexture();
	void saveBg();

	static OpenGLTooltip * instance_;

	Colour background_;
	Colour borderColour_;
	int borderWidth_;

	Colour fontColour_;
	float  fontSize_;

	int x_;
	int y_;
	int width_;
	int height_;

	bool displayed_;
	OpenGLTextureItem *bgTex_;
	OpenGLTextureItem *tex_;

	vector<string> text_;

	enum TooltipType {NoTooltip, TextTooltip, TextureTooltip};
	TooltipType type_;
};

}
#endif
