/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file AxisLineAttributes.cc
    \brief Implemtation of AxisLine Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Mon Oct 26 20:27:36 2009
*/    

#include "AxisLineAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "Translator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


AxisLineAttributes::AxisLineAttributes():
	colour_(Translator<string, Colour>().magics("axis_line_colour")),
	default_colour_(Translator<string, Colour>().magics("subpage_frame_colour")),
	thickness_(ParameterManager::getInt("axis_line_thickness")),
	style_(Translator<string, LineStyle>().magics("axis_line_style")),
	position_(ParameterManager::getDouble("axis_line_position"))
{
} 



AxisLineAttributes::~AxisLineAttributes()
{
}

    
void AxisLineAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(2);
	prefix[0] = "axis_line";
	prefix[1] = "axis";

	setAttribute(prefix, "axis_line_colour", colour_, params);
	setAttribute(prefix, "subpage_frame_colour", default_colour_, params);
	setAttribute(prefix, "axis_line_thickness", thickness_, params);
	setAttribute(prefix, "axis_line_style", style_, params);
	setAttribute(prefix, "axis_line_position", position_, params);
}

void AxisLineAttributes::copy(const AxisLineAttributes& other)
{
	setColour(other.colour_->clone());
	setDefault_colour(other.default_colour_->clone());
	thickness_ = other.thickness_;
	style_ = other.style_;
	position_ = other.position_;
} 


bool AxisLineAttributes::accept(const string& node)
{	
	if ( magCompare(node, "line")  )
		return true;
	return false;
}

void AxisLineAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "line") )
		set(node.attributes());
	else {
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
	}
}

void AxisLineAttributes::print(ostream& out)  const
{
	out << "AxisLineAttributes[";
	out << "colour = " << *colour_;
	out << ", default_colour = " << *default_colour_;
	out << ", thickness = " << thickness_;
	out << ", style = " << style_;
	out << ", position = " << position_;
	out << "]" << "\n";
}


void AxisLineAttributes::toxml(ostream& out, const string& tag, int tabs)  const
{
	string tab;
	for ( int t = 0; t < tabs; t++) tab = tab + "	";
	
	out << tab << "<" << tag << "\n";
	out << tab << "\taxis_line_colour = \'" << *colour_ << "\'\n";
	out << tab << "\tsubpage_frame_colour = \'" << *default_colour_ << "\'\n";
	out << tab << "\taxis_line_thickness = \'" << thickness_ << "\'\n";
	out << tab << "\taxis_line_style = \'" << style_ << "\'\n";
	out << tab << "\taxis_line_position = \'" << position_ << "\'\n";
	out << tab << ">";


	out << tab << "</" << tag << ">\n";
}

static MagicsParameter<string> axis_line_colour("axis_line_colour", "automatic", " New Magics: Parameter axis_line_colour sent to new Magics[XYSystem].  ");
static MagicsParameter<string> subpage_frame_colour("subpage_frame_colour", "blue", "");
static MagicsParameter<int> axis_line_thickness("axis_line_thickness", 2, " New Magics: Parameter axis_line_thickness sent to new Magics[XYSystem].  ");
static MagicsParameter<string> axis_line_style("axis_line_style", "solid", " New Magics: Parameter axis_line_position sent to new Magics[XYSystem].  ");
static MagicsParameter<double> axis_line_position("axis_line_position", 0.0, " New Magics: Parameter axis_line_position sent to new Magics[XYSystem].  ");
