/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file LegendMethod.cc
    \brief Implementation of the Template class LegendMethod.
    
    Magics Team - ECMWF 2006
    
    Started: Tue 9-May-2006
    
    Changes:
    
*/

#include "LegendMethod.h"
#include "LegendVisitor.h"



using namespace magics;

LegendMethod::LegendMethod() 
{
}


LegendMethod::~LegendMethod() 
{
}

/*!
 Class information are given to the output-stream.
*/		
void LegendMethod::print(ostream& out)  const
{
	out << "LegendMethod[";
	out << "]";
}

void LegendMethod::row(LegendEntry& entry, double x, double y, Text& legend, BasicGraphicsObjectContainer& task) 
{
	entry.set(PaperPoint(x-0.25, y), task);
	legend.setJustification(MLEFT);		
	legend.push_back(PaperPoint(x + entry.textRowPosition(), y)); // WE attach the text on the rigth of the sumbol!
} 	

void LegendMethod::column(LegendEntry& entry, double x, double y, Text& legend, BasicGraphicsObjectContainer& task) 
{
	float shift = legend.empty() ? -0.5 : 0.5; 
	entry.set(PaperPoint(x-shift, y), task);
    
	legend.setJustification(MLEFT);		
	legend.push_back(PaperPoint(x-shift + entry.textColumnPosition(), y)); // WE attach the text on the rigth of the sumbol!
} 

void ContinuousLegendMethod::row(LegendEntry& entry, double x, double y, Text& legend, BasicGraphicsObjectContainer& task) 
{
	entry.rowBox(PaperPoint(x, y), task);
	
	//legend.setJustification(MCENTRE);		
	//legend.push_back(PaperPoint(x, y+0.75)); // WE attach the text on the bottom of the sumbol!
} 	

void ContinuousLegendMethod::column(LegendEntry& entry, double x, double y, Text& legend, BasicGraphicsObjectContainer& task) 
{
	entry.columnBox(PaperPoint(x, y), task);
	
	//legend.setJustification(MLEFT);		
	//legend.push_back(PaperPoint(x+0.15, y)); // WE attach the text on the right of the sumbol!
} 	
