
/*******************************  LICENSE  *******************************

 * (C) Copyright 1996-2016 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \fileNoCoastPlottingAttributes.h
    \brief Definition of NoCoastPlotting Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 
*/
   

#ifndef NoCoastPlottingAttributes_H
#define NoCoastPlottingAttributes_H

#include "magics.h"
#include "Colour.h"
#include "Boundaries.h"
#include "Cities.h"
namespace magics {

class XmlNode;
class NoCoastPlottingAttributes 
{
public:
//  --  constructor
    NoCoastPlottingAttributes();
    
//  --  destructor
    virtual ~NoCoastPlottingAttributes();
    
    virtual void set(const std::map<std::string, std::string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const NoCoastPlottingAttributes&);
    virtual bool accept(const std::string&);

    void setTag(const std::string& tag) { tag_ = tag; }

public:
	//  --  method
	virtual void print(std::ostream&) const;
	virtual void toxml(std::ostream& out) const;
	//  --  members:
	string tag_;
	string resolution_;
	bool land_;
	bool sea_;
	bool preview_;
	string rivers_;
	int rivers_thickness_;
	string efas_;
	string efas_domain_;
	int efas_thickness_;
	string user_layer_;
	string user_layer_name_;
	string user_layer_projection_;
	int user_layer_thickness_;
	unique_ptr<Colour> land_colour_;
	unique_ptr<Colour> sea_colour_;
	unique_ptr<NoBoundaries> boundaries_;
	unique_ptr<NoCities> cities_;
	LineStyle rivers_style_;
	unique_ptr<Colour> rivers_colour_;
	LineStyle efas_style_;
	unique_ptr<Colour> efas_colour_;
	LineStyle user_layer_style_;
	unique_ptr<Colour> user_layer_colour_;
	unique_ptr<Colour> user_layer_land_colour_;
	 

private:
	friend ostream& operator<<(ostream& s,const NoCoastPlottingAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif

