
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file WrepJSonAttributes.h
    \\brief Definition of WrepJSon Attributes class.

    This file is automatically generated.
    Do Not Edit!

*/

#include "MagRequest.h"
#include "WrepJSonWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "MagicsGlobal.h"

using namespace magics;



WrepJSonWrapper::WrepJSonWrapper(): wrepjson_(new WrepJSon())


{


	

}
WrepJSonWrapper::WrepJSonWrapper(WrepJSon* wrepjson): wrepjson_(wrepjson)
{

	
}

WrepJSonWrapper::~WrepJSonWrapper()
{

}

void WrepJSonWrapper::set(const MagRequest& request)
{

	

	if  (request.countValues("WREPJSON_INPUT_FILENAME") ) {
		string path_value = request("WREPJSON_INPUT_FILENAME");
		wrepjson_->path_ = path_value;
		}
	if  (request.countValues("WREPJSON_PARAMETER_INFORMATION") ) {
		string param_info_value = request("WREPJSON_PARAMETER_INFORMATION");
		wrepjson_->param_info_ = param_info_value;
		}
	if  (request.countValues("WREPJSON_TITLE") ) {
		string title_value = request("WREPJSON_TITLE");
		
		wrepjson_->title_ = MagTranslator<string, bool>()(title_value);
		
		}
	if  (request.countValues("WREPJSON_POSITION_INFORMATION") ) {
		string position_info_value = request("WREPJSON_POSITION_INFORMATION");
		
		wrepjson_->position_info_ = MagTranslator<string, bool>()(position_info_value);
		
		}
	if  (request.countValues("WREPJSON_PRODUCT_INFORMATION") ) {
		string product_info_value = request("WREPJSON_PRODUCT_INFORMATION");
		wrepjson_->product_info_ = product_info_value;
		}
	if  (request.countValues("WREPJSON_FAMILY") ) {
		string family_value = request("WREPJSON_FAMILY");
		wrepjson_->family_ = family_value;
		}
	if  (request.countValues("WREPJSON_KEY") ) {
		string key_value = request("WREPJSON_KEY");
		wrepjson_->key_ = key_value;
		}
	if  (request.countValues("WREPJSON_PLUMES_INTERVAL") ) {
		double plumes_value = request("WREPJSON_PLUMES_INTERVAL");
		wrepjson_->plumes_ = plumes_value;
		}
	if  (request.countValues("WREPJSON_INFORMATION") ) {
		string information_value = request("WREPJSON_INFORMATION");
		
		wrepjson_->information_ = MagTranslator<string, bool>()(information_value);
		
		}
	if  (request.countValues("WREPJSON_KEYWORD") ) {
		string keyword_value = request("WREPJSON_KEYWORD");
		wrepjson_->keyword_ = keyword_value;
		}
	if  (request.countValues("WREPJSON_STATION_NAME") ) {
		string station_name_value = request("WREPJSON_STATION_NAME");
		wrepjson_->station_name_ = station_name_value;
		}
	if  (request.countValues("WREPJSON_PARAMETER") ) {
		string param_value = request("WREPJSON_PARAMETER");
		wrepjson_->param_ = param_value;
		}
	if  (request.countValues("WREPJSON_PARAMETER_SCALING_FACTOR") ) {
		double param_scaling_factor_value = request("WREPJSON_PARAMETER_SCALING_FACTOR");
		wrepjson_->param_scaling_factor_ = param_scaling_factor_value;
		}
	if  (request.countValues("WREPJSON_PARAMETER_OFFSET_FACTOR") ) {
		double param_offset_factor_value = request("WREPJSON_PARAMETER_OFFSET_FACTOR");
		wrepjson_->param_offset_factor_ = param_offset_factor_value;
		}
	if  (request.countValues("WREPJSON_CLIM_PARAMETER") ) {
		string clim_param_value = request("WREPJSON_CLIM_PARAMETER");
		wrepjson_->clim_param_ = clim_param_value;
		}
	if  (request.countValues("WREPJSON_CLIM_STEP") ) {
		int clim_step_value = request("WREPJSON_CLIM_STEP");
		wrepjson_->clim_step_ = clim_step_value;
		}
	intarray steps_value;
	for (int i = 0; i < request.countValues("WREPJSON_STEPS"); i++)
		steps_value.push_back((int)request("WREPJSON_STEPS", i));
	if ( !steps_value.empty() )
		wrepjson_->steps_ = steps_value;
	if  (request.countValues("WREPJSON_Y_AXIS_PERCENTILE") ) {
		double percentile_value = request("WREPJSON_Y_AXIS_PERCENTILE");
		wrepjson_->percentile_ = percentile_value;
		}
	if  (request.countValues("WREPJSON_Y_AXIS_THRESHOLD") ) {
		double threshold_value = request("WREPJSON_Y_AXIS_THRESHOLD");
		wrepjson_->threshold_ = threshold_value;
		}
	if  (request.countValues("WREPJSON_Y_MAX_THRESHOLD") ) {
		double y_max_threshold_value = request("WREPJSON_Y_MAX_THRESHOLD");
		wrepjson_->y_max_threshold_ = y_max_threshold_value;
		}
	if  (request.countValues("WREPJSON_Y_PERCENTAGE") ) {
		double y_percent_value = request("WREPJSON_Y_PERCENTAGE");
		wrepjson_->y_percent_ = y_percent_value;
		}
	if  (request.countValues("WREPJSON_TEMPERATURE_CORRECTION") ) {
		string correction_value = request("WREPJSON_TEMPERATURE_CORRECTION");
		
		wrepjson_->correction_ = MagTranslator<string, bool>()(correction_value);
		
		}
	if  (request.countValues("WREPJSON_MISSING_VALUE") ) {
		double missing_value_value = request("WREPJSON_MISSING_VALUE");
		wrepjson_->missing_value_ = missing_value_value;
		}
	stringarray  ignore_keys_value;
	for (int i = 0; i < request.countValues("WREPJSON_IGNORE_KEYS"); i++)
		ignore_keys_value.push_back((string)request("WREPJSON_IGNORE_KEYS", i));
	if ( !ignore_keys_value.empty() )
		wrepjson_->ignore_keys_ = ignore_keys_value;
	if  (request.countValues("WREPJSON_PROFILE_QUANTILE") ) {
		string profile_quantile_value = request("WREPJSON_PROFILE_QUANTILE");
		wrepjson_->profile_quantile_ = profile_quantile_value;
		}
	if  (request.countValues("WREPJSON_HODOGRAPH_GRID") ) {
		string hodograph_grid_value = request("WREPJSON_HODOGRAPH_GRID");
		
		wrepjson_->hodograph_grid_ = MagTranslator<string, bool>()(hodograph_grid_value);
		
		}
	if  (request.countValues("WREPJSON_HODOGRAPH_TEPHI") ) {
		string hodograph_tephi_value = request("WREPJSON_HODOGRAPH_TEPHI");
		
		wrepjson_->hodograph_tephi_ = MagTranslator<string, bool>()(hodograph_tephi_value);
		
		}
	if  (request.countValues("WREPJSON_HODOGRAPH_MEMBER") ) {
		int hodograph_member_value = request("WREPJSON_HODOGRAPH_MEMBER");
		wrepjson_->hodograph_member_ = hodograph_member_value;
		}
	
	
}

void WrepJSonWrapper::print(ostream& out)  const
{
	out << "WrepJSonWrapper[]";
}


