from mago.test_suite.evolution import EvolutionTestSuite
from mago.application.evolution import Evolution, AccountInfo
from ConfigParser import ConfigParser
import ldtp, ooldtp, ldtputils
from time import sleep, time
from shutil import copytree, move
from os.path import expanduser

class EvolutionUseApp(Evolution):
    def open(self, profile_template='', credentials='',
             me_account=''):
        self.me_account = AccountInfo(me_account, credentials)

        self.backup_config()
        self.generate_profile(profile_template, self.me_account.template_args)

        Evolution.open(self, False, credentials)

class EvolutionUseTest(EvolutionTestSuite):
    APPLICATION_FACTORY = EvolutionUseApp
    def cleanup(self):
        return

    def testSendMessageToMyself(self, subject, body, password=''):

        email = self.application.me_account.template_args['emailaddress']
        password = self.application.me_account.template_args['password']

        self.application.compose_new_message(email, subject, body)
        self.application.send_email(subject)
        # Wait for the message to be sent
        # TODO: Change to look for the Outbox(1) label.
        ldtp.wait(10)

        # Get new messages
        self.application.send_and_receive(password)
        
        # Get the list of messages and check if it was correctly received
        messages_list = self.application.get_list_messages()

        found = False
        for msg in messages_list:
            if str(msg['subject']) == str(subject):
                found = True
                break

        if not found:
            raise AssertionError("The message was not correctly received.", 
                    ldtputils.imagecapture())



  
