#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "mdmysqlconfig.h"

mdmysqlconfig *get_mysql_config(char *configfile)
{
  FILE *fp;
  char *buf,*var,*val;
  mdmysqlconfig *cfg = NULL;

  buf = (char*)malloc(1025);
  var = (char*)malloc(1025);
  val = (char*)malloc(1025);

  fp = fopen(configfile,"r");
  if ( fp )
    {
      cfg = (mdmysqlconfig*)malloc(sizeof(mdmysqlconfig)+1);
      cfg->hostname = NULL;
      cfg->database = NULL;
      cfg->dbuser = NULL;
      cfg->dbpw = NULL;
      cfg->dbtable = NULL;

      cfg->uid_field = NULL;
      cfg->uidnumber_field = NULL;
      cfg->gidnumber_field = NULL;
      cfg->maildir_field = NULL;
      cfg->homedir_field = NULL;
      cfg->quota_field = NULL;
      cfg->mailstatus_field = NULL;
      cfg->where_clause = NULL;

      cfg->port = MYSQL_DEFAULT_PORT;
      cfg->socket = NULL;
      
      cfg->timeout = MYSQL_DEFAULT_TIMEOUT;

      while ( fgets(buf,1024,fp) )
      {
	sscanf(buf,"%s %s",var,val);

	if ( !strcasecmp(var,"hostname") )
	  cfg->hostname = (char*)strdup(val);
	if ( !strcasecmp(var,"port") )
	  cfg->port = atoi(val);
	if ( !strcasecmp(var,"socket") )
	  cfg->socket = (char*)strdup(val);
	if ( !strcasecmp(var,"database") )
	  cfg->database = (char*)strdup(val);
	if ( !strcasecmp(var,"dbuser") )
	  cfg->dbuser = (char*)strdup(val);
	if ( !strcasecmp(var,"dbpw") )
	  cfg->dbpw = (char*)strdup(val);
	if ( !strcasecmp(var,"dbtable") )
	  cfg->dbtable = (char*)strdup(val);

	if ( !strcasecmp(var,"uid_field") )
	  cfg->uid_field = (char*)strdup(val);
	if ( !strcasecmp(var,"uidnumber_field") )
	  cfg->uidnumber_field = (char*)strdup(val);
	if ( !strcasecmp(var,"gidnumber_field") )
	  cfg->gidnumber_field = (char*)strdup(val);
	if ( !strcasecmp(var,"maildir_field") )
	  cfg->maildir_field = (char*)strdup(val);
	if ( !strcasecmp(var,"homedirectory_field") )
	  cfg->homedir_field = (char*)strdup(val);
	if ( !strcasecmp(var,"quota_field") )
	  cfg->quota_field = (char*)strdup(val);
	if ( !strcasecmp(var,"mailstatus_field") )
	  cfg->mailstatus_field = (char*)strdup(val);
	if ( !strcasecmp(var,"where_clause") ) {
	  if ( !strncasecmp(val,"and", 3) ) {
	    val = buf+=3;
	    cfg->where_clause = (char*)strdup(val);
	  }
	}

	if ( !strcasecmp(var,"timeout") )
	  cfg->timeout = atoi(val);

	if ( !strcasecmp(var,"default_uidnumber") )
	  cfg->default_uidnumber = atoi(val);

	if ( !strcasecmp(var,"default_gidnumber") )
	  cfg->default_gidnumber = atoi(val);
      }

      fclose(fp);

      if ( !cfg->uid_field )
	cfg->uid_field = (char*)strdup(MYSQL_DEFAULT_UID_FIELD);
      if ( !cfg->uidnumber_field )
	cfg->uidnumber_field = (char*)strdup(MYSQL_DEFAULT_UIDNUMBER_FIELD);
      if ( !cfg->gidnumber_field )
	cfg->gidnumber_field = (char*)strdup(MYSQL_DEFAULT_GIDNUMBER_FIELD);
      if ( !cfg->maildir_field )
	cfg->maildir_field = (char*)strdup(MYSQL_DEFAULT_MAILDIR_FIELD);
      if ( !cfg->homedir_field )
	cfg->homedir_field = (char*)strdup(MYSQL_DEFAULT_HOMEDIRECTORY_FIELD);
      if ( !cfg->quota_field )
	cfg->quota_field = (char*)strdup(MYSQL_DEFAULT_QUOTA_FIELD);
      if ( !cfg->mailstatus_field )
	cfg->mailstatus_field = (char*)strdup(MYSQL_DEFAULT_STATUS_FIELD);
      if ( !cfg->where_clause )
	cfg->where_clause = (char*)strdup(MYSQL_DEFAULT_WHERE_CLAUSE);
    }

  free(buf);
  free(var);
  free(val);

  return cfg;
}

void free_mysql_config(mdmysqlconfig **cfg)
{
  if ( cfg[0]->hostname )
    free(cfg[0]->hostname);
  if ( cfg[0]->database )
    free(cfg[0]->database);
  if ( cfg[0]->dbuser )
    free(cfg[0]->dbuser);
  if ( cfg[0]->dbpw )
    free(cfg[0]->dbpw);
  if ( cfg[0]->dbtable )
    free(cfg[0]->dbtable);

  free(cfg[0]->uid_field);
  free(cfg[0]->uidnumber_field);
  free(cfg[0]->gidnumber_field);
  free(cfg[0]->maildir_field);
  free(cfg[0]->homedir_field);
  free(cfg[0]->quota_field);
  free(cfg[0]->mailstatus_field);
  free(cfg[0]->where_clause);

  free(*cfg);

  *cfg = NULL;
}
