#line 982 "../../src/builtin/snarf.m4"
/* -*- buffer-read-only: t -*- vi: set ro:
   THIS FILE IS GENERATED AUTOMATICALLY.  PLEASE DO NOT EDIT.
*/
#line 982
#ifdef HAVE_CONFIG_H
#line 982
# include <config.h>
#line 982
#endif
#line 982
#include <sys/types.h>
#line 982

#line 982
#include "mailfromd.h"
#line 982
#include "prog.h"
#line 982
#include "builtin.h"
#line 982

#line 179 "io.bi"
static mu_debug_handle_t debug_handle;
#line 982 "../../src/builtin/snarf.m4"

#line 1022 "../../src/builtin/snarf.m4"

/* End of snarf.m4 */
#line 1 "io.bi"
/* This file is part of Mailfromd.             -*- c -*-
   Copyright (C) 2006-2021 Sergey Poznyakoff

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>. */



#include <mflib/status.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include "global.h"
#include "msg.h"

static size_t nstreams = MAX_IOSTREAMS;

static struct mu_cfg_param io_cfg_param[] = {
	{ "max-streams", mu_c_size, &nstreams, 0, NULL,
	  N_("Maximum number of stream descriptors.") },
	{ NULL }
};

struct io_stream {
	char *name;
	int fd[2];
	pid_t pid;
	char *buf;
	size_t bufsize;
	int (*shutdown)(struct io_stream *, int what);
	void (*cleanup)(void*);
	void *cleanup_data;
	char *delim;
};

#define IFD(s) ((s).fd[0])
#define OFD(s) ((s).fd[1] == -1 ? (s).fd[0] : (s).fd[1])

static void
flush_stream(struct io_stream *str)
{
	/*FIXME*/
}

static void
close_stream(struct io_stream *str)
{
	if (OFD(*str) == -1)
		return;
	flush_stream(str);
	close(OFD(*str));
	if (IFD(*str) != -1)
		close(IFD(*str));
	if (str->pid) {
		int status;
		waitpid(str->pid, &status, 0);
	}
	str->fd[0] = -1;
	str->fd[1] = -1;
	str->pid = 0;
	if (str->cleanup)
		str->cleanup(str->cleanup_data);
	str->cleanup = NULL;
	str->cleanup_data = NULL;
	if (str->name) {
		free(str->name);
		str->name = NULL;
	}
	if (str->delim) {
		free(str->delim);
		str->delim = NULL;
	}
}

/* Read bytes from the stream STR into its buffer, until
   DELIM is encountered. Return number of bytes read. */
static int
read_stream_delim(struct io_stream *str, char *delim)
{
	int fd = IFD(*str);
	size_t i = 0;
	int rc;
	size_t delim_len = strlen(delim);
	
	for (;;) {
		if (str->bufsize == i) {
			if (str->bufsize == 0) 
				str->bufsize = 16;
			str->buf = mu_2nrealloc(str->buf, &str->bufsize,
					      sizeof str->buf[1]);
		}
		rc = read(fd, str->buf + i, 1);
		if (rc == -1)
			return -1;
		else if (rc == 0)
			return 0;
		i++;
		if (i >= delim_len &&
		    memcmp(str->buf + i - delim_len, delim, delim_len) == 0) {
			str->buf[i - delim_len] = 0;
			break;
		}
	}
	return i;
}

#define REDIRECT_STDIN_P(f) ((f) & (O_WRONLY|O_RDWR))
#define REDIRECT_STDOUT_P(f) (!((f) & O_WRONLY))

#define STDERR_SHUT        0
#define STDERR_NULL        1
#define STDERR_LOG         2
#define STDERR_FILE        3
#define STDERR_FILE_APPEND 4

#define LOG_TAG_PFX "mailfromd:"
#define LOG_TAG_PFX_LEN (sizeof(LOG_TAG_PFX)-1)

static void
stderr_to_log(char *arg, const char *cmd)
{
	int p[2];
	pid_t pid;
	
	if (pipe(p)) {
		mu_error(_("pipe failed: %s"), mu_strerror(errno));
		close(2);
		return;
	}

	pid = fork();

	if (pid == (pid_t) -1) {
		mu_error(_("fork failed: %s"), mu_strerror(errno));
		close(p[0]);
		close(p[1]);
		close(2);
		return;
	}
	
	/* Child */
	if (pid == 0) {
		FILE *fp;
		fd_set fdset;
		size_t len;
		char buf[1024];
		char *tag;
		int fac = mu_log_facility, pri = LOG_ERR;
		
		if (arg) {
			char *p = strchr(arg, '.');

			if (p)
				*p++ = 0;
			if (mu_string_to_syslog_facility(arg, &fac)) {
				mu_error(_("unknown syslog facility (%s), "
					   "redirecting stderr to %s"),
					 arg,
					 mu_syslog_facility_to_string(fac));
			}
			
			if (p && mu_string_to_syslog_priority(p, &pri)) {
				mu_error(_("unknown syslog priority (%s), "
					   "redirecting stderr to %s"),
					 arg,
					 mu_syslog_priority_to_string(pri));
			}
		}
		
#line 179 "io.bi"

#line 179
mu_debug(debug_handle, MU_DEBUG_TRACE2,("redirecting stderr to syslog %s.%s",
		           mu_syslog_facility_to_string(fac),
		           mu_syslog_priority_to_string(pri)));
#line 183
		
		len = strcspn(cmd, " \t");
		tag = malloc(LOG_TAG_PFX_LEN + len + 1);
		if (!tag)
			tag = (char*) cmd;
		else {
			strcpy(tag, LOG_TAG_PFX);
			memcpy(tag + LOG_TAG_PFX_LEN, cmd, len);
			tag[LOG_TAG_PFX_LEN + len] = 0;
		}
		mf_proctitle_format("%s redirector", cmd);

		FD_ZERO(&fdset);
		FD_SET(p[0], &fdset);
		logger_fdset(&fdset);
		close_fds_except(&fdset);

		fp = fdopen(p[0], "r");
		logger_open();
		while (fgets(buf, sizeof(buf), fp))
			syslog(pri, "%s", buf);
		exit(0);
	}

	/* Parent */
	close(p[0]);
	dup2(p[1], 2);
	close(p[1]);
}
	
static void
stderr_handler(int mode, char *arg, const char *cmd)
{
	int fd;
	int append = O_TRUNC;
	
	switch (mode) {
	case STDERR_SHUT:
		close(2);
		break;

	case STDERR_NULL:
		arg = "/dev/null";
	case STDERR_FILE_APPEND:
		append = O_APPEND;
	case STDERR_FILE:
		if (!arg || !*arg) {
			close(2);
			break;
		}
		
#line 233

#line 233
mu_debug(debug_handle, MU_DEBUG_TRACE2,("redirecting stderr to %s", arg));
		fd = open(arg, O_CREAT|O_WRONLY|append, 0644);
		if (fd < 0) {
			mu_error(_("cannot open file %s for appending: %s"),
				 arg, mu_strerror(errno));
			close(2);
			return;
		}
		if (fd != 2) {
			dup2(fd, 2);
			close(fd);
		}
		break;

	case STDERR_LOG:
		stderr_to_log(arg, cmd);
	}
}

static void
parse_stderr_redirect(const char **pcmd, int *perr, char **parg)
{
	int err;
	size_t len;
	char *arg;
	const char *cmdline = *pcmd;
	
	while (*cmdline && mu_isspace(*cmdline))
		cmdline++;
	if (strncmp(cmdline, "2>file:", 7) == 0) {
		cmdline += 7;
		err = STDERR_FILE;
	} else if (strncmp(cmdline, "2>>file:", 8) == 0) {
		cmdline += 8;
		err = STDERR_FILE_APPEND;
	} else if (strncmp(cmdline, "2>null:", 7) == 0) {
		cmdline += 7;
		err = STDERR_NULL;
	} else if (strncmp(cmdline, "2>syslog:", 9) == 0) {
		cmdline += 9;
		err = STDERR_LOG;
	} else
		return;

	len = strcspn(cmdline, " \t");
	if (len > 0 && cmdline[len-1] == 0)
		return;
	if (len == 0)
		arg = NULL;
	else {
		arg = malloc(len + 1);
		if (!arg)
			return;
		memcpy(arg, cmdline, len);
		arg[len] = 0;
	}

	*pcmd = cmdline + len;
	*perr = err;
	*parg = arg;
}


static int
open_program_stream_ioe(eval_environ_t env,
			struct io_stream *str, const char *cmdline,
			int flags,
			int ioe[2])
{
	int rightp[2], leftp[2];
	int rc = 0;
	pid_t pid;
	int err = STDERR_SHUT;
	char *arg = NULL;
	struct mu_wordsplit ws;
	
	parse_stderr_redirect(&cmdline, &err, &arg);
	while (*cmdline && (*cmdline == ' ' || *cmdline == '\t'))
		cmdline++;
	
	if (REDIRECT_STDIN_P(flags)) {
		if (pipe(leftp)) {
			mu_diag_funcall(MU_DIAG_ERROR, "pipe", "leftp",
					errno);
			free(arg);
			(
#line 318
	env_throw_bi(env, mfe_failure, NULL, "pipe failed")
#line 318
);
		}
	}
	
	if (REDIRECT_STDOUT_P(flags)) {
		if (pipe(rightp)) {
			mu_diag_funcall(MU_DIAG_ERROR, "pipe", "rightp",
					errno);
			free(arg);
			if (REDIRECT_STDIN_P(flags)) {
				close(leftp[0]);
				close(leftp[1]);
			}
		}
	}
	
	switch (pid = fork()) {
		/* The child branch.  */
	case 0:
		/* attach the pipes */

		/* Right-end */
		if (REDIRECT_STDOUT_P(flags)) {
			if (rightp[1] != 1)
				dup2(rightp[1], 1);
		} else if (ioe && ioe[1] != -1 && ioe[1] != 1) {
			dup2(ioe[1], 1);
		}

		/* Left-end */
		if (REDIRECT_STDIN_P(flags)) {
			if (leftp[0] != 0)
				dup2(leftp[0], 0);
		} else if (ioe && ioe[0] != -1 && ioe[0] != 0) {
			dup2(ioe[0], 0);
		}

		if (ioe && ioe[2] != -1 && ioe[2] != 2)
			dup2(ioe[2], 2);
		else
			stderr_handler(err, arg, cmdline);
		
		/* Close unneeded descriptors */
		close_fds_above(2);

		
#line 363

#line 363
mu_debug(debug_handle, MU_DEBUG_TRACE3,("running %s", cmdline));
		if (mu_wordsplit(cmdline, &ws,
				 MU_WRDSF_DEFFLAGS & ~MU_WRDSF_CESCAPES)) {
			mu_error(_("cannot parse command line %s: %s"),
				 cmdline, mu_wordsplit_strerror(&ws));
			exit(127);
		}
		execvp(ws.ws_wordv[0], ws.ws_wordv);
		mu_error(_("cannot run %s: %s"),
			 cmdline, mu_strerror(errno));
		exit(127);
		/********************/

		/* Parent branches: */
	case -1:
		/* Fork has failed */
		/* Restore things */
		rc = errno;
		if (REDIRECT_STDOUT_P(flags)) {
			close(rightp[0]);
			close(rightp[1]);
		}
		if (REDIRECT_STDIN_P(flags)) {
			close(leftp[0]);
			close(leftp[1]);
		}
		break;
		
	default:
		str->pid = pid;
		if (REDIRECT_STDOUT_P(flags)) {
			str->fd[0] = rightp[0];
			close(rightp[1]);
		} else
			str->fd[0] = -1;

		if (REDIRECT_STDIN_P(flags)) {
			str->fd[1] = leftp[1];
			close(leftp[0]);
		} else
			str->fd[1] = -1;
	}
	free(arg);
	return rc;
}

static int
open_program_stream(eval_environ_t env,
		    struct io_stream *str, const char *cmdline,
		    int flags)
{
	return open_program_stream_ioe(env, str, cmdline, flags, NULL);
}

static int
open_file_stream(eval_environ_t env,
		 struct io_stream *str, const char *file, int flags)
{
	str->fd[0] = open(file, flags, 0644); /* FIXME: mode? */
	if (str->fd[0] == -1)
		return errno;
	return 0;
}



static int
open_parsed_inet_stream(eval_environ_t env,
			struct io_stream *str,
			const char *cstr,
			char *proto, char *port, char *path,
			int flags)
{
	union {
		struct sockaddr sa;
		struct sockaddr_in s_in;
		struct sockaddr_un s_un;
#ifdef GACOPYZ_IPV6
		struct sockaddr_in6 s_in6;
#endif
	} addr;

	socklen_t socklen;
	int fd;
	int rc;

	if (!proto
	    || strcmp(proto, "unix") == 0 || strcmp(proto, "local") == 0) {
		struct stat st;
		
			if (!(port == NULL))
#line 453
		(
#line 453
	env_throw_bi(env, mfe_failure, NULL, _("invalid connection type: %s; "
			    "port is meaningless for UNIX sockets"),cstr)
#line 453
)
#line 457
;
		
			if (!(strlen(path) <= sizeof addr.s_un.sun_path))
#line 459
		(
#line 459
	env_throw_bi(env, mfe_range, NULL, _("%s: UNIX socket name too long"),path)
#line 459
)
#line 462
;
		
		addr.sa.sa_family = PF_UNIX;
		socklen = sizeof(addr.s_un);
		strcpy(addr.s_un.sun_path, path);
		
		if (stat(path, &st)) {
			(
#line 469
	env_throw_bi(env, mfe_failure, NULL, _("%s: cannot stat socket: %s"),path,strerror(errno))
#line 469
);
#line 472
		} else {
			/* FIXME: Check permissions? */
				if (!(S_ISSOCK(st.st_mode)))
#line 474
		(
#line 474
	env_throw_bi(env, mfe_failure, NULL, _("%s: not a socket"),path)
#line 474
)
#line 477
;
		}

	} else if (strcmp(proto, "inet") == 0) {
		short pnum;
		long num;
		char *p;
		
		addr.sa.sa_family = PF_INET;
		socklen = sizeof(addr.s_in);

			if (!(port != NULL))
#line 488
		(
#line 488
	env_throw_bi(env, mfe_failure, NULL, _("invalid connection type: %s; "
			    "missing port number"),cstr)
#line 488
)
#line 492
;

		num = pnum = strtol(port, &p, 0);
		if (*p == 0) {
				if (!(num == pnum))
#line 496
		(
#line 496
	env_throw_bi(env, mfe_range, NULL, _("invalid connection type: "
				    "%s; bad port number"),cstr)
#line 496
)
#line 500
;
			pnum = htons(pnum);
		} else {
			struct servent *sp = getservbyname(port, "tcp");

				if (!(sp != NULL))
#line 505
		(
#line 505
	env_throw_bi(env, mfe_failure, NULL, _("invalid connection type: "
				    "%s; unknown port name"),cstr)
#line 505
)
#line 509
;
			pnum = sp->s_port;
		}
		
		if (!path)
			addr.s_in.sin_addr.s_addr = INADDR_ANY;
		else {
			struct hostent *hp = gethostbyname(path);
				if (!(hp != NULL))
#line 517
		(
#line 517
	env_throw_bi(env, mfe_failure, NULL, _("unknown host name %s"),path)
#line 517
)
#line 520
;
			addr.sa.sa_family = hp->h_addrtype;
			switch (hp->h_addrtype) {
			case AF_INET:
				memmove(&addr.s_in.sin_addr, hp->h_addr, 4);
				addr.s_in.sin_port = pnum;
				break;

			default:
				(
#line 529
	env_throw_bi(env, mfe_range, NULL, _("invalid connection type: "
					   "%s; unsupported address family"),cstr)
#line 529
);
#line 533
			}
		}
#ifdef GACOPYZ_IPV6
	} else if (strcmp(proto, "inet6") == 0) {
		struct addrinfo hints;
		struct addrinfo *res;
		
			if (!(port != NULL))
#line 540
		(
#line 540
	env_throw_bi(env, mfe_failure, NULL, _("invalid connection type: %s; "
			    "missing port number"),cstr)
#line 540
)
#line 544
;

		memset(&hints, 0, sizeof(hints));
		hints.ai_family = AF_INET6;
		hints.ai_socktype = SOCK_STREAM;
		if (!path)
			hints.ai_flags |= AI_PASSIVE;
		
		rc = getaddrinfo(path, port, &hints, &res);
				
		switch (rc) {
		case 0:
			break;
			
		case EAI_SYSTEM:
			(
#line 559
	env_throw_bi(env, mfe_failure, NULL, _("%s:%s: cannot parse address: %s"),path,port,strerror(errno))
#line 559
);
#line 562
			
		case EAI_BADFLAGS:
		case EAI_SOCKTYPE:
			(
#line 565
	env_throw_bi(env, mfe_failure, NULL, _("%s:%d: internal error converting %s:%s"),__FILE__,__LINE__,path,port)
#line 565
);
#line 568
			
		case EAI_MEMORY:
			mu_alloc_die();
			
		default:
			(
#line 573
	env_throw_bi(env, mfe_failure, NULL, "%s:%s: %s",path,port,gai_strerror(rc))
#line 573
);
#line 576
		}

		socklen = res->ai_addrlen;
		if (socklen > sizeof(addr)) {
			freeaddrinfo(res);
			(
#line 581
	env_throw_bi(env, mfe_failure, NULL, _("%s:%s: address length too big (%lu)"),path,port,(unsigned long) socklen)
#line 581
);
#line 585
		}
		memcpy(&addr, res->ai_addr, res->ai_addrlen);
		freeaddrinfo(res);
#endif
	} else {
		(
#line 590
	env_throw_bi(env, mfe_range, NULL, _("unsupported protocol: %s"),proto)
#line 590
);
#line 593
	}

	fd = socket(addr.sa.sa_family, SOCK_STREAM, 0);
		if (!(fd != -1))
#line 596
		(
#line 596
	env_throw_bi(env, mfe_failure, NULL, _("unable to create new socket: %s"),strerror(errno))
#line 596
)
#line 599
;

	/* FIXME: Bind to the source ? */

	rc = connect(fd, &addr.sa, socklen);
	if (rc) {
		close(fd);
		(
#line 606
	env_throw_bi(env, mfe_failure, NULL, _("cannot connect to %s: %s"),cstr,strerror(errno))
#line 606
);
#line 609
	}
	
	str->fd[0] = fd;
	return 0;
}

static int
shutdown_inet_stream(struct io_stream *str, int how)
{
	switch (how) {
	case 0:
		how = SHUT_RD;
		break;

	case 1:
		how = SHUT_WR;
		break;

	case 2:
		how = SHUT_RDWR;
		break;

	default:
		return EINVAL;
	}
	if (shutdown(str->fd[0], how))
		return errno;
	return 0;
}

static int
open_inet_stream(eval_environ_t env,
		 struct io_stream *str, const char *addr, int flags)
{
	int rc;
	char *proto, *port, *path;

	if (gacopyz_parse_connection(addr, &proto, &port, &path)
	    != MI_SUCCESS) 
		rc = ENOMEM; /* FIXME: or EINVAL? */
	else {
		rc = open_parsed_inet_stream(env,
					     str, addr,
					     proto, port, path, flags);
		str->shutdown = shutdown_inet_stream;
		free(proto);
		free(port);
		free(path);
	}
	return rc;
}


static void *
alloc_streams()
{
	struct io_stream *p, *stab = mu_calloc(nstreams, sizeof *stab);
	for (p = stab; p < stab + nstreams; p++) 
		p->fd[0] = p->fd[1] = -1;
	return stab;
}

static void
destroy_streams(void *data)
{
	struct io_stream *stab = data;
	struct io_stream *p;
	for (p = stab; p < stab + nstreams; p++) {
		close_stream(p);
		free(p->buf);
	}
	free(stab);
}
		

#line 683

#line 683
static int IO_id;
#line 683 "io.bi"


int
_bi_io_fd(eval_environ_t env, int fd, int what)
{
	struct io_stream *iotab = env_get_builtin_priv(env,IO_id);
	int descr;

		if (!(fd >= 0 && fd < nstreams && what>=0 && what<=1))
#line 691
		(
#line 691
	env_throw_bi(env, mfe_range, NULL, _("invalid file descriptor"))
#line 691
)
#line 693
;
	descr = what == 0 ? IFD(iotab[fd]) : OFD(iotab[fd]);
		if (!(descr >= 0))
#line 695
		(
#line 695
	env_throw_bi(env, mfe_range, NULL, _("invalid file descriptor"))
#line 695
)
#line 697
;
	return descr;
}


void
#line 702
bi_open(eval_environ_t env)
#line 702

#line 702

#line 702 "io.bi"
{
#line 702
	
#line 702

#line 702

#line 702
char *  name;
#line 702
        
#line 702
get_string_arg(env, 0, &name);
#line 702
        
#line 702

#line 702
        adjust_stack(env, 1);
#line 702

#line 702

#line 702
	if (builtin_module_trace(BUILTIN_IDX_io))
#line 702
		prog_trace(env, "open %s",name);;
#line 702

{
	int i, rc;
	int flags = 0;
	int (*opf)(eval_environ_t env,
		   struct io_stream *, const char *, int) = open_file_stream;
	struct io_stream *iotab = env_get_builtin_priv(env,IO_id);
	
	for (i = 0; i < nstreams; i++) {
		if (iotab[i].fd[0] == -1) 
			break;
	}
		if (!(i < nstreams))
#line 714
		(
#line 714
	env_throw_bi(env, mfe_failure, "open", _("no more files available"))
#line 714
)
#line 716
;

	
#line 718

#line 718
mu_debug(debug_handle, MU_DEBUG_TRACE1,("opening stream %s", name));
	iotab[i].name = mu_strdup(name);
	iotab[i].delim = NULL;
	if (*name == '>') {
		flags |= O_RDWR|O_CREAT;
		name++;
		if (*name == '>') {
			flags |= O_APPEND;
			name++;
		} else
			flags |= O_TRUNC;
	} else if (*name == '|') {
		opf = open_program_stream;
		flags = O_WRONLY;
		name++;
		if (*name == '&') {
			flags = O_RDWR;
			name++;
		} else if (*name == '<') {
			flags = O_RDONLY;
			name++;
		}
	} else if (*name == '@') {
		name++;
		opf = open_inet_stream;
		flags = O_RDWR;
	} else
		flags = O_RDONLY;
	
	for (;*name && mu_isspace(*name); name++)
		;
	
	rc = opf(env, &iotab[i], name, flags);
	
		if (!(rc == 0))
#line 752
		(
#line 752
	env_throw_bi(env, mfe_failure, "open", _("cannot open stream %s: %s"),name,mu_strerror(rc))
#line 752
)
#line 755
;
	
#line 756

#line 756
mu_debug(debug_handle, MU_DEBUG_TRACE1,("open(%s) = %d", name, i));
	
#line 757
do {
#line 757
  push(env, (STKVAL)(mft_number)(i));
#line 757
  goto endlab;
#line 757
} while (0);
}
endlab:
#line 759
        env_function_cleanup_flush(env, NULL);
#line 759
	return;
#line 759
}

void
#line 761
bi_spawn(eval_environ_t env)
#line 761

#line 761

#line 761 "io.bi"
{
#line 761
	
#line 761

#line 761
long __bi_argcnt;
#line 761
char *  name;
#line 761
        long  fin;
#line 761
        long  fout;
#line 761
        long  ferr;
#line 761
        
#line 761
get_string_arg(env, 1, &name);
#line 761
        get_numeric_arg(env, 2, &fin);
#line 761
        get_numeric_arg(env, 3, &fout);
#line 761
        get_numeric_arg(env, 4, &ferr);
#line 761
        
#line 761
get_numeric_arg(env, 0, &__bi_argcnt);
#line 761
        adjust_stack(env, __bi_argcnt + 1);
#line 761

#line 761

#line 761
	if (builtin_module_trace(BUILTIN_IDX_io))
#line 761
		prog_trace(env, "spawn %s %lu %lu %lu",name, ((__bi_argcnt > 1) ? fin : 0), ((__bi_argcnt > 2) ? fout : 0), ((__bi_argcnt > 3) ? ferr : 0));;

{
	int i, rc;
	struct io_stream *iotab = env_get_builtin_priv(env,IO_id);
	int ioe[3];
	int flags;
	
	for (i = 0; i < nstreams; i++) {
		if (iotab[i].fd[0] == -1) 
			break;
	}
		if (!(i < nstreams))
#line 773
		(
#line 773
	env_throw_bi(env, mfe_failure, "spawn", _("no more files available"))
#line 773
)
#line 775
;

	
#line 777

#line 777
mu_debug(debug_handle, MU_DEBUG_TRACE1,("spawning %s", name));
	iotab[i].name = mu_strdup(name);
	iotab[i].delim = NULL;

	flags = O_WRONLY;
	if (*name == '|')
		name++;
	if (*name == '&') {
		flags = O_RDWR;
		name++;
	} else if (*name == '<') {
		flags = O_RDONLY;
		name++;
	}

	for (;*name && mu_isspace(*name); name++)
		;

	if ((__bi_argcnt > 1))
		ioe[0] = _bi_io_fd(env, ((__bi_argcnt > 1) ? fin : 0), 0);
	else
		ioe[0] = -1;
	if ((__bi_argcnt > 2))
		ioe[1] = _bi_io_fd(env, ((__bi_argcnt > 2) ? fout : 0), 1);
	else
		ioe[1] = -1;
	if ((__bi_argcnt > 3))
		ioe[2] = _bi_io_fd(env, ((__bi_argcnt > 2) ? fout : 0), 1);
	else
		ioe[2] = -1;
	
	rc = open_program_stream_ioe(env, &iotab[i], name, flags, ioe);
	
		if (!(rc == 0))
#line 810
		(
#line 810
	env_throw_bi(env, mfe_failure, "spawn", _("cannot open stream %s: %s"),name,mu_strerror(rc))
#line 810
)
#line 813
;
	
#line 814

#line 814
mu_debug(debug_handle, MU_DEBUG_TRACE1,("spawn(%s) = %d", name, i));
	
#line 815
do {
#line 815
  push(env, (STKVAL)(mft_number)(i));
#line 815
  goto endlab;
#line 815
} while (0);
	
}
endlab:
#line 818
        env_function_cleanup_flush(env, NULL);
#line 818
	return;
#line 818
}


void
#line 821
bi_tempfile(eval_environ_t env)
#line 821

#line 821

#line 821 "io.bi"
{
#line 821
	
#line 821

#line 821
long __bi_argcnt;
#line 821
char * MFL_DATASEG tempdir;
#line 821
        
#line 821
get_string_arg(env, 1, &tempdir);
#line 821
        
#line 821
get_numeric_arg(env, 0, &__bi_argcnt);
#line 821
        adjust_stack(env, __bi_argcnt + 1);
#line 821

#line 821

#line 821
	if (builtin_module_trace(BUILTIN_IDX_io))
#line 821
		prog_trace(env, "tempfile %s",((__bi_argcnt > 0) ? tempdir : ""));;
#line 821

{
	struct io_stream *iotab = env_get_builtin_priv(env,IO_id);
	int i;
	char *dir = ((__bi_argcnt > 0) ? tempdir : "/tmp");
	size_t dirlen = strlen(dir);
	mode_t u;
	int fd;
	char *template;
#define PATTERN "mfdXXXXXX"

	for (i = 0; i < nstreams; i++) {
		if (iotab[i].fd[0] == -1) 
			break;
	}
		if (!(i < nstreams))
#line 836
		(
#line 836
	env_throw_bi(env, mfe_failure, "tempfile", _("no more files available"))
#line 836
)
#line 838
;


	while (dirlen > 0 && dir[dirlen-1] == '/')
		dirlen--;

	template = mf_c_val(heap_tempspace(env, (dirlen ? dirlen + 1 : 0) +
#line 844
				      sizeof(PATTERN)), ptr);
#line 846
	if (dirlen) {
		memcpy(template, dir, dirlen);
		template[dirlen++] = '/';
	}
	strcpy(template + dirlen, PATTERN);
	u = umask(077);
	fd = mkstemp(template);
	umask(u);
		if (!(fd >= 0))
#line 854
		(
#line 854
	env_throw_bi(env, mfe_failure, "tempfile", "mkstemp failed: %s",mu_strerror(errno))
#line 854
)
#line 857
;
	unlink(template);

	iotab[i].fd[0] = fd;
	
	
#line 862
do {
#line 862
  push(env, (STKVAL)(mft_number)(i));
#line 862
  goto endlab;
#line 862
} while (0);
#undef PATTERN
}
endlab:
#line 865
        env_function_cleanup_flush(env, NULL);
#line 865
	return;
#line 865
}

void
#line 867
bi_close(eval_environ_t env)
#line 867

#line 867

#line 867 "io.bi"
{
#line 867
	
#line 867

#line 867

#line 867
long  fd;
#line 867
        
#line 867
get_numeric_arg(env, 0, &fd);
#line 867
        
#line 867

#line 867
        adjust_stack(env, 1);
#line 867

#line 867

#line 867
	if (builtin_module_trace(BUILTIN_IDX_io))
#line 867
		prog_trace(env, "close %lu",fd);;
#line 867

{
	struct io_stream *iotab = env_get_builtin_priv(env,IO_id);

		if (!(fd >= 0 && fd < nstreams))
#line 871
		(
#line 871
	env_throw_bi(env, mfe_range, "close", _("invalid file descriptor"))
#line 871
)
#line 873
;
	close_stream(&iotab[fd]);
}

#line 876
        env_function_cleanup_flush(env, NULL);
#line 876
	return;
#line 876
}	

static struct builtin_const_trans shutdown_modes[] = {
	{ _MFL_SHUT_RD, SHUT_RD },
	{ _MFL_SHUT_WR, SHUT_WR },
	{ _MFL_SHUT_RDWR, SHUT_RDWR }
};

void
#line 884
bi_shutdown(eval_environ_t env)
#line 884

#line 884

#line 884 "io.bi"
{
#line 884
	
#line 884

#line 884

#line 884
long  fd;
#line 884
        long  how;
#line 884
        
#line 884
get_numeric_arg(env, 0, &fd);
#line 884
        get_numeric_arg(env, 1, &how);
#line 884
        
#line 884

#line 884
        adjust_stack(env, 2);
#line 884

#line 884

#line 884
	if (builtin_module_trace(BUILTIN_IDX_io))
#line 884
		prog_trace(env, "shutdown %lu %lu",fd, how);;
#line 884

{
	struct io_stream *iotab = env_get_builtin_priv(env,IO_id);
	struct io_stream *ioptr;
	int mode;
	
		if (!(fd >= 0 && fd < nstreams))
#line 890
		(
#line 890
	env_throw_bi(env, mfe_range, "shutdown", _("invalid file descriptor"))
#line 890
)
#line 892
;
		if (!(how >= 0 && how <= 2))
#line 893
		(
#line 893
	env_throw_bi(env, mfe_range, "shutdown", _("invalid file descriptor"))
#line 893
)
#line 895
;
		if (!(_builtin_const_to_c(shutdown_modes,
#line 896
				      MU_ARRAY_SIZE(shutdown_modes),
#line 896
				      how,
#line 896
				      &mode) == 0))
#line 896
		(
#line 896
	env_throw_bi(env, mfe_failure, "shutdown", "bad shutdown mode")
#line 896
)
#line 901
;
	
	ioptr = &iotab[fd];
	if (ioptr->shutdown) {
		int rc = ioptr->shutdown(ioptr, mode);
			if (!(rc == 0))
#line 906
		(
#line 906
	env_throw_bi(env, mfe_io, "shutdown", "shutdown failed: %s",mu_strerror(rc))
#line 906
)
#line 909
;
	} else if (how == 2)
		close_stream(ioptr);
	else if (ioptr->fd[how]) {
		close(ioptr->fd[how]);
		ioptr->fd[how] = -1;
	}
}

#line 917
        env_function_cleanup_flush(env, NULL);
#line 917
	return;
#line 917
}

void
#line 919
bi_write(eval_environ_t env)
#line 919

#line 919

#line 919 "io.bi"
{
#line 919
	
#line 919

#line 919
long __bi_argcnt;
#line 919
long  fd;
#line 919
        char *  str;
#line 919
        long  n;
#line 919
        
#line 919
get_numeric_arg(env, 1, &fd);
#line 919
        get_string_arg(env, 2, &str);
#line 919
        get_numeric_arg(env, 3, &n);
#line 919
        
#line 919
get_numeric_arg(env, 0, &__bi_argcnt);
#line 919
        adjust_stack(env, __bi_argcnt + 1);
#line 919

#line 919

#line 919
	if (builtin_module_trace(BUILTIN_IDX_io))
#line 919
		prog_trace(env, "write %lu %s %lu",fd, str, ((__bi_argcnt > 2) ? n : 0));;
#line 919

{
	struct io_stream *iotab = env_get_builtin_priv(env,IO_id);
	int rc;
	
	
#line 924

#line 924
mu_debug(debug_handle, MU_DEBUG_TRACE1,("writing %s to %lu", str, fd));
		if (!(fd >= 0 && fd < nstreams && OFD(iotab[fd]) != -1))
#line 925
		(
#line 925
	env_throw_bi(env, mfe_range, "write", _("invalid file descriptor"))
#line 925
)
#line 927
;
	if (!(__bi_argcnt > 2))
		n = strlen (str);
	rc = write(OFD(iotab[fd]), str, n);
		if (!(n == rc))
#line 931
		(
#line 931
	env_throw_bi(env, mfe_io, "write", _("write error on %s: %s"),iotab[fd].name,mu_strerror(errno))
#line 931
)
#line 934
;
}

#line 936
        env_function_cleanup_flush(env, NULL);
#line 936
	return;
#line 936
}


void
#line 939
bi_write_body(eval_environ_t env)
#line 939

#line 939

#line 939 "io.bi"
{
#line 939
	
#line 939

#line 939

#line 939
long  fd;
#line 939
        void *  str;
#line 939
        long  n;
#line 939
        
#line 939
get_numeric_arg(env, 0, &fd);
#line 939
        get_pointer_arg(env, 1, &str);
#line 939
        get_numeric_arg(env, 2, &n);
#line 939
        
#line 939

#line 939
        adjust_stack(env, 3);
#line 939

#line 939

#line 939
	if (builtin_module_trace(BUILTIN_IDX_io))
#line 939
		prog_trace(env, "write_body %lu %p %lu",fd, str, n);;
#line 939

{
	struct io_stream *iotab = env_get_builtin_priv(env,IO_id);
	int rc;

		if (!(fd >= 0 && fd < nstreams && OFD(iotab[fd]) != -1))
#line 944
		(
#line 944
	env_throw_bi(env, mfe_range, "write_body", _("invalid file descriptor"))
#line 944
)
#line 946
;
	rc = write(OFD(iotab[fd]), str, n);
		if (!(n == rc))
#line 948
		(
#line 948
	env_throw_bi(env, mfe_io, "write_body", _("write error on %s: %s"),iotab[fd].name,mu_strerror(errno))
#line 948
)
#line 951
;
}

#line 953
        env_function_cleanup_flush(env, NULL);
#line 953
	return;
#line 953
}

void
#line 955
bi_read(eval_environ_t env)
#line 955

#line 955

#line 955 "io.bi"
{
#line 955
	
#line 955

#line 955

#line 955
long  fd;
#line 955
        long  size;
#line 955
        
#line 955
get_numeric_arg(env, 0, &fd);
#line 955
        get_numeric_arg(env, 1, &size);
#line 955
        
#line 955

#line 955
        adjust_stack(env, 2);
#line 955

#line 955

#line 955
	if (builtin_module_trace(BUILTIN_IDX_io))
#line 955
		prog_trace(env, "read %lu %lu",fd, size);;
#line 955

{
	struct io_stream *iotab = env_get_builtin_priv(env,IO_id);
	int rc;
	size_t off;
	char *s = (char*) env_data_ref(env, (off = heap_reserve(env, size + 1)));

		if (!(fd >= 0 && fd < nstreams && IFD(iotab[fd]) != -1))
#line 962
		(
#line 962
	env_throw_bi(env, mfe_range, "read", _("invalid file descriptor"))
#line 962
)
#line 964
;
	
	rc = read(IFD(iotab[fd]), s, size);
	if (rc == 0)
		(
#line 968
	env_throw_bi(env, mfe_eof, "read", _("EOF on %s"),iotab[fd].name)
#line 968
);
#line 970
		if (!(rc == size))
#line 970
		(
#line 970
	env_throw_bi(env, mfe_io, "read", _("read error on %s: %s"),iotab[fd].name,mu_strerror(errno))
#line 970
)
#line 973
;
	s[size] = 0;
	
#line 975
do {
#line 975
  push(env, (STKVAL) (mft_size) (off));
#line 975
  goto endlab;
#line 975
} while (0);
}	
endlab:
#line 977
        env_function_cleanup_flush(env, NULL);
#line 977
	return;
#line 977
}

void
#line 979
bi_rewind(eval_environ_t env)
#line 979

#line 979

#line 979 "io.bi"
{
#line 979
	
#line 979

#line 979

#line 979
long  fd;
#line 979
        
#line 979
get_numeric_arg(env, 0, &fd);
#line 979
        
#line 979

#line 979
        adjust_stack(env, 1);
#line 979

#line 979

#line 979
	if (builtin_module_trace(BUILTIN_IDX_io))
#line 979
		prog_trace(env, "rewind %lu",fd);;
#line 979

{
	struct io_stream *iotab = env_get_builtin_priv(env,IO_id);

		if (!(fd >= 0 && fd < nstreams && IFD(iotab[fd]) != -1))
#line 983
		(
#line 983
	env_throw_bi(env, mfe_range, "rewind", _("invalid file descriptor"))
#line 983
)
#line 985
;
	if (lseek(IFD(iotab[fd]), 0, SEEK_SET) == -1)
		(
#line 987
	env_throw_bi(env, mfe_io, "rewind", "seek failed: %s",mu_strerror(errno))
#line 987
);
#line 990
}

#line 991
        env_function_cleanup_flush(env, NULL);
#line 991
	return;
#line 991
}
	

#define MINBUFSIZE 128
#define MAXBUFSIZE 65535

void
#line 997
bi_copy(eval_environ_t env)
#line 997

#line 997

#line 997 "io.bi"
{
#line 997
	
#line 997

#line 997

#line 997
long  dst;
#line 997
        long  src;
#line 997
        
#line 997
get_numeric_arg(env, 0, &dst);
#line 997
        get_numeric_arg(env, 1, &src);
#line 997
        
#line 997

#line 997
        adjust_stack(env, 2);
#line 997

#line 997

#line 997
	if (builtin_module_trace(BUILTIN_IDX_io))
#line 997
		prog_trace(env, "copy %lu %lu",dst, src);;
#line 997

{
	struct io_stream *iotab = env_get_builtin_priv(env,IO_id);
	int ifd, ofd;
	char *buffer;
	size_t bufsize = MAXBUFSIZE;
	char bs[MINBUFSIZE];
	off_t cur, end;
	size_t total = 0;
	ssize_t rdbytes;
	
		if (!(src >= 0 && src < nstreams && (ifd = IFD(iotab[src])) != -1))
#line 1008
		(
#line 1008
	env_throw_bi(env, mfe_range, "copy", _("invalid source file descriptor"))
#line 1008
)
#line 1010
;
		if (!(dst >= 0 && dst < nstreams && (ofd = OFD(iotab[dst])) != -1))
#line 1011
		(
#line 1011
	env_throw_bi(env, mfe_range, "copy", _("invalid destination file descriptor"))
#line 1011
)
#line 1013
;

	cur = lseek (ifd, 0, SEEK_CUR);
	if (cur != -1) {
		end = lseek (ifd, 0, SEEK_END);
		if (end != -1) {
			if (end < MAXBUFSIZE)
				bufsize = end;
			lseek (ifd, cur, SEEK_SET);
		}
	}

	for (; (buffer = malloc (bufsize)) == NULL; bufsize >>= 1)
		if (bufsize < MINBUFSIZE) {
			buffer = bs;
			bufsize = MINBUFSIZE;
			break;
		}

	while ((rdbytes = read(ifd, buffer, bufsize)) > 0) {
		char *p = buffer;
		while (rdbytes) {
			ssize_t wrbytes = write(ofd, p, rdbytes);
			if (wrbytes == -1) {
				if (buffer != bs)
					free(buffer);
				(
#line 1039
	env_throw_bi(env, mfe_io, "copy", "write error: %s",mu_strerror(errno))
#line 1039
);
#line 1042
			} else if (wrbytes == 0) {
				if (buffer != bs)
					free(buffer);
				(
#line 1045
	env_throw_bi(env, mfe_io, "copy", "short write")
#line 1045
);
#line 1047
			}
			p += wrbytes;
			rdbytes -= wrbytes;
			total += wrbytes;
		}
	}
	if (buffer != bs)
		free(buffer);
	
#line 1055
do {
#line 1055
  push(env, (STKVAL)(mft_number)(total));
#line 1055
  goto endlab;
#line 1055
} while (0);
}
endlab:
#line 1057
        env_function_cleanup_flush(env, NULL);
#line 1057
	return;
#line 1057
}

void
#line 1059
bi_getdelim(eval_environ_t env)
#line 1059

#line 1059

#line 1059 "io.bi"
{
#line 1059
	
#line 1059

#line 1059

#line 1059
long  fd;
#line 1059
        char * MFL_DATASEG delim;
#line 1059
        
#line 1059
get_numeric_arg(env, 0, &fd);
#line 1059
        get_string_arg(env, 1, &delim);
#line 1059
        
#line 1059

#line 1059
        adjust_stack(env, 2);
#line 1059

#line 1059

#line 1059
	if (builtin_module_trace(BUILTIN_IDX_io))
#line 1059
		prog_trace(env, "getdelim %lu %s",fd, delim);;
#line 1059

{
	struct io_stream *iotab = env_get_builtin_priv(env,IO_id);
	struct io_stream *ioptr;
	int rc;
	
		if (!(fd >= 0 && fd < nstreams && IFD(iotab[fd]) != -1))
#line 1065
		(
#line 1065
	env_throw_bi(env, mfe_range, "getdelim", _("invalid file descriptor"))
#line 1065
)
#line 1067
;
	ioptr = &iotab[fd];
	rc = read_stream_delim(ioptr, delim); 
	if (rc == 0)
		(
#line 1071
	env_throw_bi(env, mfe_eof, "getdelim", _("EOF on %s"),ioptr->name)
#line 1071
);
		if (!(rc > 0))
#line 1072
		(
#line 1072
	env_throw_bi(env, mfe_io, "getdelim", _("read error on %s: %s"),ioptr->name,mu_strerror(errno))
#line 1072
)
#line 1075
;
	
#line 1076
do {
#line 1076
  pushs(env, ioptr->buf);
#line 1076
  goto endlab;
#line 1076
} while (0);
}	
endlab:
#line 1078
        env_function_cleanup_flush(env, NULL);
#line 1078
	return;
#line 1078
}

void
#line 1080
bi_getline(eval_environ_t env)
#line 1080

#line 1080

#line 1080 "io.bi"
{
#line 1080
	
#line 1080

#line 1080

#line 1080
long  fd;
#line 1080
        
#line 1080
get_numeric_arg(env, 0, &fd);
#line 1080
        
#line 1080

#line 1080
        adjust_stack(env, 1);
#line 1080

#line 1080

#line 1080
	if (builtin_module_trace(BUILTIN_IDX_io))
#line 1080
		prog_trace(env, "getline %lu",fd);;
#line 1080

{
	struct io_stream *iotab = env_get_builtin_priv(env,IO_id);
	struct io_stream *ioptr;
	int rc;

		if (!(fd >= 0 && fd < nstreams && IFD(iotab[fd]) != -1))
#line 1086
		(
#line 1086
	env_throw_bi(env, mfe_range, "getline", _("invalid file descriptor"))
#line 1086
)
#line 1088
;
	ioptr = &iotab[fd];
	rc = read_stream_delim(ioptr, ioptr->delim ? ioptr->delim : "\n");
	if (rc == 0)
		(
#line 1092
	env_throw_bi(env, mfe_eof, "getline", _("EOF on %s"),ioptr->name)
#line 1092
);
#line 1094
		if (!(rc > 0))
#line 1094
		(
#line 1094
	env_throw_bi(env, mfe_io, "getline", _("read error on %s: %s"),ioptr->name,mu_strerror(errno))
#line 1094
)
#line 1097
;
	
#line 1098
do {
#line 1098
  pushs(env, ioptr->buf);
#line 1098
  goto endlab;
#line 1098
} while (0);
}	
endlab:
#line 1100
        env_function_cleanup_flush(env, NULL);
#line 1100
	return;
#line 1100
}

void
#line 1102
bi_fd_set_delimiter(eval_environ_t env)
#line 1102

#line 1102

#line 1102 "io.bi"
{
#line 1102
	
#line 1102

#line 1102

#line 1102
long  fd;
#line 1102
        char *  delim;
#line 1102
        
#line 1102
get_numeric_arg(env, 0, &fd);
#line 1102
        get_string_arg(env, 1, &delim);
#line 1102
        
#line 1102

#line 1102
        adjust_stack(env, 2);
#line 1102

#line 1102

#line 1102
	if (builtin_module_trace(BUILTIN_IDX_io))
#line 1102
		prog_trace(env, "fd_set_delimiter %lu %s",fd, delim);;
#line 1102

{
	struct io_stream *iotab = env_get_builtin_priv(env,IO_id);
	struct io_stream *ioptr;

		if (!(fd >= 0 && fd < nstreams && IFD(iotab[fd]) != -1))
#line 1107
		(
#line 1107
	env_throw_bi(env, mfe_range, "fd_set_delimiter", _("invalid file descriptor"))
#line 1107
)
#line 1109
;
	ioptr = &iotab[fd];
	free(ioptr->delim);
	ioptr->delim = mu_strdup(delim);
}

#line 1114
        env_function_cleanup_flush(env, NULL);
#line 1114
	return;
#line 1114
}

void
#line 1116
bi_fd_delimiter(eval_environ_t env)
#line 1116

#line 1116

#line 1116 "io.bi"
{
#line 1116
	
#line 1116

#line 1116

#line 1116
long  fd;
#line 1116
        char * MFL_DATASEG delim;
#line 1116
        
#line 1116
get_numeric_arg(env, 0, &fd);
#line 1116
        get_string_arg(env, 1, &delim);
#line 1116
        
#line 1116

#line 1116
        adjust_stack(env, 2);
#line 1116

#line 1116

#line 1116
	if (builtin_module_trace(BUILTIN_IDX_io))
#line 1116
		prog_trace(env, "fd_delimiter %lu %s",fd, delim);;
#line 1116

{
	struct io_stream *iotab = env_get_builtin_priv(env,IO_id);
	struct io_stream *ioptr;

		if (!(fd >= 0 && fd < nstreams && IFD(iotab[fd]) != -1))
#line 1121
		(
#line 1121
	env_throw_bi(env, mfe_range, "fd_delimiter", _("invalid file descriptor"))
#line 1121
)
#line 1123
;
	ioptr = &iotab[fd];
	
#line 1125
do {
#line 1125
  pushs(env, ioptr->delim ? ioptr->delim : "\n");
#line 1125
  goto endlab;
#line 1125
} while (0);
}
endlab:
#line 1127
        env_function_cleanup_flush(env, NULL);
#line 1127
	return;
#line 1127
}

 
#line 982 "../../src/builtin/snarf.m4"

#line 982

#line 982

#line 982
void
#line 982
io_init_builtin(void)
#line 982
{
#line 982
		debug_handle = mu_debug_register_category("bi_io");
#line 982

#line 982
	#line 683 "io.bi"
IO_id = builtin_priv_register(alloc_streams, destroy_streams,
#line 683
NULL);
#line 702 "io.bi"
va_builtin_install_ex("open", bi_open, 0, dtype_number, 1, 0, 0|0, dtype_string);
#line 761 "io.bi"
va_builtin_install_ex("spawn", bi_spawn, 0, dtype_number, 4, 3, 0|0, dtype_string, dtype_number, dtype_number, dtype_number);
#line 821 "io.bi"
va_builtin_install_ex("tempfile", bi_tempfile, 0, dtype_number, 1, 1, 0|0, dtype_string);
#line 867 "io.bi"
va_builtin_install_ex("close", bi_close, 0, dtype_unspecified, 1, 0, 0|0, dtype_number);
#line 884 "io.bi"
va_builtin_install_ex("shutdown", bi_shutdown, 0, dtype_unspecified, 2, 0, 0|0, dtype_number, dtype_number);
#line 919 "io.bi"
va_builtin_install_ex("write", bi_write, 0, dtype_unspecified, 3, 1, 0|0, dtype_number, dtype_string, dtype_number);
#line 939 "io.bi"
va_builtin_install_ex("write_body", bi_write_body, STATMASK(smtp_state_body), dtype_unspecified, 3, 0, 0|0, dtype_number, dtype_pointer, dtype_number);
#line 955 "io.bi"
va_builtin_install_ex("read", bi_read, 0, dtype_string, 2, 0, 0|0, dtype_number, dtype_number);
#line 979 "io.bi"
va_builtin_install_ex("rewind", bi_rewind, 0, dtype_unspecified, 1, 0, 0|0, dtype_number);
#line 997 "io.bi"
va_builtin_install_ex("copy", bi_copy, 0, dtype_number, 2, 0, 0|0, dtype_number, dtype_number);
#line 1059 "io.bi"
va_builtin_install_ex("getdelim", bi_getdelim, 0, dtype_string, 2, 0, 0|0, dtype_number, dtype_string);
#line 1080 "io.bi"
va_builtin_install_ex("getline", bi_getline, 0, dtype_string, 1, 0, 0|0, dtype_number);
#line 1102 "io.bi"
va_builtin_install_ex("fd_set_delimiter", bi_fd_set_delimiter, 0, dtype_unspecified, 2, 0, 0|0, dtype_number, dtype_string);
#line 1116 "io.bi"
va_builtin_install_ex("fd_delimiter", bi_fd_delimiter, 0, dtype_string, 2, 0, 0|0, dtype_number, dtype_string);

#line 982 "../../src/builtin/snarf.m4"
	
#line 982
	 mf_add_runtime_params(io_cfg_param);
#line 982
	 
#line 982
}
#line 982 "../../src/builtin/snarf.m4"

