#!/usr/bin/perl

# Copyright (c) Kim Holviala <kimmy@iki.fi> 1997-2000

require 5.002;
use Socket;


# Networking (& related) functions ==========================================

# Get data through HTTP -----------------------------------------------------

sub HTTPGet {

	my ($url, $postdata) = @_;
	my ($data, $header);

# Outside connections allowed?
	return 0 unless $CONFIG{'OutsideConnections'};

# Separate host & the filename
	$url =~ s/http:\/\///;
	($host, $url) = split(/\//, $url, 2);

# Connect
	&ConnectSocket($host, 80) or return 0;

# Handle GET/POST request
	if ($postdata) {
		print S "POST /$url HTTP/1.0${crlf}Content-Length: ", length($postdata), "$crlf$crlf$postdata";
	}
	else {
		print S "GET /$url HTTP/1.0$crlf$crlf";
	}

# Get the header
	for (;;) {
		$_ = <S> or return 0;
		tr/\x0D\x0A//d;
		/^\s*$/ and last;

		$header .= "$_\n";
	}

# Check the response
	if ($header =~ /^HTTP\/.* 200 OK/) {

# OK -> Get data
		while (<S>) { $data .= $_; }

		&DisconnectSocket;
		return $data;
	}

# Not OK -> Error
	else {
		&DisconnectSocket;
		return 0;
	}
}


# Login ---------------------------------------------------------------------

sub login {

# Remote login?
	if ($FORM{'remote'}) {
		$FORM{'password'} = &loadFile($CONFIG{'TempPath'}.$FORM{'remote'});
		unlink $CONFIG{'TempPath'}.$FORM{'remote'};
	}

# Check input
	if (!$CONFIG{'Server'} and $CONFIG{'Login'} =~ /\@/) {
		$CONFIG{'Server'} = $CONFIG{'Login'};
	}

	$CONFIG{'Login'} =~ s/\s//g;
#	$CONFIG{'Login'} =~ s/\@.*$//;

	$CONFIG{'Server'} =~ s/\s//g;
#	$CONFIG{'Server'} =~ s/^.*\@//;

	if (!$CONFIG{'Login'} or !$CONFIG{'Server'} or !$FORM{'password'}) {
		&loginForm;
		exit;
	}

# Get remote host name
	$CONFIG{'RemoteHost'} = $ENV{'REMOTE_HOST'};

	if ($CONFIG{'RemoteHost'} !~ /[a-zA-Z]/) {
		$CONFIG{'RemoteHost'} = scalar gethostbyaddr inet_aton($ENV{'REMOTE_ADDR'}), AF_INET;
	}

	if ($CONFIG{'RemoteHost'} !~ /[a-zA-Z]/) {
		$CONFIG{'RemoteHost'} = $ENV{'REMOTE_ADDR'};
	}

# Check access restrictions
	$allowed = 0;

	for (split(/\s*,\s*/, $CONFIG{'AllowedHosts'})) {
		s/\W/\\$&/g;

		if (/[a-zA-Z]/) {
			$CONFIG{'RemoteHost'} =~ /$_$/i and $allowed = 1;
		}
		else {
			$ENV{'REMOTE_ADDR'} =~ /^$_/i and $allowed = 1;
		}
	}

	for (split(/\s*,\s*/, $CONFIG{'AllowedMailservers'})) {
		s/\W/\\$&/g;
		$CONFIG{'Server'} =~ /$_$/i and $allowed = 1;
	}

	if (!$allowed and ($CONFIG{'AllowedHosts'} or $CONFIG{'AllowedMailservers'})) {

		$file = &HTTPGet($CONFIG{'PublicMailreaderURL'}, "do=savepwd\&password=$FORM{'password'}");
		&redirect("$CONFIG{'PublicMailreaderURL'}?do=login\&remote=$file\&configServer=$FORM{'configServer'}\&configLogin=$FORM{'configLogin'}\&configJavaScript=$FORM{'configJavaScript'}\&configLanguage=$FORM{'configLanguage'}");

		exit;
	}
	
# Cache password
	$FORM{'p'} = &getRandomFilename;
	$FORM{'u'} = &getRandomFilename;

	$CONFIG{'LinkQueryString'} = "p=$FORM{'p'}&u=$FORM{'u'}&r=" . int(rand 100000000);

	$FORM{'password'} =~ tr/A-Za-z0-9/0-4A-Za-z5-9/;

	open(FILE, ">$CONFIG{'TempPath'}$FORM{'p'}");
	print FILE $FORM{'password'};
	close(FILE);

# Check browser's capabilities
	$_ = $ENV{'HTTP_USER_AGENT'};

	if (/Mozilla\/(\d+)/ and $1 >= 4) { $CONFIG{'FileUpload'} = 1; }
	elsif (/Mozilla\/(\d+)/ and $1 >= 2 and !/compatible/i) { $CONFIG{'FileUpload'} = 1; }

	if ($ENV{'HTTP_USER_AGENT'} =~ /^Mozilla\/4/) {
		$CONFIG{'StyleSheets'} = 1;

		if ($ENV{'HTTP_USER_AGENT'} !~ /compatible/i) { $CONFIG{'AllowHTMLColors'} = 1; }
	}

# Create a filename for user's configuration
	$CONFIG{'Userfile'} = "$CONFIG{'Login'}\@$CONFIG{'Server'}";
	$CONFIG{'Userfile'} =~ s/[^a-zA-Z0-9\.\-]/"_" . unpack("H2", $&)/ge;
	$CONFIG{'Userfile'} =~ tr/A-Z/a-z/;

# Handle cache hashing
	if ($CONFIG{'CacheHashDepth'} > 0) {
		$_ = "$CONFIG{'Login'}\@$CONFIG{'Server'}";

		tr/1-9/0/;
		tr/A-Z/a-z/;
		tr/a-z0//cd;

		$_ = substr($_, 0, $CONFIG{'CacheHashDepth'});
		mkdir $CONFIG{'CachePath'}.$_, 0777;

		$CONFIG{'Userfile'} = "$_/$CONFIG{'Userfile'}";
	}

# Load configuration
	if (!$CONFIG{'DiscardOldConfig'}) {
		&loadConfig("$CONFIG{'CachePath'}$CONFIG{'Userfile'}");
		&loadConfig("$CONFIG{'CachePath'}$CONFIG{'Userfile'}_backup") if (!$CONFIG{'RealName'} or !$CONFIG{'RealEmail'});

		&loadConfig("$CONFIG{'Language'}.cfg");

		&loadConfig("$CONFIG{'CachePath'}$CONFIG{'Userfile'}");
		&loadConfig("~$CONFIG{'CachePath'}$CONFIG{'Userfile'}_backup") if (!$CONFIG{'RealName'} or !$CONFIG{'RealEmail'});
	}

# Connect
	&ConnectPOP3;

	eval $timeoutOn;
	print S "STAT$crlf";
	$_ = <S>;
	eval $timeoutOff;

	tr/\x0d\x0a//d;

	($msg, $CONFIG{'Messages'}, $CONFIG{'MailboxSize'}) = split(/ /);

# Save log entry
	&saveLog;

# Set configuration variables
	$CONFIG{'RemoteAddr'} = $ENV{'REMOTE_ADDR'};
	$CONFIG{'RemoteAddr'} =~ s/\d+$//;

	$CONFIG{'LoginCount'}++;
	$CONFIG{'LastLoginTime'} = time;
	$CONFIG{'LastMailCheck'} = time;

	$CONFIG{'FirstMessage'} = $CONFIG{'Messages'} - $CONFIG{'MessageLimit'} + 1;
	if ($CONFIG{'FirstMessage'} < 1) { $CONFIG{'FirstMessage'} = 1; }

	$CONFIG{'MessagesLeft'} = $CONFIG{'Messages'} - $CONFIG{'FirstMessage'} + 1;

# Print headers
	&httpHeaders;
	print "Content-Type: text/html$crlf$crlf";

	&flush;
	$noErrorMessage = 0;

# Show inbox or options if name or email missing
	&getHeadersFromServer($CONFIG{'FirstMessage'});
	&DisconnectPOP3;

	if (!$CONFIG{'RealName'} or !$CONFIG{'RealEmail'}) {

		&loadModule('misc.cgi');
		&options(1);
	}
	else { &inbox(1); }
}


# Logout --------------------------------------------------------------------

sub logout {

	$noErrorMessage = 1;

	&loadConfig('server.cfg', 1);
	&loadConfig('main.cfg', 1);

	&loadConfig("$CONFIG{'Language'}.cfg");

#	if ($CONFIG{'NoFastLogout'}) {
		&deleteFromServer;
		&deleteCache;

		if ($CONFIG{'AfterLogout'}) { &redirect($CONFIG{'AfterLogout'}); }
		else { &loginForm; }
#	}
#	else {
#		if ($CONFIG{'AfterLogout'}) { &forkProcess('&redirect($CONFIG{\'AfterLogout\'});', 1); }
#		else { &forkProcess('&loginForm;', 1); }

#		&deleteFromServer;
#		&deleteCache;
#	}

	&loadModule('misc.cgi');
	exit;
}


# Check new mail ------------------------------------------------------------

sub checkmail {

	&httpHeaders;
	print "Content-Type: text/html$crlf$crlf";

	$oldcount = $CONFIG{'Messages'};

	&ConnectPOP3;
	&getHeadersFromServer($CONFIG{'Messages'} + 1);
	&DisconnectPOP3;

	$CONFIG{'MessagesLeft'} += $CONFIG{'Messages'} - $oldcount;

	&inbox(1);
}


# Connect to a socket -------------------------------------------------------

sub ConnectSocket {

	my ($remote, $port) = @_;
	my ($iaddr, $paddr, $proto, $tryme);

	eval $timeoutOn;
	$tryme = 0;

	for (;;) {
		if ($port =~ /\D/) { $port = getservbyname($port, 'tcp') }
		return 0 unless $port;
		$iaddr = inet_aton($remote) or return 0;
		$paddr = sockaddr_in($port, $iaddr);

		$proto = getprotobyname('tcp');
		socket(S, PF_INET, SOCK_STREAM, $proto) or return 0;

		$tryme++;
		return 0 if ($tryme == 10);

		connect(S, $paddr) and last;
		sleep 2;
	}

	binmode S if $WinNT;

	select(S);
	$| = 1;
	select(STDOUT);

	eval $timeoutOff;
	return 1;
}


# Disconnect socket ---------------------------------------------------------

sub DisconnectSocket {

	eval $timeoutOff;
	close(S);
}


# Send a file using SMTP ----------------------------------------------------

sub mailFile {

	my ($filename, $deliverynotes, $printlog) = @_;

	@servers = split(/\s*\,\s*/, $CONFIG{'SMTPServers'});
	$SMTPlog = '';
	$noErrorMessage = 1;

	foreach (@servers) {
		if (&mailFileSub($filename, $_, $deliverynotes, $printlog)) {

			unlink($filename);			# Message sent - kill it and exit
			last;
		}
	}
}


sub mailFileSub {

	my ($filename, $server, $deliverynotes, $printlog) = @_;
	my ($dsn, $rcpt, $rcptcount, $all, $from, $header);

# Get the header of the message
	open(FILE, "<$filename");

	while (<FILE>) {
		tr/\x0d\x0a//d;

		/^From:.*\<(.+)\>/ and $from = $1;

		/^(To|CC|BCC):\s*(.+)/i and $all .= "$2 ";
		/^BCC:/i and next;

		$header .= "$_$crlf";
		/^\s*$/ and last;
	}

# Give up if no valid recipients
	if ($all !~ /[\w.\-\%\!\|]+\@[\w.\-]+\.\w+/) {
		close FILE;
		return 1;
	}

# Log in to the SMTP server
#	print "Connecting to ${server}... " if $printlog;

	&ConnectSocket($server, 25) or return 0;
	eval $timeoutOn;

	$_ = <S>;
#	print "$_<BR>" if $printlog;

	/^220 / or return 0;

	print S "EHLO ", ($CONFIG{'OverrideHELO'} or $CONFIG{'RemoteHost'}), $crlf;
	$_ = <S>;

	if (/^250-/) {
		for (;;) {
			$_ = <S>;

			/\bDSN\b/ and $dsn = 1;
			/250\s/ and last;
		}
	}
	else {
		print S "HELO ", ($CONFIG{'OverrideHELO'} or $CONFIG{'RemoteHost'}), $crlf;
		$_ = <S>;
		/^250 / or return 0;
	}

	if ($dsn and $deliverynotes) {
		print S "MAIL FROM:<", ($CONFIG{'OverrideMailFrom'} or $from), "> RET=HDRS ENVID=bLaH!$crlf";
	}
	else {
		print S "MAIL FROM:<", ($CONFIG{'OverrideMailFrom'} or $from), ">$crlf";
	}

	$_ = <S>;
#	print "Sender: $from... $_<BR>" if $printlog;

	/^250 / or return 1;

# Handle recipients
	$rcptcount = 0;

	while ($all =~ /[\w.\-\%\!\|]+\@[\w.\-]+\.\w+/g) {
		eval $timeoutOn;

		$rcpt = $&;
		$rcpt =~ s/\.+/./g;

		if ($dsn and $deliverynotes) {
			print S "RCPT TO:<$rcpt> NOTIFY=SUCCESS,FAILURE,DELAY ORCPT=rfc822;$&$crlf";
		}
		else {
			print S "RCPT TO:<$rcpt>$crlf";
		}

		$_ = <S>;
#		print "Recipient: ${rcpt}... $_<BR>" if $printlog;

		/^250 / and $rcptcount++;
		last if ($rcptcount > $CONFIG{'MaxRecipients'});
	}

	return 1 if ($rcptcount == 0);

# Send message
	eval $timeoutOn;

	print S "DATA$crlf";
	$_ = <S>;
	/^354 / or return 0;

	print S $header;

	while (<FILE>) {
		eval $timeoutOn;

		/^\.\s*$/ and $_ = "..";
		tr/\x0d\x0a//d;

		print S "$_$crlf";
	}
	close FILE;

# Message sent, quit
	print S "$crlf\.$crlf";

	$_ = <S>;
#	print "Sending message... $_<BR>" if $printlog;

	/^250 / or return 0;

	print S "QUIT$crlf";
	$_ = <S>;
	/^221 / or return 0;

	&DisconnectSocket;
	return 1;
}


# Connect to a POP3 server --------------------------------------------------

sub ConnectPOP3 {

# Return if already connected
	return if $connected;

# Get user's password
	$password = &loadFile($CONFIG{'TempPath'}.$FORM{'p'}) or &error('ErrorLoggedout', 2040);
	$password =~ tr/0-4A-Za-z5-9/A-Za-z0-9/;

	$password or &error('ErrorLoggedout', 2050);

# Try to connect
	&ConnectSocket($CONFIG{'Server'}, $CONFIG{'POP3Port'}) or &error('ErrorConnect', 2060);

# Get the greeting
	eval $timeoutOn;

	$_ = <S>;
	/^\+OK/ or &error('ErrorPOP3Login', 2070, $_);

# Send username
	eval $timeoutOn;

	print S "USER $CONFIG{'Login'}$crlf";
	$_ = <S>;
	/^\+OK/ or &error('ErrorPOP3Login', 2080, $_);

# Send password
	print S "PASS $password$crlf";
	$_ = <S>;
	/^\+OK/ or &error('ErrorPOP3Login', 2090, $_);

# Compare messages in da cache against the messages in da server
	if ($CONFIG{'LastUIDL'} and $CONFIG{'Messages'}) {
		print S "UIDL $CONFIG{'Messages'}$crlf";
		$_ = <S>;
		tr/\x0d\x0a//d;

		$CONFIG{'LastUIDL'} eq $_ or &error('ErrorRelogin', 2100);
	}

	eval $timeoutOff;

	$connected = 1;
}


# Disconnect from da POP3 server --------------------------------------------

sub DisconnectPOP3 {

	return if !$connected;

	eval $timeoutOn;
	print S "QUIT$crlf";
	<S>;
	eval $timeoutOff;

	&DisconnectSocket;

	$connected = 0;
}


# Format vCard --------------------------------------------------------------

sub formatVCard {

	my ($atch) = @_;
	my ($name, $ctype, $bin);

	$source = &loadFile("$CONFIG{'TempPath'}$FORM{'u'}\.atch\.$atch");

	$source =~ s/^(.|\n)*?\n\s*\n//;		# Remove headers

	$org = $photo = $adr = $name = "<BR>";
	$contact = $longitude = $latitude = $city = "";
	$logo = "{ImageVCardLogo}";				# Default logo

	$source =~ s/=\n//g;					# Combine multiline-entries
	$source =~ s/\n\s+/ /g;					# Likewise
	$source =~ s/^\w*\.(\w)/$1/gm;			# Remove grouping
	$source =~ s/^(.*?:)\s*/$1/g;			# Remove stupid NN4 whitespace...
	$source =~ s/;(ENCODING=)*QUOTED-PRINTABLE(.*?:)(.*)/$2 . &parseVCardQP($3)/ge;

# Get organization
	$source =~ /^ORG:(.*)/mi and $org = "<B>$1</B>";
	$org =~ s/;+/<BR>\n/g;

# Get name
	$source =~ /^N:(.*)/mi;

	($last, $first, $middle, $prefix, $suffix) = split(/;/, $1);

	($source =~ /^FN:(.*)/mi and $name = "<B>$1</B>") or do {

		$prefix and $prefix .= " ";
		$suffix and $suffix = ", $suffix";

		$name = "<B>$prefix$first $middle $last$suffix</B>";
	};

# Get title
	$source =~ /^TITLE:(.*)/mi and $name .= "<BR>\n<I>$1</I>";

# Get address
	($source =~ /^LABEL.*?:(.*)/mi and $adr = $1) or do {

		$source =~ /^ADR.*?:(.*)/mi and $adr = $1;
		$adr =~ s/;+/<BR>/g;
	};

	$adr =~ s/<BR>/<BR>\n/g;
	$adr =~ s/.*$last.*//i;

	while ($org =~ /.*/g) {
		$temp = $&;
		$temp =~ s/<.*?>//g;
		$adr =~ s/.*$temp.*//i;
	}

# Get phonenumbers
	$source =~ s/^TEL.*?PAGER.*?:(.*)//mi; # and $contact .= "{TextVCardPager}: $1<BR>\n";

	$source =~ s/^TEL.*?FAX.*?:(.*)//mi and $contact .= "{TextVCardFax}: $1<BR>\n";
	$source =~ s/^TEL.*?(CELL|CAR).*?:(.*)//mi and $contact .= "{TextVCardCellular}: $2<BR>\n";
	$source =~ s/^TEL.*?HOME.*?:(.*)//mi and $contact = "{TextVCardHome}: $1<BR>$contact\n";
	$source =~ s/^TEL.*?WORK.*?:(.*)//mi and $contact = "{TextVCardWork}: $1<BR>$contact\n";
	$source =~ /^TEL.*?:(.*)/mi and $contact = "$1<BR>\n$contact";

# Get timezone
	$source =~ /^TZ:(.*)/mi and $contact .= "{TextVCardTimezone} $1<BR>\n";

# Get location (longitude, latitude & city)
	$source =~ /^GEO:(.*)/mi and do {

		($longitude, $latitude) = split(/,/, $1);
		$longitude =~ tr/0-9.//cd;
		$latitude =~ tr/0-9.//cd;

		$source =~ /^ADR.*?:(.*)/mi and $city = (split(/;/, $1))[3];
	};

# Get logo & photo
	for $logophoto ("logo", "photo") {

		if ($source =~ /^${logophoto}.*?\bURL.*?:(.*)/mi) {

			$temp = $1;
			$temp =~ s/\s//g;
			$$logophoto = "<IMG SRC=\"$temp\" ALT=\"[$logophoto]\" BORDER=0>";

		}

		elsif ($source =~ /^($logophoto.*?\bBASE64.*?):(.*)/mi) {

			$bin = $2;
			$ctype = $1 =~ /GIF/i ? "image/gif" : "image/jpeg";

			$$logophoto = "<IMG SRC=\"{ScriptName}?do=download\&msg=" .
				&saveTextBlock($ctype, "base64", $bin) .
				"\&{LinkQueryString}\" ALT=\"[$logophoto]\">\n";
		}

		elsif ($source =~ /^$logophoto.*?\bMIME.*?:(.*)/mi) {

			$temp = $1;
			$temp =~ s/[\s<>]//g;
			$$logophoto = "<IMG SRC=\"{ScriptName}?do=download&cid=" . &urlEncode($temp) . "&{LinkQueryString}\" ALT=\"[$logophoto]\" BORDER=0>";
		}
	}

# Get email address & URL
	$source =~ /^URL:(.*)/mi and do {

		if ($CONFIG{'AllowHTMLColors'}) {
			$contact = "<A HREF=\"$1\" TARGET=\"_top\">$1</A><BR>\n$contact";
		}
		else {
			$contact = "$1<BR>\n$contact";
		}

		$logo = "<A HREF=\"$1\" TARGET=\"_blank\">$logo</A>";
		$photo = "<A HREF=\"$1\" TARGET=\"_blank\">$photo</A>";
	};

	$email = '';

	($source =~ /^EMAIL.*?INTERNET.*?:(.*)/mi and $email = $1) or
	$source =~ /^EMAIL:(.*)/mi and $email = $1;

	if ($email) {
		if ($CONFIG{'AllowHTMLColors'}) {
			$contact = "<A HREF=\"{ScriptName}?do=compose&to=" . &urlEncode($email) . "&msg=$nowparsing&{LinkQueryString}\">$1</A><BR>\n$contact";
		}
		else {
			$contact = "$email<BR>\n$contact"
		}
	}

	$contact = "<BR>" unless $contact;

# HTML for the buttons
	if ($email =~ /@/) {
		$buttons = "{TButtonStart}<A HREF=\"{ScriptName}?do=saveaddress" .
			"\&msg=$nowparsing\&name=" . &urlEncode("$first $last") . 
			"\&email=" . &urlEncode($email) . 
			"\&{LinkQueryString}\">{TextSaveAddress}</A>{TButtonEnd}\n";
	}

	if ($longitude and $CONFIG{'JavaScript'} > 1) {
		$buttons .= "{TButtonStart}<A HREF=\"javascript:" .
			"viewMap($longitude, $latitude, '$city');\">{TextViewMap}</A>{TButtonEnd}\n";
	}

	if ($CONFIG{'ViewSource'}) {
		$buttons .= "{TButtonStart}<A HREF=\"{ScriptName}?do=download\&msg=$atch" .
			"\&{LinkQueryString}\" TARGET=\"_blank\">{TextViewSource}</A>{TButtonEnd}\n";
	}

# Format vCard
	$fonton = "<FONT COLOR=\"#000000\" SIZE=2 FACE=\"VERDANA,ARIAL,HELVETICA\">";
	$fontoff = "</FONT>";
	$bc = 'BGCOLOR="#FFFFCC"';

	if ($CONFIG{'AllowHTMLColors'}) {
		$csson = "<STYLE><!--\nA {color: #0000FF}\n--></STYLE>";
		$cssoff = "<STYLE><!--\nA {color: $CONFIG{'LinkColor'}}\n--></STYLE>";
	}

	return "\n</PRE>$csson\n" .
		"<TABLE BORDER=0 CELLPADDING=4 CELLSPACING=0>\n" .
		"<TR><TD VALIGN=top $bc>$fonton$org$fontoff<BR>\n" .
		"<IMG SRC=\"{VirtualGfxPath}blackdot.gif\" WIDTH=160 HEIGHT=1 ALIGN=right><P>\n" .
		"$fonton$adr$fontoff</TD>\n" .
		"<TD ROWSPAN=2 VALIGN=middle $bc><IMG SRC=\"{VirtualGfxPath}blackdot.gif\" WIDTH=1 HEIGHT=170></TD>\n" .
		"<TD VALIGN=bottom $bc>$fonton$photo<BR>$name$fontoff<BR>" .
		"<IMG SRC=\"{VirtualGfxPath}blackdot.gif\" WIDTH=200 HEIGHT=1></TD></TR>\n" .
		"<TR><TD VALIGN=bottom $bc>$fonton$logo$fontoff</TD>\n" .
		"<TD VALIGN=bottom $bc><BR>$fonton$contact$fontoff</TD></TR>\n" .
		"</TABLE>\n$cssoff\n$buttons\n<PRE>\n";
}


# Parse QP-encoding used in vCards ------------------------------------------

sub parseVCardQP {

	my ($string) = @_;

	$string =~ s/=0D//ig;
	$string =~ s/=0A/<BR>/ig;
	$string =~ s/=([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;

	return $string;
}


# Parse QP/BASE64-coded headers ---------------------------------------------

sub parseHeaders {

	my ($temp, $charset, $coding, $string);

	($_) = @_;
	($temp, $charset, $coding, $string) = split(/\?/);

	if ($coding =~ /Q/i) {
		$string =~ s/=([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
		$string =~ s/\_/\ /g;
	}
	elsif ($coding =~ /B/i) {
		$string = &base64Decode($string);
	}
	else { return $_; };		# Something's wrong.....

	return $string;
}


# Save log ------------------------------------------------------------------

sub saveLog {

	$t = time;
	$between = $t - $CONFIG{'LastLoginTime'};
	$between < 0 and $between = 1;
	$between > 10000000 and $between = 0;

	$upload = $CONFIG{'FileUpload'} ? 1 : 0;
	$proto = $ENV{'HTTPS'} ? "https:" : "http:";

	$ua = $ENV{'HTTP_USER_AGENT'};
	$ua =~ s/\,/\&\#44\;/g;

	$logstring = "user,1,$proto//$CONFIG{'ServerName'}," .
		"$CONFIG{'Login'}\@$CONFIG{'Server'},$CONFIG{'RemoteHost'}," .

		"$t,$between,$CONFIG{'LoginCount'},$CONFIG{'Messages'},$CONFIG{'MailboxSize'}," .
		"$CONFIG{'Language'},$CONFIG{'SpamAction'},$upload,$CONFIG{'JavaScript'}," .
		"$CONFIG{'ScreenWidth'},$CONFIG{'ScreenHeight'},$CONFIG{'ScreenDepth'},$ua";

	$logstring =~ tr/\x0a\x0d//d;

	saveString("$CONFIG{'LogPath'}main.log", "$logstring\n");
}


# Save uuencoded attachments ------------------------------------------------

sub saveUuencoded {

	my ($name) = @_;
	my ($atch, $ctype, $vcard);

	$name =~ s/^.*[\\\/]//;
	$name =~ tr/A-Za-z0-9_.\-//cd;

	$atch = 1;
	while (-e "$CONFIG{'TempPath'}$FORM{'u'}\.atch\.$atch") { $atch++; }
		
	$ctype = "application/octet-stream";
	$name =~ /\.(gif|jpeg)$/i and $ctype = "image/$1";
	$name =~ /\.jpg$/i and $ctype = "image/jpeg";

	open(ATCHFILE, ">$CONFIG{'TempPath'}$FORM{'u'}\.atch\.$atch");
	print ATCHFILE "Content-Type: $ctype; name=\"$name\"\n",
		"Content-Transfer-Encoding: x-uuencode\n\nbegin 666 $name\n";

	for (;;) {
		eval $timeoutOn;
		$_ = <S> or last;
		eval $timeoutOff;

		/^\.\s*$/ and return 0;

		print ATCHFILE $_;

		/^end\s*$/ and last;
	}
	close(ATCHFILE);

	if ($name =~ /\.vcf$/i) {		# Handle uuencoded vCards (MSIE 4)

		$vcard = &loadFile("$CONFIG{'TempPath'}$FORM{'u'}\.atch\.$atch");

		$vcard =~ s/^(.|\n)*?begin.*//i;
		$vcard =~ s/end(.|\n)*$//i;
		$vcard =~ s/.*\n/unpack("u", $&)/ge;

		return "\@--mailreader-vcard-" .
			&saveTextBlock("text/plain", "8bit", $vcard) . "--\@";
	}

	return "\@--mailreader-uuencoded-:$name:-:$ctype:-$atch--\@";
}


# Fix the "Download" -link for uuencoded attachments ------------------------

sub fixUuencoded {

	my ($name, $ctype, $atch) = @_;

	if (!$CONFIG{'NoInlineImages'} and $ctype =~ /image/) {

		return "<IMG SRC=\"{ScriptName}/$name?do=download\&msg=$atch\&" .
			"{LinkQueryString}\" ALT=\"[$CONFIG{'TextAttachedFile'}: $name]\"><P>\n";
	}

	return "</PRE>" . &downloadHTML($name, $ctype, $atch) . "<PRE>";
}


# Return HTML for da "Download attachment" ----------------------------------

sub downloadHTML {

	my ($name, $ctype, $atch, $size) = @_;

	$ctype =~ s/;.*//;

	return "\n<TABLE BORDER=2 CELLPADDING=2 CELLSPACING=0>\n" .
		"<TR><TD BGCOLOR=\"{HdrBgrColor}\" COLSPAN=2>\n{IconAttachment}\n" .
		"<FONT COLOR=\"{AltTextColor}\">{BigTextStart}{TextAttachedFile}{BigTextEnd}</FONT></TD></TR>\n" .

		"<TR><TD VALIGN=top><A HREF=\"{ScriptName}/$name?do=download\&msg=$atch\&type=download\&{LinkQueryString}\">" .
		"<STRONG>{TextAttachmentDownload}</STRONG></A>&nbsp;<BR>\n" .

		"<A HREF=\"{ScriptName}/$name?do=download\&msg=$atch\&type=text\&{LinkQueryString}\" TARGET=\"popUpWin\"" .
		($CONFIG{'JavaScript'} > 1 ? " onClick=\"openPopUp('{ScriptName}/$name?do=download\&msg=$atch\&type=text\&{LinkQueryString}')\">" : '>') .
		"<STRONG>{TextAttachmentAsText}</STRONG></A>&nbsp;</TD>\n" .

		"<TD VALIGN=top>&nbsp;<STRONG>{TextAttachmentName}:</STRONG> $name<BR>\n" .
		"&nbsp;<STRONG>{TextAttachmentType}:</STRONG> $ctype\n" .

		($size ? "<BR>\n&nbsp;<STRONG>{TextSize}:</STRONG> " . int($size / 1024) . "K\n" : '') .

		"</TD></TR></TABLE><P>\n";
}


# Save a block of text as an attachment -------------------------------------

sub saveTextBlock {

	my ($ctype, $encoding, $block) = @_;
	my ($atch);

	$atch = 1;
	while (-e "$CONFIG{'TempPath'}$FORM{'u'}\.atch\.$atch") { $atch++; }
		
	open(ATCHFILE, ">$CONFIG{'TempPath'}$FORM{'u'}\.atch\.$atch");
	print ATCHFILE "Content-Type: $ctype$crlf",
		"Content-Transfer-Encoding: $encoding$crlf$crlf$block";
	close(ATCHFILE);

	return $atch;
}


# Parse incoming message ----------------------------------------------------

# Return values:
#   0 - End of message reached
#   1 - Message continues
#   2 - Emergency exit - return ASAP!

sub parseMessage {

	my ($saveHeader, $defaulttype, $endstring, $related) = @_;
	my ($header, $body, $boundary, $atch, $name, $altheader, $altbody, $alternative,
		$inline, $temp, $ctype, $parsecode);

	$header = "";
	$body = "";
	$alternative = 0;

# Get header
	for (;;) {
		eval $timeoutOn;
		$_ = <S> or return 0;
		eval $timeoutOff;

		tr/\x0d\x0a//d;

		/^--$endstring/ and last if ($endstring);
		/^\.\s*$/ and last;
		/^\s*$/ and last;

		$header .= "$_\n";
	}

# Fix & complete header
	$header =~ s/\s*$//;
	$header =~ s/\n\s+/\ /g;								# Join multiline headers

	$header =~ s/=\?.*?\?.\?.*?\?=/&parseHeaders($&)/ge;	# Parse QP/BASE64-coding

	if ($header !~ /^Content-Type\:.*\//im) {
		$header =~ s/^Content-Type\:.*\n//gim;
		$header .= "\nContent-Type: $defaulttype";
	}

	$header =~ /^Content-Type\:\s*(.*)/im;					# Get Content-Type
	$ctype = $1;

	$header =~ s/^Priority\:\s*urgent/X-Priority: 1 (Highest)/im;	# Pegasus priority

# Save header
	print FILE "<X-MAILREADER-HEADER>\n$header\n</X-MAILREADER-HEADER>\n" if ($saveHeader);

	if ($endstring) {
		/^--$endstring--/ and return 0;
		/^--$endstring/ and return 1;
	}

	/^\.\s*$/ and return 2;

# Make sure text/x-vcard is displayed inline
	if ($ctype =~ /^text\/x-vcard\b/i) { $header =~ s/Content-Disposition.*//;	}

# Handle multipart/alternative
	if ($ctype =~ /^multipart\/alternative\b.*?\bboundary\=(.*)/i) {

		$boundary = $1;
		$alternative = 1;

		if ($boundary =~ /\"/) {

			$boundary =~ s/^.*?\"//;
			$boundary =~ s/\".*$//g;
		}
		else { $boundary =~ s/\s//g; };

		$boundary =~ s/\W/\\$&/g;

		for (;;) {				# Skip preamble
			eval $timeoutOn;
			$_ = <S> or return 0;
			eval $timeoutOff;

			/^\.\s*$/ and return 2;
			/^--$boundary--/ and return 0;
			/^--$boundary/ and last;
		}

		for (;;) {				# Loop through all alternatives
			$altheader = "";
			for (;;) {			# Get subheader
				eval $timeoutOn;
				$_ = <S> or return 0;
				eval $timeoutOff;

				tr/\x0d\x0a//d;
				/^\.\s*$/ and return 2;
				/^\s*$/ and last;

				$altheader .= "$_\n";
			}

			$altheader =~ /^Content-Type\:.*\//im
				or $header .= "\nContent-Type: text/plain";

			$altbody = "";
			for (;;) {			# Get subbody
				eval $timeoutOn;
				$_ = <S> or return 0;
				eval $timeoutOff;

				/^\.\s*$/ and last;
				/^--$boundary/ and last;

				tr/\x0d\x0a//d;
				$altbody .= "$_\n";
			}

			$altheader = '' if ($CONFIG{'PreferPlainText'} and $ctype =~ /^text\/plain\b/i);

			if ($altheader =~ /^Content-Type\:\s*text\/(plain|richtext|enriched|html)/im) {

				$header = $altheader;
				$body = $altbody;

				$header =~ /^Content-Type\:\s*(.*)/im;	# Get new Content-Type
				$ctype = $1;
			}

			/^--$boundary--/ and last;
			/^\.\s*$/ and return 2;
		}
	}

# Handle multipart/(mixed|digest|related|???)
	elsif ($ctype =~ /^multipart\/.*?\bboundary\=(.*)/i) {

		$boundary = $1;

		if ($boundary =~ /\"/) {

			$boundary =~ s/^.*?\"//;
			$boundary =~ s/\".*$//g;
		}
		else { $boundary =~ s/\s//g; };

		$boundary =~ s/\W/\\$&/g;

		for (;;) {
			eval $timeoutOn;
			$_ = <S> or return 0;
			eval $timeoutOff;

			/^\.\s*$/ and return 2;
			/^--$boundary/ and last;
		}

		if ($ctype =~ /^multipart\/digest\b/i) {
			$parsecode = "\$_ = \&parseMessage(0, 'message/rfc822', '$boundary')";
		}
		elsif ($ctype =~ /^multipart\/related\b/i) {
			$parsecode = "\$_ = \&parseMessage(0, 'text/plain', '$boundary', 1)";
		}
		else { $parsecode = "\$_ = \&parseMessage(0, 'text/plain', '$boundary')"; }

		do {
			eval $parsecode;
			$_ == 2 and return 2;
		} while ($_);

		for (;;) {
			eval $timeoutOn;
			$_ = <S> or return 0;
			eval $timeoutOff;

			if ($endstring) {
				/^--$endstring--/ and return 0;
				/^--$endstring/ and return 1;
			}

			/^\.\s*$/ and return 2;
		}
	}

# Handle message/rfc822 (and text/rfc822-headers that are used in delivery reports)
	elsif ($ctype =~ /^(message\/rfc822|text\/rfc822-headers)\b/i) {

		print FILE "<P><HR SIZE=2 WIDTH={TableWidth} ALIGN=left>\n";
		return &parseMessage(1, "text/plain", $endstring);
	}

# Handle attachmets and unknown Content-Types
	elsif ($header =~ /^Content-Disposition\:\s*attachment/im or
		$ctype !~ /^(text|message)\//i) {

		$atch = 1;
		while (-e "$CONFIG{'TempPath'}$FORM{'u'}\.atch\.$atch") { $atch++; }
		
		$header =~ /^Content-Disposition\:.*?filename=(.*)/im or
		$header =~ /^Content-Type\:.*?name=(.*)/im or
		"attachment\.$atch" =~ /(.*)/;

		$name = $1;
		$name =~ s/^.*[\\\/:]//;
		$name =~ tr/A-Za-z0-9_.\-//cd;

		$header = "X-Content-Name: \"$name\"\n$header";

		$inline = $header =~ /^Content-Disposition\:\s*inline/im ? 1 : 0;
		$CONFIG{'NoInlineImages'} and $inline = 0;

		if (!$related) {
			if ($inline and ($ctype =~ /^image\/(gif|jpeg|jpg)\b/i)) {

				print FILE "<IMG SRC=\"{ScriptName}/$name?do=download\&msg=$atch\&",
					"{LinkQueryString}\" ALT=\"[{TextAttachedFile}: $name]\"><P>\n";
			}
			else {
				$size = $header =~ /^Content-Length:\s*(\d+)/im ? $1 : 0;
				print FILE &downloadHTML($name, $ctype, $atch, $size);
			}
		}

		open(ATCHFILE, ">$CONFIG{'TempPath'}$FORM{'u'}\.atch\.$atch");
		print ATCHFILE "$header\n\n";

		for (;;) {
			eval $timeoutOn;
			$_ = <S> or return 0;
			eval $timeoutOff;

			/^--$endstring/ and last if ($endstring);
			/^\.\s*$/ and last;

			tr/\x0d\x0a//d;
			print ATCHFILE "$_\n";
		}
		close(ATCHFILE);

		if ($endstring) {
			/^--$endstring--/ and return 0;
			/^--$endstring/ and return 1;
		}

		return 2;
	}

# Get the body (if it's not already there) and decode it if necessary
	if (!$alternative) {
		for (;;) {
			eval $timeoutOn;
			$_ = <S> or return 0;
			eval $timeoutOff;

			/^--$endstring/ and last if ($endstring);
			/^\.\s*$/ and last;

			if (/^begin\s*\d\d\d\s*(.*)\n/) {				# Uuencoded attachment
				$_ = &saveUuencoded($1);

				if ($_) {
					$body .= $_;
					next;
				}
				else { last; }
			}

			tr/\x0d\x0a//d;
			$body .= "$_\n";
		}
	}

	if ($header =~ /^Content-Transfer-Encoding\:.*quoted-printable/im) {

		$body =~ s/=\s*?\n//g;
		$body =~ s/=([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
	}
	elsif ($header =~ /^Content-Transfer-Encoding\:.*base64/im) {

		$temp = $_;
		$body = &base64Decode($body);
		$_ = $temp;
	}

# Convert strings that look like internal stuff to something safe
	$body =~ s/\@(--mailreader-\w*--)\@/\&#64;$1\&#64;/g;
	$body =~ s/{(\w+)}/&#123;$1&#125;/g;

# Handle text/html
	if ($ctype =~ /^text\/(html|x-html)\b/i) {

		$bodytag = $body =~ /<BODY(.*?)>/is ? $1 : '';

		$body =~ s/<!--.*?-->//gs;
		$body =~ s/(<|<\/)(BODY|HTML|APPLET|EMBED|OBJECT|META|FRAME|FRAMESET).*?>//gis;
		$body =~ s/<HEAD.*?<\/HEAD.*?>//gis;
		$body =~ s/<SCRIPT.*?<\/SCRIPT.*?>//gis;

		$body =~ s/(o)(n)(abort|blur|change|click|error|focus|load|mouse|reset|select|submit|unload|key|dragdrop|dblclick|move|resize)(\w*\s*=)/'&#' . ord($1) . ";$2$3$4"/gise;
		$body =~ s/(S)(RC\s*=\s*\"*\s*javascript:)/'&#' . ord($1) . ";$2"/gise;

		$body =~ s/<(A|FORM)\b.*?>/&fixLink($&)/gise;
		$body =~ s/\b(SRC|HREF|BACKGROUND)\s*=\s*\"cid:(.*?)\"/"SRC=\"{ScriptName}?do=download\&cid=" . &urlEncode($2) . "\&{LinkQueryString}\""/gise;

		$header =~ /Content-Base:\s*\"*(.*)\"*/i and print FILE "<BASE HREF=\"$1\">\n";

		if (!$CONFIG{'AllowHTMLColors'}) {
			$body =~ s/(C)(OLOR\s*=)/"\&#" . ord($1) . ";$2"/gise;
			$bgcolor = $bgimage = $csson = $cssoff = '';
		}
		else {
			$textcolor = $bodytag =~ /\bTEXT="*(#*.+?)\b/i ? $1 : '';
			$linkcolor = $bodytag =~ /\bLINK="*(#*.+?)\b/i ? $1 : '';
			$bgcolor = $bodytag =~ /\bBGCOLOR="*(#*.+?)\b/i ? $1 : '';
			$bgimage = $bodytag =~ /\bBACKGROUND="*(#*.+?)("|\s)/i ? $1 : '';

			if ($bgimage =~ /^cid:(.+)/i) {
				$bgimage = "{ScriptName}?do=download\&cid=" . &urlEncode($1) . "\&{LinkQueryString}";
			}

			if ($textcolor or $linkcolor or $bgcolor or $bgimage or $body =~ /COLOR\s*=/i) {
				$textcolor or $textcolor = "#000000";
				$linkcolor or $linkcolor = "#0000FF";
				$bgcolor or $bgcolor = "#FFFFFF";
			}

			$csson = "\n<STYLE><!--\nA {color: $linkcolor}\nBODY, TD, TABLE {color: $textcolor}\n--></STYLE>\n";
			$cssoff = "\n<STYLE><!--\nA {color: $CONFIG{'LinkColor'}}\nBODY, TD, TABLE {color: $CONFIG{'TextColor'}}\n--></STYLE>\n";

			$body =~ s/<\/TABLE>/$&<FONT COLOR="$textcolor">/gi;
		}

		$bgcolor = " BGCOLOR=\"$bgcolor\"" if $bgcolor;
		$bgimage = " BACKGROUND=\"$bgimage\"" if $bgimage;

		print FILE "$csson<TABLE WIDTH={TableWidth}><TD${bgcolor}${bgimage}>\n",
			"$body\n</TD></TABLE>$cssoff<P>\n<BASE HREF=\"$CONFIG{'ScriptName'}\">\n";
	}

# Handle text/enriched (convert to html)
	elsif ($ctype =~ /^text\/enriched\b/i) {

		$body =~ s/<(.*?)BOLD>/<${1}B >/gi;
		$body =~ s/<(.*?)ITALIC>/<${1}I >/gi;
		$body =~ s/<(.*?)FIXED>/<${1}TT >/gi;
		$body =~ s/<(.*?)SMALLER>/<${1}SMALL >/gi;
		$body =~ s/<(.*?)BIGGER>/<${1}BIG >/gi;
		$body =~ s/<(.*?)UNDERLINE>/<${1}U >/gi;
		$body =~ s/<(.*?)CENTER>/<${1}P ALIGN=center >/gi;
		$body =~ s/<(.*?)FLUSHLEFT>/<${1}P ALIGN=left >/gi;
		$body =~ s/<(.*?)FLUSHRIGHT>/<${1}P ALIGN=right >/gi;
		$body =~ s/<(.*?)FLUSHBOTH>/<${1}P ALIGN=left >/gi;
		$body =~ s/<(.*?)EXCERPT>/<${1}BLOCKQUOTE >/gi;
#		$body =~ s/<(.*?)NOFILL>/<${1}PRE >/gi;

		$body =~ s/<PARAM>.*?<\/PARAM>//gi;
		$body =~ s/<.*?[^\ ]>//gi;		# Remove rest of the <whatever> -commands
		$body =~ s/<</\000lt;/g;
		$body =~ s/\n(\n*)/ $1/g;
		$body =~ s/\n/<BR>\n/g;
		$body =~ s/\t/\ \000nbsp;\ \000nbsp;\ \000nbsp;\ \000nbsp;/g;
		$body =~ s/\ \ /\ \000nbsp;/g;

		$body =~ s!(http:|ftp:|gopher:|news:)//[\w.\,:/=\&?\@#\-~\%]*[\w/]!&convertURL($&, 0)!gie;
		$body =~ s![\w.\-]+\@[\w.\-]+\.\w+!&convertURL($&, 1)!ge;
		$body =~ s!\w*www\w*\.[\w\-]*\.[\w\.\,:/=\&?\@#\-~\%]*[\w/]!&convertURL($&, 2)!gie;
		$body =~ s!\w*ftp\w*\.[\w\-]*\.[\w\.\,:/=\&?\@#\-~\%]*[\w/]!&convertURL($&, 3)!gie;

		$body =~ tr/\000/\&/;
		$body =~ tr/\001/w/;
		$body =~ tr/\002/f/;
		$body =~ tr/\003/@/;

		print FILE "<TABLE WIDTH={TableWidth}><TR><TD>\n$body\n</TD></TR></TABLE><P>\n";
	}

# Handle text/richtext (convert to html)
	elsif ($ctype =~ /^text\/richtext\b/i) {

		$body =~ s/<(.*?)BOLD>/<${1}B >/gi;
		$body =~ s/<(.*?)ITALIC>/<${1}I >/gi;
		$body =~ s/<(.*?)FIXED>/<${1}TT >/gi;
		$body =~ s/<(.*?)SMALLER>/<${1}SMALL >/gi;
		$body =~ s/<(.*?)BIGGER>/<${1}BIG >/gi;
		$body =~ s/<(.*?)UNDERLINE>/<${1}U >/gi;
		$body =~ s/<(.*?)PARAGRAPH>/<${1}P >/gi;
		$body =~ s/<(.*?)CENTER>/<${1}P ALIGN=center >/gi;
		$body =~ s/<(.*?)FLUSHLEFT>/<${1}P ALIGN=left >/gi;
		$body =~ s/<(.*?)FLUSHRIGHT>/<${1}P ALIGN=right >/gi;
		$body =~ s/<(.*?)SUBSCRIPT>/<${1}SUB >/gi;
		$body =~ s/<(.*?)SUPERSCRIPT>/<${1}SUP >/gi;
		$body =~ s/<(.*?)EXCERPT>/<${1}BLOCKQUOTE >/gi;

		$body =~ s/<COMMENT>.*?<\/COMMENT>//gi;
		$body =~ s/<LT>/\000lt;/gi;
		$body =~ s/<NL>/<BR >\n/gi;
		$body =~ s/<NP>/<P >\n/gi;
		$body =~ s/<.*?[^\ ]>//gi;		# Remove rest of the <whatever> -commands
		$body =~ s/\t/\ \000nbsp;\ \000nbsp;\ \000nbsp;\ \000nbsp;/g;
		$body =~ s/\ \ /\ \000nbsp;/g;

		$body =~ s!(http:|ftp:|gopher:|news:)//[\w.\,:/=\&?\@#\-~\%]*[\w/]!&convertURL($&, 0)!gie;
		$body =~ s![\w.\-]+\@[\w.\-]+\.\w+!&convertURL($&, 1)!ge;
		$body =~ s!\w*www\w*\.[\w\-]*\.[\w\.\,:/=\&?\@#\-~\%]*[\w/]!&convertURL($&, 2)!gie;
		$body =~ s!\w*ftp\w*\.[\w\-]*\.[\w\.\,:/=\&?\@#\-~\%]*[\w/]!&convertURL($&, 3)!gie;

		$body =~ tr/\000/\&/;
		$body =~ tr/\001/w/;
		$body =~ tr/\002/f/;
		$body =~ tr/\003/@/;

		print FILE "<TABLE WIDTH={TableWidth}><TR><TD>\n$body\n</TD></TR></TABLE><P>\n";
	}

# Handle all other types as text/plain
	else {
		$body =~ s/^BEGIN:\s*VCARD\s*\n(.*\n)*?END:\s*VCARD/"\@--mailreader-vcard-" .
			&saveTextBlock("text\/plain", "8bit", $&) . "--\@"/egmi;

		$body =~ s/.{80,}/&wordWrap($&, 70)/ge;
		$body =~ s/\&(\w*);/\000amp;$1;/g;
		$body =~ s/>/\000gt;/g;
		$body =~ s/</\000lt;/g;

		$body =~ s!(http:|https:|ftp:|gopher:|news:)//[\w.\,:/=\&?\@#\-~\%]*[\w/]!&convertURL($&, 0)!gie;
		$body =~ s![\w.\-]+\@[\w.\-]+\.\w+!&convertURL($&, 1)!ge;
		$body =~ s!\w*www\w*\.[\w\-]*\.[\w\.\,:/=\&?\@#\-~\%]*[\w/]!&convertURL($&, 2)!gie;
		$body =~ s!\w*ftp\w*\.[\w\-]*\.[\w\.\,:/=\&?\@#\-~\%]*[\w/]!&convertURL($&, 3)!gie;

		$body =~ s/\s*$//;

		$body =~ tr/\000/\&/;
		$body =~ tr/\001/w/;
		$body =~ tr/\002/W/;
		$body =~ tr/\003/f/;
		$body =~ tr/\004/F/;
		$body =~ tr/\005/@/;

		$body =~ s/^\&gt;.*/\{ReplyRowStart\}$&\{ReplyRowEnd\}/gm;

		$body =~ s/\@--mailreader-uuencoded-:(.*):-:(.*):-(.*)--\@/
			&fixUuencoded($1, $2, $3)/ge;
		$body =~ s/\@--mailreader-vcard-(.*)--\@/&formatVCard($1)/ge;

		print FILE "<PRE>$body</PRE><P>\n";
	}

# Do a proper return
	if ($alternative) {
		for (;;) {
			eval $timeoutOn;
			$_ = <S> or return 0;
			eval $timeoutOff;

			if ($endstring) {
				/^--$endstring--/ and return 0;
				/^--$endstring/ and return 1;
			}

			/^\.\s*$/ and return 2;
		}
	}

	if ($endstring) {
		/^--$endstring--/ and return 0;
		/^--$endstring/ and return 1;
	}

	return 2;
}


# Fix a html-link -----------------------------------------------------------

sub fixLink {

	my ($link) = @_;
	my ($to, $subject);

	$link =~ /\=\s*\"\#/ and return $link;
	$link =~ /javascript:/i and return '<A>';
	$link =~ s/TARGET=\"*\w*\"*//gi;

	if ($link =~ /<A.*mailto:/is) {

		$link =~ /\"mailto:\s*(.*?)\"/ or $link =~ /mailto:([\w@\-.,?%=]*)/;
		$to = &urlDecode($1);
		$to =~ s/\?subject=(.*)//i and $subject = &urlDecode($1);

		$link = "<A HREF=\"{ScriptName}?do=compose\&to=" . &urlEncode($to);
		$link .= "\&subject=" . &urlEncode($subject) if ($subject);
		$link .= "\&\msg=$nowparsing\&{LinkQueryString}\">";

		return $link;
	}

	$link =~ s/>/ TARGET=\"_blank\">/;

	return $link;
}


# Convert URL -> HTML link --------------------------------------------------

sub convertURL {

	my ($string, $which) = @_;
	my ($temp);

	if ($which == 0) {
		$string = "<A HREF=\"$string\" TARGET=\"_blank\">$string</A>";
	}
	elsif ($which == 1) {
		$temp = &urlEncode($string);

		$string = "<A HREF=\"{ScriptName}?do=compose\&to=$temp\&" .
			"msg=$nowparsing\&{LinkQueryString}\">" .
			"$string</A>";
	}
	elsif ($which == 2) {
		$string = "<A HREF=\"http://$string\" TARGET=\"_blank\">$string</A>";
	}
	else {
		$string = "<A HREF=\"ftp://$string\" TARGET=\"_blank\">$string</A>";
	}

	$string =~ tr/w/\001/;
	$string =~ tr/W/\002/;
	$string =~ tr/f/\003/;
	$string =~ tr/F/\004/;
	$string =~ tr/@/\005/;

	return "{MessageLinkStart}$string\{MessageLinkEnd}";
}


# View source of a message --------------------------------------------------

sub viewSource {

	&httpHeaders;

	&ConnectPOP3;
	eval $timeoutOn;

	print S "LIST $FORM{'msg'}$crlf";
	$_ = <S>;
	/^\+OK/ or &error('ErrorRelogin', 2110);

	print S "RETR $FORM{'msg'}$crlf";
	print "Content-Type: text/plain$crlf$crlf";

	for (;;) {
		eval $timeoutOn;
		$_ = <S> or last;

		/^\.\s*$/ and last;

		print $_;
	}

	&DisconnectPOP3;
}


# Get one message from server -----------------------------------------------

sub getMessageFromServer {

	my ($msg) = shift;

	eval $timeoutOn;

	print S "RETR $msg$crlf";
	$_ = <S>;
	/^\+OK/ or &error('ErrorRelogin', 2120);

	open(FILE, ">$CONFIG{'TempPath'}$FORM{'u'}\.$msg");

	eval $timeoutOff;

	$nowparsing = $msg;
	&parseMessage(1, "text/plain");

	close(FILE);
}


# Get (new) headers from server ---------------------------------------------

sub getHeadersFromServer {

	my ($start) = shift;

	eval $timeoutOn;

	print S "STAT$crlf";
	$_ = <S>;
	tr/\x0d\x0a//d;

	$CONFIG{'Messages'} = (split(/ /))[1];

	print S "UIDL $CONFIG{'Messages'}$crlf";
	$CONFIG{'LastUIDL'} = <S>;
	$CONFIG{'LastUIDL'} =~ tr/\x0d\x0a//d;

	print "<SCRIPT>\n<!--\nwindow.onerror=null;\nfunction setStatus(msg) { window.status = \'Retrieving message \' + msg + \' of $CONFIG{'Messages'} ....\' }\n// -->\n</SCRIPT>\n"
		unless $CONFIG{'FastLogin'};

# Loop through the messages
	for ($msg = $start; $msg <= $CONFIG{'Messages'}; $msg++) {

# Generate progress counter / dummy traffic 
		if (!$CONFIG{'FastLogin'}) {
			if ($CONFIG{'JavaScript'} > 0) {
				print "<SCRIPT>\n<!--\nsetStatus($msg)\n// -->\n</SCRIPT>\n";
			}
			else {
				print "<!-- Retrieving message $msg -->\n";
			}
		}

# Get headers for all (new) messages
		eval $timeoutOn;

		print S "LIST $msg$crlf";
		$_ = <S>;
		/^\+OK/ or last;
		tr/\x0d\x0a//d;

		$CONFIG{"LengthOf$msg"} = (split(/ /))[2];

		open(FILE, ">$CONFIG{'TempPath'}$FORM{'u'}\.$msg");

		if ($CONFIG{"LengthOf$msg"} > $CONFIG{'HeadersOnlyLimit'}) {
			print S "TOP $msg 0$crlf";
			$_ = <S>;

			if (!/^\+OK/) {
				print S "RETR $msg$crlf";	# If TOP not supported
				$_ = <S>;
			}
			else {
				$CONFIG{"HeadersOnly"} .= "$msg ";
			}
		}
		else {
			print S "RETR $msg$crlf";
			$_ = <S>;
		};

		if (!/^\+OK/) {
			print FILE "<X-MAILREADER-HEADER>\n",
				"Subject: POP3 Error!\n",
				"From: $CONFIG{'Server'}\n",
				"Content-Type: text/html\n",
				"</X-MAILREADER-HEADER>\n",
				"<H2>POP3 Error!</H2><P>\n",
				"Server said: $_<P>";
			close(FILE);

			next;
		}

		eval $timeoutOff;

		$nowparsing = $msg;
		&parseMessage(1, "text/plain");

		close(FILE);
	}

# Clear the statusrow
	if ($CONFIG{'JavaScript'} > 0 and !$CONFIG{'FastLogin'}) {
		print "<SCRIPT LANGUAGE=\"JavaScript\">\n<!--\nwindow.onerror=null;\nwindow.status = '';\n// -->\n</SCRIPT>\n\n";
	}
}


# Delete messages from server -----------------------------------------------

sub deleteFromServer {

	return unless $CONFIG{'Deleted'} =~ /\d/;

	&ConnectPOP3;

	for ($msg = 1; $msg <= $CONFIG{'Messages'}; $msg++) {

		if ($CONFIG{'Deleted'} =~ /\b$msg\b/) {
			eval $timeoutOn;

			$deletedmsg .= "$msg ";
		
			print S "DELE $msg$crlf";
			$_ = <S>;

			if (!/^\+OK/) {
				$deletedmsg .= $_;
				last;
			}
		}
	}

# Log the deletions
	$logstring = "dele,1,$CONFIG{'Login'}\@$CONFIG{'Server'},$CONFIG{'Messages'},$deletedmsg";
	$logstring =~ tr/\x0a\x0d//d;

	&saveString("$CONFIG{'LogPath'}main.log", "$logstring\n");

# Disconnect
	&DisconnectPOP3;
}


1;
