#ifndef __MAILSYNC_MAILHANDLING__
#include "c-client.h"

//------------------------- Helper functions -----------------------------

//////////////////////////////////////////////////////////////////////////
//
void print_list_with_delimiter( const MsgIdSet& msgIds,
                                FILE* f,
                                const string& delim);
//
// Print the set of strings contained in "msgIds" and terminate each msgId
// with the delimiter "delim"
// 
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
//
void print_list_with_delimiter( const MailboxMap& mailboxes,
                                FILE* f,
                                const string& delim);
//
// Print the set of strings contained in "mailboxes" and terminate each
// item with the delimiter "delim"
// 
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
//
char* nccs( const string& s);
//
// C-Client doesn't declare anything const
// If you're paranoid, you can allocate a new char[] here
// 
//////////////////////////////////////////////////////////////////////////

//--------------------------- Mail handling ------------------------------

//////////////////////////////////////////////////////////////////////////
//
void print_lead( const char* action, const char* direction);
//
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
//
void print_from(MAILSTREAM* stream, const unsigned long msgno);
//
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
//
void print_msgid( const char* msgid);
//
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
//
MAILSTREAM* mailbox_open( MAILSTREAM* stream, 
                          const string& fullboxname,
                          long c_client_options);
//
// Opens mailbox "fullboxname" with "c_client_options" options.
//
// If possible use the higherlevel function below
//
// Returns NIL on failure.
//
//////////////////////////////////////////////////////////////////////////

#define __MAILSYNC_MAILHANDLING__
#endif
