/* Copyright (C) 1995 Bjoern Beutel. */

/* Description. =============================================================*/

/* Manages the storage of analysis results for faster access. */

/* Variables. ===============================================================*/

extern int_t cache_accesses; /* Number of calls of "word_in_cache". */
extern int_t cache_hits; /* Number of successful calls of "word_in_cache". */

/* Functions. ===============================================================*/

extern bool_t word_in_cache( string_t surf_start, 
                             string_t surf_end );
/* Return whether the word form SURF_START..SURF_END is in the cache. */

extern value_t next_result_in_cache( void );
/* Return the next result feature structure for a word form.
 * Use this function after calling "word_in_cache". */

extern void enter_in_cache( string_t surf_start,
                            string_t surf_end,
                            int_t fs_count,
                            value_t fs_vector[] );
/* Enter the word form SURF_START..SURF_END in the cache 
 * with FS_COUNT feature structures FS_VECTOR[]. */

extern void clear_cache( void );
/* Delete all cache entries. */

extern void set_cache_size( int_t size );
/* Set maximum number of cache entries to SIZE. */

extern int_t get_cache_size( void );
/* Get actual number of cache entries. */

extern int_t get_cache_maximum( void );
/* Get maximum number of cache entries. */

/* End of file. =============================================================*/
