<?xml version='1.0' encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [
<!ENTITY verbatim "
  (name(..) ='literallayout') or (name(../..) ='literallayout') or
  (name(..) ='screen') or (name(../..) ='screen') or
  (name(..) ='programlisting') or (name(../..) ='programlisting') "> ]>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:doc="http://exslt.org/common"
                extension-element-prefixes="doc"
                version='1.0'>

<xsl:output method="text" encoding="UTF-8" 
            omit-xml-declaration="yes" standalone="yes" indent="no"/>

<xsl:key name="id" match="*" use="@id"/>

<xsl:template name="string.replace">
  <xsl:param name="string"></xsl:param>
  <xsl:param name="target"></xsl:param>
  <xsl:param name="replace"></xsl:param>
  <xsl:choose>
    <xsl:when test="contains($string,$target)">
      <xsl:value-of select="concat(substring-before($string,$target),$replace)"/>
      <xsl:call-template name="string.replace">
        <xsl:with-param name="string" select="normalize-space(substring-after($string,$target))"/>
        <xsl:with-param name="target" select="$target"/>
        <xsl:with-param name="replace" select="$replace"/>
      </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="$string"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="trimleft">
  <xsl:param name="string"></xsl:param>
  <xsl:choose>
    <xsl:when test="contains($string, '&#10; ')">
      <xsl:call-template name="trimleft">
        <xsl:with-param name="string" select="concat(substring-before($string,'&#10; '), 
                            '&#10;', substring-after($string,'&#10; '))"/>
      </xsl:call-template>
    </xsl:when>
    <xsl:when test="contains($string,'&#10;&#10;')">
      <xsl:call-template name="trimleft">
        <xsl:with-param name="string" select="concat(substring-before($string,'&#10;&#10;'), 
                            '&#10;', substring-after($string,'&#10;&#10;'))"/>
      </xsl:call-template>
    </xsl:when>

    <xsl:otherwise>
      <xsl:value-of select="$string"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="*"/>

<xsl:template match="text()">
  <xsl:variable name="content">
    <xsl:value-of select="."/> 
  </xsl:variable>
  <xsl:choose>
    <xsl:when test="not (&verbatim;)">
      <xsl:call-template name="trimleft">
        <xsl:with-param name="string" select="$content"/>
      </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="."/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="refentry">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="remark">
  <xsl:variable name="string">
    <xsl:value-of select="."/> 
  </xsl:variable>
  <xsl:call-template name="string.replace">
    <xsl:with-param name="string" select="$string"/>
    <xsl:with-param name="target" select="'.\\'"/>
    <xsl:with-param name="replace" select="'&#10;.\'"/>
  </xsl:call-template>
</xsl:template>

<xsl:template match="refmeta">
  <xsl:variable name="p">
    <xsl:value-of select="refentrytitle"/>
    <xsl:text> </xsl:text>
    <xsl:value-of select="manvolnum"/>
    <xsl:text> "</xsl:text>
    <xsl:value-of select="refmiscinfo[@role='footermid']"/>
    <xsl:text>" "</xsl:text>
    <xsl:value-of select="refmiscinfo[@role='footerleft']"/>
    <xsl:text>" "</xsl:text>
    <xsl:value-of select="refmiscinfo[@role='header']"/>
    <xsl:text>"</xsl:text>
  </xsl:variable>
  <xsl:value-of select="normalize-space(concat('.TH ', $p))"/>
  <xsl:text>&#10;.nh</xsl:text>
</xsl:template>

<xsl:template match="refnamediv">
  <xsl:text>.SH İSİM</xsl:text>
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="refname">
  <xsl:variable name="pos">
    <xsl:number from="refnamediv" count="refname" format="1"/>
  </xsl:variable>
  <xsl:if test="$pos > 1">
    <xsl:text>.br&#10;</xsl:text>
    <xsl:call-template name="linkme"/>
  </xsl:if>
  <xsl:apply-templates/>
  <xsl:text> - </xsl:text>
</xsl:template>

<xsl:template name="linkme">
  <xsl:variable name="thisbase">
    <xsl:value-of select="."/>      
  </xsl:variable>
  
  <xsl:variable name="mainbase">
    <xsl:value-of select="../refname[1]"/>      
  </xsl:variable>
  
  <xsl:variable name="ext">
    <xsl:value-of select="../../refmeta/manvolnum"/>      
  </xsl:variable>
  
  <doc:document href="{concat($thisbase, '.', $ext)}" omit-xml-declaration="yes">
    <xsl:value-of select="concat('.so ', $mainbase, '.', $ext, '&#10;')"/>
  </doc:document>
</xsl:template>

<xsl:template match="refpurpose">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="refsynopsisdiv">
  <xsl:text>.SH KULLANIM</xsl:text>
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="refsect1">
  <xsl:text>.SH </xsl:text>
  <xsl:value-of select="title"/>
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="refsect2">
  <xsl:text>.SS </xsl:text>
  <xsl:value-of select="title"/>
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="para">
  <xsl:if test="name(..)='glossdef' and (preceding-sibling::para/child::glosslist)">
    <xsl:text>.IP </xsl:text>
    <xsl:value-of select="../../@userlevel"/>
  </xsl:if>
  <xsl:variable name="p">
    <xsl:apply-templates/>
  </xsl:variable>
  <xsl:if test="not(starts-with($p, '&#10;'))">
    <xsl:text>&#10;</xsl:text>
  </xsl:if>
  <xsl:choose>
    <xsl:when test="contains($p,'ĞğğĞ')">
      <xsl:call-template name="string.replace">
        <xsl:with-param name="string" select="$p"/>
        <xsl:with-param name="target" select="'ĞğğĞ'"/>
        <xsl:with-param name="replace" select="'&#10;.br&#10;'"/>
      </xsl:call-template>
      <xsl:text>&#10;</xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="$p"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="literallayout|screen">
  <xsl:text>.nf&#10;</xsl:text>
  <xsl:apply-templates/>
  <xsl:text>&#10;.fi&#10;</xsl:text>
</xsl:template>

<xsl:template match="filename|function|link|literal|option|prompt">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="xref">
  <xsl:variable name="targets" select="key('id',@linkend)"/>
  <xsl:variable name="target" select="$targets[1]/title"/>
  <xsl:value-of select="concat('\fB', $target,'\fR')"/>
</xsl:template>

<xsl:template match="glosslist|variablelist">
  <xsl:choose>
    <xsl:when test="name(../..)='glossdef' or name(../..)='listitem'">
      <xsl:text>.RS&#10;</xsl:text>
      <xsl:apply-templates/>
      <xsl:text>&#10;.RE&#10;</xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:apply-templates/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="glossentry">
  <xsl:variable name="p">
    <xsl:number from="glosslist" count="glossentry" format="1"/>
  </xsl:variable>
  <xsl:variable name="pos" select="$p - 1"/>
  <xsl:choose>
    <xsl:when test="not (glossterm)">
      <xsl:value-of select="concat('.IP ', @userlevel, '&#10;')"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:if test="not (../glossentry[$pos]/glossdef)">
        <xsl:text>&#10;.br&#10;.ns</xsl:text>
      </xsl:if>        
      <xsl:variable name="terms">
        <xsl:apply-templates select="glossterm"/>
      </xsl:variable>
      <xsl:value-of select="concat('&#10;.TP ', @userlevel, '&#10;', normalize-space($terms))"/>
    </xsl:otherwise>
  </xsl:choose>
  <xsl:apply-templates select="glossdef"/>
  <xsl:if test="count(../glossentry)&lt;$p+1"><xsl:text>&#10;.PP</xsl:text></xsl:if>
</xsl:template>

<xsl:template match="glossterm">
  <xsl:variable name="content">
    <xsl:apply-templates/>
  </xsl:variable>
  <xsl:value-of select="normalize-space($content)"/>
  <xsl:if test="name(following-sibling::*)='glossterm'">
    <xsl:text>, </xsl:text>
  </xsl:if>  
</xsl:template>

<xsl:template match="term">
  <xsl:variable name="comtent">
    <xsl:apply-templates/>
  </xsl:variable>
  <xsl:value-of select="normalize-space($content)"/>
  <xsl:if test="name(following-sibling::*)='term'">
    <xsl:text>, </xsl:text>
  </xsl:if>  
</xsl:template>

<xsl:template match="glossdef|varlistenry/listitem">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="orderedlist">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="orderedlist/listitem">
  <xsl:variable name="pos">
    <xsl:number from="orderedlist" count="listitem" format="1"/>
  </xsl:variable>
  <xsl:variable name="p">
    <xsl:text>.IP </xsl:text>    
    <xsl:choose>
      <xsl:when test="../@numeration='arabic'">      
        <xsl:number from="orderedlist" count="listitem" format="1."/>
      </xsl:when>
      <xsl:when test="../@numeration='loweralpha'">
        <xsl:number from="orderedlist" count="listitem" format="a."/>
      </xsl:when>
      <xsl:when test="../@numeration='lowerroman'">
        <xsl:number from="orderedlist" count="listitem" format="i."/>
      </xsl:when>
      <xsl:when test="../@numeration='upperalpha'">
        <xsl:number from="orderedlist" count="listitem" format="A."/>
      </xsl:when>
      <xsl:when test="../@numeration='upperroman'">
        <xsl:number from="orderedlist" count="listitem" format="I."/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:number from="orderedlist" count="listitem" format="1."/>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:text> </xsl:text>
    <xsl:value-of select="../@userlevel"/>   
  </xsl:variable>
  <xsl:value-of select="$p"/>
  <xsl:apply-templates/>
  <xsl:if test="count(../listitem)&lt;$pos+1"><xsl:text>&#10;.PP</xsl:text></xsl:if>
</xsl:template>

<xsl:template match="command|emphasis|replaceable|userinput|varname|wordasword">
  <xsl:variable name="p">
    <xsl:apply-templates/>
  </xsl:variable>
  <xsl:choose>
    <xsl:when test="name(.)='command' or
                    name(.)='userinput' ">
      <xsl:value-of select="concat('\fB', $p, '\fR')"/>
    </xsl:when>
    <xsl:when test="name(.)='small'">
      <xsl:value-of select="concat('\s-1', $p, '\s0')"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="concat('\fI', $p, '\fR')"/>
    </xsl:otherwise>
  </xsl:choose>  
</xsl:template>

<xsl:template match="email">
  <xsl:variable name="p">
    <xsl:apply-templates/>
  </xsl:variable>
  <xsl:call-template name="string.replace">
    <xsl:with-param name="string" select="concat('&lt;', $p, '>')"/>
    <xsl:with-param name="target" select="'@'"/>
    <xsl:with-param name="replace" select="' (at) '"/>
  </xsl:call-template>
</xsl:template>

<xsl:template match="blockquote">
  <xsl:text>.RS&#10;</xsl:text>
  <xsl:apply-templates/>
  <xsl:text>.RE&#10;</xsl:text>
</xsl:template>

<xsl:template match="ulink">
  <xsl:choose>
    <xsl:when test="count(child::node())=0">
      <xsl:value-of select="@url"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:apply-templates/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="sbr">
  <xsl:choose>
    <xsl:when test="name(..)='literallayout' 
                 or name(../..)='literallayout'
                 or name(..)='refnamediv'">
      <xsl:text>.br&#10;</xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:text>ĞğğĞ</xsl:text>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="warning">
  <xsl:value-of select="title"/><xsl:text>: </xsl:text>
  <xsl:apply-templates/>
</xsl:template>

</xsl:stylesheet>
