'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" Copyright (c) 1994-1997 Sun Microsystems, Inc.
'\" Copyright (c) 1993-1997 Bell Labs Innovations for Lucent Technologies
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: info.n,v 1.2 2003/11/24 05:09:59 bbbush Exp $
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: info.n,v 1.2 2003/11/24 05:09:59 bbbush Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH info n 7.5 Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
info \- 返回关于 Tcl 解释器状态的信息
.SH "总览 SYNOPSIS"
\fBinfo \fIoption \fR?\fIarg arg ...\fR?
.BE

.SH "描述 DESCRIPTION"
.PP
这个命令提供关于 Tcl 解释器的各种内部信息。合法的\fIoption\fR (可以是缩写)有: 
.TP
\fBinfo args \fIprocname\fR
返回一个列表，依次包含给过程\fIprocname \fR的参数们的名字。\fIProcname\fR   必须是一个 Tcl 命令的名字。
.TP
\fBinfo body \fIprocname\fR
返回过程 \fIprocname\fR 的过程体。\fIProcname\fR   必须是一个Tcl 命令的名字。
.TP
\fBinfo cmdcount\fR
返回在这个解释器中已经被调用的命令的总数的统计。     
.TP
\fBinfo commands \fR?\fIpattern\fR?
如果未指定 \fIpattern\fR  ，返回在当前名字空间中所有 Tcl 命令的名字的一个列表，包括用 C 写成的内置命令和使用 \fBproc\fR命令定义的命令过程。如果指定了 \fIpattern\fR，只返回匹配 \fIpattern\fR 的那些名字。使用与 \fBstring match\fR相同的规则确定匹配。\fIpattern\fR  可以是象 \fBFoo::print*\fR\fB \fR这样的一个限定的(qualified)名字。这样，可以使用由 \fB::\fR\fB\fR分隔的名字空间的名字序列来指定一个特定的名字空间，并可以用匹配后面特定字符的模式来指定在这个名字空间中的一系列命令。如果是 \fIpattern\fR是一个限定的名字，命令名字的结果列表中的每个元素都被指定名字空间的名字所限定。
.TP
\fBinfo complete \fIcommand\fR
如果 \fIcommand\fR 是一个完整的 Tcl 命令则返回 1，完整的意思是没有不闭合的引号、花括号、方括号或数组元素名，如果命令表现为不完整则返回 0。典型的，这个命令在面向行的输入环境中被用来允许用户键入分开(span)成多行的命令；如果命令不完整，脚本可以延期求值，直到键入增补的行完成这个命令。    
.TP
\fBinfo default \fIprocname arg varname\fR
\fIProcname\fR  必须是一个 Tcl 命令过程的名字而 \fIarg\fR 必须是给这个过程的一个参数的名字。如果 \fIarg\fR 没有缺省值则命令返回 \fB0\fR。否则它返回 \fB1\fR  并把这个缺省值放置到变量 \fIvarname\fR 中。
.TP
\fBinfo exists \fIvarName\fR
如果在当前上下文中存在叫 \fIvarName\fR  的变量(可以是一个全局变量或局部变量)，并已经通过给它一个值而被定义则返回 \fB1\fR，否则返回 \fB0\fR
.TP
\fBinfo globals \fR?\fIpattern\fR?
如果未指定 \fIpattern\fR ，返回所有当前定义的全局变量的名字的一个列表。全局变量是在全局名字空间中的变量。如果指定了 \fIpattern\fR ，只返回匹配 \fIpattern\fR 的那些名字。使用与 \fBstring match \fR相同的规则确定匹配。
.TP
\fBinfo hostname\fR
返回在其上执行这个调用的那个计算机的名字。
.TP
\fBinfo level\fR ?\fInumber\fR?
如果未指定 \fInumber\fR，这个命令返回给出调用过程的栈层次的一个数，如果在顶层调用这个名字则返回 0。如果指定了 \fInumber\fR ，则结果是由在栈上 \fInumber\fR 层调用的过程的名字和值组成的一个列表。如果 \fInumber\fR  是正数则选择的是一个特定的栈层次(1 参照最顶层活跃过程，2 是它调用的过程，以此类推)；否则给出的是相对当前层次的一个相对层次(0 参照当前过程，-1 是它的调用者，以此类推)。关于栈层次的详细信息参见 \fBuplevel\fR 命令。
.TP
\fBinfo library\fR
返回在其中存储标准 Tcl 脚本的库目录的名字。这实际上是 \fBtcl_library\fR 变量的值并可通过设置 \fBtcl_library \fR来变更。详情参见 \fBtclvars\fR 手册条目。
.TP
\fBinfo loaded \fR?\fIinterp\fR?
返回描述用 \fBload\fR  命令装载到 \fIinterp\fR  中的所有包的一个列表。每个列表元素都是有两元素的一个子列表，它们是从其中装载包的文件的名字和包的名字。对于静态装载包这个文件名字是一个空串。如果省略了 \fIinterp\fR  则返回在进程中所有的解释器中装载的包的信息。要得到当前解释器中的包的一个列表，指定 \fIinterp\fR参数为一个空串。
.TP
\fBinfo locals \fR?\fIpattern\fR?
如果未指定 \fIpattern\fR，返回所有当前定义的局部变量名字的一个列表，包括给当前过程的参数。 用 \fBglobal\fR 和 \fBupvar\fR命令定义的参数将不返回。如果指定了 \fIpattern\fR ，只返回匹配 \fIpattern\fR 的那些名字。使用与 \fBstring match \fR相同的规则确定匹配。 
.TP
\fBinfo nameofexecutable\fR
返回完整的二进制文件的路径名，从这个文件中调用了应用(程序)。如果Tcl 不能标识这个文件，则返回一个空串。
.TP
\fBinfo patchlevel\fR
返回全局变量 \fBtcl_patchLevel\fR\fB \fR的值；详情参见 \fBtclvars\fR 手册条目。
.TP
\fBinfo procs \fR?\fIpattern\fR?
如果未指定 \fIpattern\fR  ，返回在当前的名字空间中的所有 Tcl 命令过程的名字的一个列表。如果指定了 \fIpattern\fR，在返回在当前名字空间中匹配 \fIpattern\fR 的过程名字。使用与 \fBstring match \fR相同的规则确定匹配。
.TP
\fBinfo script\fR
如果当前正在求值一个 Tcl 脚本文件(例如，有一个 \fBTcl_EvalFile\fR 调用处于活跃或有一个对 \fBsource\fR 命令的活跃调用)，则这个命令返回被处理的最内部(innermost)文件的名字。否则这个命令返回一个空串。 
.TP
\fBinfo sharedlibextension\fR
返回在这个平台上包含共享库的文件使用的扩展名(例如，在Solaris 下是 \fB.so\fR)。如果在这个平台上不支持共享库则返回一个空串。
.TP
\fBinfo tclversion\fR
返回全局变量 \fBtcl_version \fR的值；详情参见 \fBtclvars\fR手册条目。
.TP
\fBinfo vars\fR ?\fIpattern\fR?
如果未指定 \fIpattern\fR，则返回所有当前可见的变量的名字的一个列表。包括局部变量和当前可见的全局变量。如果指定了 \fIpattern\fR，只返回匹配 \fIpattern\fR  的那些名字。使用与 \fBstring match \fR相同的规则确定匹配。\fIpattern\fR  可以是象 \fBFoo::print* \fR这样的一个限定的(qualified)名字。这样，可以使用由 \fB:: \fR分隔的名字空间的名字序列来指定一个特定的名字空间，并可以用匹配后面特定字符的模式来指定在这个名字空间中的一系列命令。如果是 \fIpattern\fR是一个限定的名字，命令名字的结果列表中的每个元素都被指定名字空间的名字所限定。

.SH "关键字 KEYWORDS"
command, information, interpreter, level, namespace, procedure, variable

.SH "[中文版维护人]"
.B 寒蝉退士
.SH "[中文版最新更新]"
.B 2001/09/28
.SH "《中国 Linux 论坛 man 手册页翻译计划》:"
.BI http://cmpp.linuxforum.net
