/* Placed in the Public Domain 2002 by Sam Trenholme */

#include <stdio.h>
#include <time.h>
#ifdef __FreeBSD__
#include <sys/time.h>
#endif
#include "MaraDNS_locale.h"
#include "../libs/JsStr.h"
#include <unistd.h>

int timestamp_type = 0;

/* Set the type of timestamp that we will display.
   Input:  The type of timestamp they want.
           0: "Timestamp: " followed by UNIX timestemp
           1: Just the UNIX timestamp
   Output: JS_SUCCESS on success; JS_ERROR on error
*/

int set_timestamp(int type) {
    if(type >= 0 && type <= 128) {
        timestamp_type = type;
        return JS_SUCCESS;
        }
    return JS_ERROR;
    }

/* Display the timestamp based on the timestamp type above
   Input: None
   Output: JS_SUCCESS
   Outputs to standard output timestamp w/o carraige return
*/


int show_timestamp() {
    fflush(stdout);
    if(timestamp_type == 0) { /* Timestamp: <unix timestamp> */
        printf("%s%d ",L_TIMESTAMP,(int)time(0));
        }
    else if(timestamp_type == 1) { /* <unix timstamp> */
        printf("%d ",(int)time(0));
        }
    /* Feel free to add other timestamp formats here.  The
       code which gets the number for the timestamp format will
       accept any numeric value. */
    else {
        printf("%s%d ",L_TIMESTAMP,(int)time(0));
        }
    return JS_SUCCESS;
    }

